/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*************************************************************************
*
* @filename  pw_scramble_example.c
*
* @purpose   Password scramble Example.
*
* @component OPEN
*
* @comments
*
* @create    2/1/2016
*
* @end
*
***************************************************************************/
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h>

#include "rpcclt_openapi.h"
#include "proc_util.h"
#include "openapi_common.h"
#include "openapi_pw_scramble.h"

/*******************************************************************
*
* @brief  This is the main function that will demonstrate 
*         pw_scramble OpEN APIs.
*
* @returns  0: Success
* @returns  1: Failure
*
********************************************************************/
int main(int argc, char **argv)
{
  openapiClientHandle_t clientHandle;
  open_error_t result = OPEN_E_FAIL;
  open_buffdesc switch_os_revision, encryptedPw, decryptedPw;
  char switch_os_revision_string[100];
  l7proc_crashlog_register();

  /* please refer to API documentation for openapiPwDecrypt() to obtain 
     sizes for these two variables */

  char encryptedPass[128 + 1] = "6ae8a168fd3449e7cf0faf020e09bffb9ade3b1b04ea8de5abc75c60ad63313211fa3ea7e6d8d3644c1d519d436b51849dbe3d99144ffa7542ea9eb8794e03aa";
  char decryptedPass[64 + 1] = "\0";

  /* Register with OpEN */
  if ((result = openapiClientRegister("pw_scramble_example", &clientHandle)) != OPEN_E_NONE)
  {
    printf("\nFailed to initialize RPC to OpEN. Exiting result = %d\n", result);
    exit(2);
  }

  /* RPC call can fail until server starts. Keep trying */
  while (openapiConnectivityCheck(&clientHandle) != OPEN_E_NONE)
  {
    sleep(1);
  }
  printf("\n");
  switch_os_revision.pstart = switch_os_revision_string;
  switch_os_revision.size = sizeof(switch_os_revision_string);
  if (openapiNetworkOSVersionGet(&clientHandle, &switch_os_revision) == OPEN_E_NONE)
  {
    printf("Network OS version = %s\n", switch_os_revision_string);
  }
  else
  {
    printf("Network OS version retrieve error\n");
  }

  encryptedPw.size = strlen(encryptedPass) + 1;
  encryptedPw.pstart = encryptedPass;

  decryptedPw.size = sizeof(decryptedPass); 
  decryptedPw.pstart = decryptedPass;

  if(openapiPwDecrypt(&clientHandle,&encryptedPw,&decryptedPw) == 0)
  {
    printf("Successful in decrypting and decrypted string is : %s \n",(char *)decryptedPw.pstart);
  }
  else
  {
    printf("Unable to decrypt\n");
  }

  /* Log goodbye message */
  L7PROC_LOGF(L7PROC_LOG_SEVERITY_INFO, 0, "Stopping Password scramble example application");

  (void) openapiClientTearDown(&clientHandle);
  return 0;
}

