/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
**********************************************************************
*
* @filename  common.c
*
* @purpose   Provides common helper functions
*
* @component OPEN
*
* @comments  These functions are used in scripting through SWIG wrappers
* 
* @create    03/10/2015
*
* @author    Partha Dutta
*
* @end
*
**********************************************************************/

#ifndef SWIG_FILE_WITH_INIT
#define SWIG_FILE_WITH_INIT 1
#endif

#ifdef L7_INSTRU_APP_PACKAGE
void GetIPPGData(OPEN_BST_INGRESS_PORT_PG_DATA_t *p, uint32_t port, uint32_t pg, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (port < OPEN_ASIC_MAX_PORTS) && (pg < OPEN_ASIC_MAX_PRIORITY_GROUPS))
  {
    count[0] = p->data[port][pg].umShareBufferCount;
    count[1] = p->data[port][pg].umHeadroomBufferCount;
  }
}
void GetIPSPData(OPEN_BST_INGRESS_PORT_SP_DATA_t *p, uint32_t port, uint32_t sp, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (port < OPEN_ASIC_MAX_PORTS) && (sp < OPEN_ASIC_MAX_SERVICE_POOLS))
  {
    count[0] = p->data[port][sp].umShareBufferCount;
  }
}
void GetISPData(OPEN_BST_INGRESS_SP_DATA_t *p, uint32_t sp, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (sp < OPEN_ASIC_MAX_INGRESS_SERVICE_POOLS))
  {
    count[0] = p->data[sp].umShareBufferCount;
  }
}
void GetEPSPData(OPEN_BST_EGRESS_PORT_SP_DATA_t *p, uint32_t port, uint32_t sp, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (port < OPEN_ASIC_MAX_PORTS) && (sp < OPEN_ASIC_MAX_SERVICE_POOLS))
  {
    count[0] = p->data[port][sp].ucShareBufferCount;
    count[1] = p->data[port][sp].umShareBufferCount;
    count[2] = p->data[port][sp].mcShareBufferCount;
    count[3] = p->data[port][sp].mcShareQueueEntries;
  }
}
void GetESPData(OPEN_BST_EGRESS_SP_DATA_t *p, uint32_t sp, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (sp < OPEN_ASIC_MAX_SERVICE_POOLS))
  {
    count[0] = p->data[sp].umShareBufferCount;
    count[1] = p->data[sp].mcShareBufferCount;
    count[2] = p->data[sp].mcShareQueueEntries;
  }
}
void GetEUCQData(OPEN_BST_EGRESS_UC_QUEUE_DATA_t *p, uint32_t eucq, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (eucq < OPEN_ASIC_MAX_UC_MC_QUEUES))
  {
    count[0] = p->data[eucq].ucBufferCount;
    count[1] = p->data[eucq].port;
  }
}
void GetEUCQGData(OPEN_BST_EGRESS_UC_QUEUEGROUPS_DATA_t *p, uint32_t eucqg, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (eucqg < OPEN_ASIC_MAX_UC_QUEUE_GROUPS))
  {
    count[0] = p->data[eucqg].ucBufferCount;
  }
}
void GetEMCQData(OPEN_BST_EGRESS_MC_QUEUE_DATA_t *p, uint32_t emcq, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (emcq < OPEN_ASIC_MAX_UC_MC_QUEUES))
  {
    count[0] = p->data[emcq].mcBufferCount;
    count[1] = p->data[emcq].mcQueueEntries;
    count[2] = p->data[emcq].port;
  }
}
void GetECPUQData(OPEN_BST_EGRESS_CPU_QUEUE_DATA_t *p, uint32_t cpuq, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (cpuq < OPEN_ASIC_MAX_CPU_QUEUES))
  {
    count[0] = p->data[cpuq].cpuBufferCount;
    count[1] = p->data[cpuq].cpuQueueEntries;
  }
}
void GetERQEData(OPEN_BST_EGRESS_RQE_QUEUE_DATA_t *p, uint32_t rqeq, uint32_t *count) 
{
  if ((p != NULL) && (count != NULL) &&
      (rqeq < OPEN_ASIC_MAX_RQE_QUEUES))
  {
    count[0] = p->data[rqeq].rqeBufferCount;
    count[1] = p->data[rqeq].rqeQueueEntries;
  }
}
#endif
