-------------------------------------------------------------------------------
-- RESTful vlan read
--
-- @copyright Copyright 2016-2018 Broadcom.
--
-- @author    darsen
--
-- @release   12-May-2014
-------------------------------------------------------------------------------

OpEN = require("OpEN_Lua")

local Utilities = {fd=nil, level=0} -- The main table
local client

-- Establish connection and register to the RPC
-- return client handle which is used throughout OpEN
--
function Utilities.connect(clientName)
  local maxtries = 100
  client = OpEN.openapiClientHandle_s()

  local ret = OpEN.openapiClientRegister(clientName, client)
  if ret == LUA_OPEN_E_NONE then
    ret = OpEN.openapiConnectivityCheck(client)
    local count = 0
    while ret ~= LUA_OPEN_E_NONE and count < maxtries do
      count = count + 1
      os.execute("sleep 1")
      ret = OpEN.openapiConnectivityCheck(client)
    end
  end

  if ret == LUA_OPEN_E_NONE then
    return client
  else
    return nil
  end
end

-- Terminate connection as we should release our RPC resources.
--
function Utilities.close(client)
   OpEN.openapiClientTearDown(client)
end

-- Helper function in that it returns the version in dot-notation
--
function Utilities.getAPIVersion(client)
  local revData = OpEN.open_revision_data_t()

  local ret = OpEN.openapiApiVersionGet(client, revData)
  if ret == LUA_OPEN_E_NONE then
    return string.format("%d.%d.%d.%d", revData.release, revData.version, revData.maint_level, revData.build_num)
  else
    return nil
  end
end

function Utilities.getCharBuffer(size, init)
  ret = OpEN.charArray(size+1)

  if init then
    if string.len(init) > size then
      count = size
    else
      count = string.len(init)
    end

    for x = 0, count-1 do
      ret[x] = string.sub(init,x+1)
    end
    ret[count] = '\0'

  else
    for x = 0, size do
      ret[x] = '\0'
    end
  end

  return ret
end

-- Logging functions
--

function Utilities.logInit(path)
   if path == nil then
      path = "/tmp/logs/swiglua.log"
   end
   Utilities.fd = io.open(path, "w+")
end

function Utilities.logSetLevel(level)
   Utilities.level = level
end

function Utilities.logClose()
   if Utilities.fd ~= nil then
      Utilities.fd:close()
   end
   Utilities.fd = nil
   Utilities.level = 0
end

function Utilities.logWrite(level, msg)
   if Utilities.fd ~= nil and level >= Utilities.level then
     Utilities.fd:write(msg)
   end
end

return Utilities


--[[



  def getUCharBuffer(size, init=nil)
    ret = OpEN::UcharArray.new(size)
    if init != nil
      if init.length > size
        count = size
      else
        count = init.length
      end      
      for x in 0..count-1
        if init[x] != nil
          ret[x] = init[x]
        end
      end
      ret[count] = 0
    else
      for x in 0..size-1
        ret[x] = 0
      end
    end
    return ret
  end

  def getIntBuffer(size)
    ret = OpEN::IntArray.new(size)
    return ret
  end

  def getNetworkOSVersion()
    size = 100
    switch_os_revision_string = getCharBuffer(size, nil)
    switch_os_revision = OpEN::Open_buffdesc.new
    switch_os_revision.pstart = switch_os_revision_string
    switch_os_revision.size = size 
    ret = OpEN::openapiNetworkOSVersionGet(@client, switch_os_revision)
    if ret != OpEN::OPEN_E_NONE
      puts "Network OS version retrieve error"
    else
      printf "Network OS version %s\n", switch_os_revision_string.cast()
    end
  end

  def terminate()
  end
end
--]]

