/**********************************************************************
*
*  Copyright 2023 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
***********************************************************************
*
* @filename  openapi_diffservconf.h
*
* @purpose   This code implements the OpEN Diff Serv configuration API
*
* @component OPEN
*
* @create    05/18/2023
*
* @end
*
*********************************************************************/
#ifndef OPENAPI_DIFFSERVCONF_H_INCLUDED
#define OPENAPI_DIFFSERVCONF_H_INCLUDED

#include "openapi_common.h"

/** Enumerated values for DiffServ General Status Group objects */
typedef enum
{
  OPEN_DIFFSERV_GEN_STATUS_TABLE_NONE = 0,              /**< None */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_CLASS_SIZE,            /**< Class table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_CLASS_MAX,             /**< Max class table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_CLASS_RULE_SIZE,       /**< Class rule table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_CLASS_RULE_MAX,        /**< Max class rule table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_POLICY_SIZE,           /**< Policy table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_POLICY_MAX,            /**< Max policy table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_POLICY_INST_SIZE,      /**< Policy-class instance table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_POLICY_INST_MAX,       /**< Max policy-class instance tablesize */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_POLICY_ATTR_SIZE,      /**< Policy attribute table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_POLICY_ATTR_MAX,       /**< Max policy attribute table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_SERVICE_SIZE,          /**< Service table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_SERVICE_MAX,           /**< Max service table size */
  OPEN_DIFFSERV_GEN_STATUS_TABLE_TOTAL
} OPEN_DIFFSERV_GEN_STATUS_GROUP_OBJECT_t;


/*****************************************************************************
 * @purpose   Set the value of the DiffServ administrative mode.
 *
 * @param     client_handle  @b{(input)}  client handle from registration API
 * @param     mode           @b{(input)}  DiffServ administrative mode [Enable/Disable]
 *
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     This API sets DiffServ administrative mode.
 * @notes     Calling this API will change the running configuration of the switch.
 *
 * @supported-in-version OpEN API Version: 1.26
 *
 * @end
 *****************************************************************************/
open_error_t
openapiDiffServGenAdminModeSet(openapiClientHandle_t *client_handle,
                               OPEN_CONTROL_t mode);

/*****************************************************************************
 * @purpose   Gets admin mode of DiffServ administrative.
 *
 * @param     client_handle    @b{(input)}  client handle from registration API
 * @param     pMode            @b{(output)} DiffServ administrative mode [Enable/Disable]
 *
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     This API fetches DiffServ administrative admin mode state
 *
 * @supported-in-version OpEN API Version: 1.26
 *
 * @end
 *****************************************************************************/
open_error_t
openapiDiffServGenAdminModeGet(openapiClientHandle_t *client_handle,
                               OPEN_CONTROL_t *pMode);

/*****************************************************************************
 * @purpose   Get size of the given group Table.
 *
 * @param     client_handle    @b{(input)}  client handle from registration API
 * @param     diffTableGrpObj  @b{(input)}  DiffServ general status table group object
 * @param     pSize            @b{(output)} table size value
 *
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     This API fetches size of given group Table.
 *
 * @supported-in-version OpEN API Version: 1.26
 *
 * @end
 *****************************************************************************/
open_error_t
openapiDiffServGenTableSizeGet(openapiClientHandle_t *client_handle,
                               OPEN_DIFFSERV_GEN_STATUS_GROUP_OBJECT_t diffTableGrpObj,
                               uint32_t *pSize);

#endif /* OPENAPI_DIFFSERVCONF_H_INCLUDED */

