/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
**********************************************************************
*
* @filename  openapi_pw_scramble.h
*
* @purpose   Provide an external API to applications in other processes
*            access to the Password Scramble utility to re-arrange the
*            bits in a password.
*
* @component OpEN
*
* @comments  This code implements the RPC accessible function calls
*            to the Password Scramble utility to re-arrange the
*            bits in a password.
* 
*            Type translation between external and internal name spaces
*            occurs here.
*
* @create    10/22/2015
*
* @end
*
**********************************************************************/

#include "openapi_common.h"

/*********************************************************************
* @purpose  Decrypt encrypted password
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    encryptedPw      @b{(input)}  Pointer to encrypted password string storage
*           -                             Buffer allocated size must be at least
*           -                             @ref OPENAPI_ENCRYPTED_PASSWORD_SIZE
* @param    decryptedPw      @b{(output)} Pointer to dencrypted password string storage
*           -                             Buffer allocated size must be at least
*           -                             @ref OPENAPI_DECRYPTED_PASSWORD_SIZE
*
* @notes    Use @ref openapiPwLimitsGet to retrieve the values of @ref OPENAPI_ENCRYPTED_PASSWORD_SIZE
*           and @ref OPENAPI_DECRYPTED_PASSWORD_SIZE
*
* @returns  OPEN_E_NONE      if successful
* @returns  OPEN_E_FAIL      if operation failed
* @returns  OPEN_E_PARAM     if an invalid parameter was supplied 
*
* @notes
*
* @supported-in-version OpEN API Version: 1.8
*
* @end
*********************************************************************/

open_error_t openapiPwDecrypt(openapiClientHandle_t *client_handle,
                              open_buffdesc *encryptedPw,
                              open_buffdesc *decryptedPw);
