/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  openapi_suppfile.h
*
* @purpose   Serviceability: Support File APIs 
*
* @component OpEN
*
* @create    01/11/2015
*
* @end
*                                    
**********************************************************************/
#ifndef OPENAPI_SUPPFILE_H_INCLUDED
#define OPENAPI_SUPPFILE_H_INCLUDED

#include "openapi_common.h"

/********************************************************************* 
* @purpose  Generate the support file on the switch.
* 
* @param    client_handle       @b{(input)}  Client handle from registration API.
* @param    outfileName         @b{(output)} Support file name output buffer descriptor.
*
* @returns  OPEN_E_NONE         Successfully generated support file.
* @returns  OPEN_E_PARAM        Error in parameter passed.
* @returns  OPEN_E_UNAVAIL      Operation not supported on this platform.
* @returns  OPEN_E_FAIL         Failed to create support file.
* 
* @notes    Technical support data is written to a file whose full pathname
*           is output through the outfileName parameter. Use 
*           openapiSystemFileNameMaxLengthGet() to determine the appropriate
*           sized buffer to use.
* 
* @notes    This API may take a relatively long time to complete,
*           on the order of 30 to 60 seconds, due to the amount
*           of data it collects.
* 
* @supported-in-version OpEN API Version: 1.6
*
* @end
*********************************************************************/
open_error_t openapiSupportFileGenerate(openapiClientHandle_t *client_handle,
                                        open_buffdesc *outfileName);

#endif /* OPENAPI_SUPPFILE_H_INCLUDED */
