import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

class BridgeExample :
  def __init__(self, client) :
    self.m_client = client

  def dot1d_base_bridge_address_get (self, bridgeAddress) :
      result = OpEN.openapiDot1dBaseBridgeAddressGet(self.m_client, bridgeAddress)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def dot1d_base_type_get (self, bridgeDigit) :
      result = OpEN.openapiDot1dBaseTypeGet(self.m_client, bridgeDigit)
      if (result == OpEN.OPEN_E_NONE) :
       return 0
      elif (result == OpEN.OPEN_E_FAIL) :
       return -1
      elif (result == OpEN.OPEN_E_ERROR) :
       return -2
      else :
       return -3

  def dot1d_base_num_ports_get (self, bridgeDigit) :
      result = OpEN.openapiDot1dBaseNumPortsGet(self.m_client, bridgeDigit)
      if (result == OpEN.OPEN_E_NONE) :
       return 0
      elif (result == OpEN.OPEN_E_FAIL) :
       return -1
      elif (result == OpEN.OPEN_E_ERROR) :
       return -2
      else :
       return -3

  def dot1d_base_num_ports_entry_get (self, bridgeDigit) :
      result = OpEN.openapiDot1dBasePortEntryGet(self.m_client, bridgeDigit)
      if (result == OpEN.OPEN_E_NONE) :
       return 0
      elif (result == OpEN.OPEN_E_FAIL) :
       return -1
      else :
       return -2

  def dot1d_base_port_if_index_get (self, numPorts, bridgeDigit) :
      result = OpEN.openapiDot1dBasePortIfIndexGet(self.m_client, numPorts, bridgeDigit)
      if (result == OpEN.OPEN_E_NONE) :
       return 0
      elif (result == OpEN.OPEN_E_FAIL) :
       return -1
      elif (result == OpEN.OPEN_E_ERROR) :
       return -2
      else :
       return -3

  def dot1d_base_port_delay_exceeded_discards_get (self, numPorts, bridgeDigit) :
      result = OpEN.openapiDot1dBasePortDelayExceededDiscardsGet(self.m_client, numPorts, bridgeDigit)
      if (result == OpEN.OPEN_E_NONE) :
       return 0
      elif (result == OpEN.OPEN_E_FAIL) :
       return -1
      elif (result == OpEN.OPEN_E_ERROR) :
       return -2
      elif (result == OpEN.OPEN_E_UNAVAIL) :
       return -3
      else :
       return -4

  def dot1d_stp_protocol_get (self, bridgeDigit) :
      result = OpEN.openapiDot1dStpProtocolSpecificationGet(self.m_client, bridgeDigit)
      if (result == OpEN.OPEN_E_NONE) :
       return 0
      elif (result == OpEN.OPEN_E_UNAVAIL) :
       return -1
      else :
       return -2

  def dot1d_stp_hello_time_get (self, bridgeDigit) :
      result = OpEN.openapiDot1dStpBridgeHelloTimeGet(self.m_client, bridgeDigit)
      if (result == OpEN.OPEN_E_NONE) :
       return 0
      elif (result == OpEN.OPEN_E_UNAVAIL) :
       return -1
      else :
       return -2

  def dot1d_stp_port_state_get (self, numPorts, bridgeDigit) :
      result = OpEN.openapiDot1dStpPortStateGet(self.m_client, numPorts, bridgeDigit)
      if (result == OpEN.OPEN_E_NONE) :
       return 0
      elif (result == OpEN.OPEN_E_UNAVAIL) :
       return -1
      else :
       return -2

def main() :
    """Demonstrate OpEN usage for STP(DOT1S) APIs"""
    ret = open_.connect("bridge_example")
    if ret == OpEN.OPEN_E_NONE :
      open_.getNetworkOSVersion()
      client = open_.get_client()
      
      example = BridgeExample(client)
      string = OpEN.open_buffdesc()
      try:
        name_string = open_.getStringBuffer(40, '')
      except OpENBufferSizeError:
        print("main: getStringBuffer raised OpENBufferSizeError")
        return
      except TypeError:
        print("main: getStringBuffer raised TypeError")
        return
      string.pstart = name_string
      string.size = 40
      bridgeDigit = OpEN.new_uint32_tp()
      numPorts = OpEN.new_uint32_tp()

      if (example.dot1d_base_bridge_address_get(string) != 0) :
       print("Bad return code when we are trying to get the unique MAC address.")
      else:
       print("Bridge MAC address is: %s" % (name_string.cast()))

      result = example.dot1d_base_type_get(bridgeDigit)
      if (result == 0) :
       print("Bridge base type is: %s." % (OpEN.uint32_tp_value(bridgeDigit)))
      elif (result == -1) :
       print("Bad return code when we are trying to get base type of bridging. Returned values are invalid.")
      elif (result == -2) :
       print("Bad return code when we are trying to get base type of bridging. Counter requested does not exist.")
      else :
       print("Bad return code when we are trying to get base type of bridging. Error in parameter passed.")
 
      result = example.dot1d_base_num_ports_get(numPorts)
      if (result == 0) :
       result = example.dot1d_base_num_ports_entry_get(OpEN.uint32_tp_value(numPorts))
       if (result == 0) :
        print("Number of ports controlled by bridging entity is: %s." % (OpEN.uint32_tp_value(numPorts)))
       elif (result == -1) :
        print("Bad return code when we are trying to get number of ports controlled by bridging entity Returned values are invalid.")
       else :
        print("Bad return code when we are trying to get base type of bridging. Error in parameter passed.")
      elif (result == -1) :
       print("Bad return code when we are trying to get number of ports controlled by bridging entity. Returned values are invalid.")
      elif (result == -2) :
       print("Bad return code when we are trying to get number of ports controlled by bridging entity. Counter requested does not exist.")
      else :
       print("Bad return code when we are trying to get number of ports controlled by bridging entity. Error in parameter passed.")

      numPortsValue = OpEN.uint32_tp_value(numPorts)
      result = example.dot1d_base_port_if_index_get(numPortsValue, bridgeDigit)
      if (result == 0) :
       print("Interface index is: %s." % (OpEN.uint32_tp_value(bridgeDigit)))
      elif (result == -1) :
       print("Bad return code when we are trying to get interface index. Returned values are invalid.")
      elif (result == -2) :
       print("Bad return code when we are trying to get interface index. Counter requested does not exist.")
      else :
       print("Bad return code when we are trying to get interface index. Error in parameter passed.")

      result = example.dot1d_base_port_delay_exceeded_discards_get(numPortsValue, bridgeDigit)
      if (result == 0) :
       print("Number of frames discarded by this port due to delay through the bridge is: %s." % (OpEN.uint32_tp_value(bridgeDigit)))
      elif (result == -1) :
       print("Bad return code when we are trying to get number of frames. Returned values are invalid.")
      elif (result == -2) :
       print("Bad return code when we are trying to get number of frames. Returned values are invalid.")
      elif (result == -3) :
       print("Feature is not supported.")
      else  :
       print("Error in parameter passed.")

      text = ''        
      result = example.dot1d_stp_protocol_get(bridgeDigit)
      if (result == 0) :
       if (OpEN.uint32_tp_value(bridgeDigit) == OpEN.OPEN_STP_PROTOCOL_SPEC_IEEE8021D) :
        text = "IEEE8021D(dot1dBridge)."
       elif (OpEN.uint32_tp_value(bridgeDigit) == OpEN.OPEN_STP_PROTOCOL_SPEC_UNKNOWN) :
        text = "Unknown."
       else :
        text = "Error."
       print("STP protocol is: %s" % (text))
      elif (result == -2) :
       print("Parameter/feature is not supported.")
      else :
       print("Error in parameter passed.")

      result = example.dot1d_stp_hello_time_get(bridgeDigit)
      if (result == 0) :
       print("STP bridge hello time is: %s." % (OpEN.uint32_tp_value(bridgeDigit)))
      elif (result == -1) :
       print("Parameter/feature is not supported.")
      else:
       print("Error in parameter passed.")

      result = example.dot1d_stp_port_state_get(numPortsValue, bridgeDigit)
      if (result == 0) :
       bridgeDigitValue = OpEN.uint32_tp_value(bridgeDigit)
       if (bridgeDigitValue == OpEN.OPEN_DOT1D_BLOCKING) :
        text = "Blocking."
       elif (bridgeDigitValue == OpEN.OPEN_DOT1D_LISTENING) :
        text = "Listening."
       elif (bridgeDigitValue == OpEN.OPEN_DOT1D_LEARNING) :
        text = "Learning."
       elif (bridgeDigitValue == OpEN.OPEN_DOT1D_FORWARDING) :
        text = "Forwarding."
       elif (bridgeDigitValue == OpEN.OPEN_DOT1D_DISABLED) :
        text = "Disabled."
       elif (bridgeDigitValue == OpEN.OPEN_DOT1D_MANUAL_FWD) :
        text = "Manual FWD."
       elif (bridgeDigitValue == OpEN.OPEN_DOT1D_NOT_PARTICIPATE) :
        text = "Participate."
       else :
        text = "Error."
       print("STP port state is: %s" % (text))
      elif (result == -1) :
       print("Parameter/feature is not supported.")
      else :
       print("Error in parameter passed.")

      OpEN.delete_uint32_tp(bridgeDigit)
      OpEN.delete_uint32_tp(numPorts)
    else :
      print("Unable to connect.")
    open_.terminate()
if __name__ == '__main__': main()

