#
# Cookbook Name:: boa
#
# Copyright 20162018 Broadcom.
#
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

name             'boa'
maintainer       'Broadcom'
maintainer_email 'support@broadcom.com'
license          'All rights reserved'
description      'Installs/Configures boa'
long_description IO.read(File.join(File.dirname(__FILE__), 'README.md'))
version          '0.1.2'

recipe "vlan",
  "Manages vlan resources on NOS based devices"

attribute 'boa/providers/vlan',
  :display_name => "Provider for boa_vlan LWRP",
  :description => "Creates/Edits VLANs and adds port participation on NOS based devices",
  :type => "string",
  :required => "required",
  :recipes => [ 'boa::vlan' ],
  :default => 'boa_vlan'

attribute 'boa/providers/logging',
  :display_name => "Provider for boa_vlan LWRP",
  :description => "Creates/Edits syslog server on NOS based devices",
  :type => "string",
  :required => "required",
  :recipes => [ 'boa::logging' ],
  :default => 'boa_logging'

attribute 'boa/providers/statistics',
  :display_name => "Provider for boa_statistics LWRP",
  :description => "Prints port counters/statistics and resets counters on interface 1 and 2 on NOS based devices",
  :type => "string",
  :required => "required",
  :recipes => [ 'boa::statistics' ],
  :default => 'boa_statistics'

attribute 'boa/providers/authentication',
  :display_name => "Provider for boa_authentication LWRP",
  :description => "Creates authentication lists and sets line methods on NOS based devices",
  :type => "string",
  :required => "required",
  :recipes => [ 'boa::authentication' ],
  :default => 'boa_authentication'

attribute 'boa/providers/accounting',
  :display_name => "Provider for boa_accounting LWRP",
  :description => "Creates accounting lists and sets methods on NOS based devices",
  :type => "string",
  :required => "required",
  :recipes => [ 'boa::accounting' ],
  :default => 'boa_accounting'

