#!/mnt/fastpath/usr/bin/python

"""instru_packet_trace_example.py: OpEN API Instrumentation Packet Trace example"""

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License")
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

#
# Python 2.6.6
#

# Define some constants for comparison convenience

import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

class PacketTraceExample:
  def __init__(self, client):
    self.m_client = client

  def packetTraceExampleUsage(self):

    packetData_p = OpEN.new_OPEN_PT_PACKET_tp()
    traceProfile_p = OpEN.new_OPEN_PT_TRACE_PROFILE_tp()
    time_p = OpEN.new_time_tp()
    asic = 0;
    port = 1234;
                  
    result = OpEN.openapiPtTraceProfileGet(self.m_client, asic, port, packetData_p, traceProfile_p, time_p)
    if result == OpEN.OPEN_E_NONE:
      print("Success to get trace profile.")
    else:
      print("Bad return code trying to get trace profile. result = %d" % (result))

    OpEN.delete_OPEN_PT_PACKET_tp(packetData_p)
    OpEN.delete_OPEN_PT_TRACE_PROFILE_tp(traceProfile_p)
    OpEN.delete_time_tp(time_p)


def main():
  """Demonstrate OpEN usage for Packet Trace APIs"""

  open = OpENUtil()
  ret = open.connect("instru_packet_trace_example")
  if ret == OpEN.OPEN_E_NONE :
    open.getNetworkOSVersion()
    open.getAPIVersion()
    client = open.get_client()
    packetTraceExample = PacketTraceExample(client)
    packetTraceExample.packetTraceExampleUsage()
    open.terminate()
  else:
    print("Unable to connect")

if __name__ == '__main__': main()

