import OpEN_py as OpEN
from OpENUtil import *
import sys

open_ = OpENUtil()

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

class MFDBExample :
  def __init__(self, client) :
    self.m_client = client

  def mfdb_entry_get_next (self, vidMac, nextProt) :
      result = OpEN.openapiMfdbEntryGetNext(self.m_client, vidMac, nextProt)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def mfdb_entry_data_get (self, vidMac, nextProt, mac, vlanId, compId, type, desc, frwdIntMask, fltIntMask, absPortMask) :
      result = OpEN.openapiMfdbEntryDataGet(self.m_client, vidMac, nextProt, mac, vlanId, compId, type, desc, frwdIntMask, fltIntMask, absPortMask)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def mfdb_curr_entries_get (self, currEntries) :
      result = OpEN.openapiMfdbCurrEntriesGet(self.m_client, currEntries)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

def main() :
  """Demonstrate OpEN usage for MFDB APIs"""
  ret = open_.connect("mirror_example")
  if ret == OpEN.OPEN_E_NONE :
    open_.getNetworkOSVersion()
    client = open_.get_client()
    example = MFDBExample(client)

    string = OpEN.open_buffdesc()
    init = '00:00:00:00:00:00:00:00'
    try:
      name_string = open_.getStringBuffer(OpEN.OPEN_MFDB_VIDMAC_LENGTH, init)
    except TypeError:
      print("received a TypeError exception from getStringBuffer")
      sys.exit(1)
    except OpENBufferSizeError:
      print("received an OpENBufferSizeError exception")
      sys.exit(1)
      
    string.pstart = name_string
    string.size = OpEN.OPEN_MFDB_VIDMAC_LENGTH

    mac = OpEN.open_buffdesc()
    try:
      mac_string = open_.getStringBuffer(OpEN.OPEN_MFDB_MAC_LENGTH, '')
    except TypeError:
      print("received a TypeError exception from getStringBuffer")
      sys.exit(1)
    except OpENBufferSizeError:
      print("received an OpENBufferSizeError exception")
      sys.exit(1)
    mac.pstart = mac_string
    mac.size = OpEN.OPEN_MFDB_MAC_LENGTH

    currEntries = OpEN.new_uint32_tp()
    vlanId = OpEN.new_uint32_tp()

    descr = OpEN.open_buffdesc()
    try:
      dsecr_string = open_.getStringBuffer(OpEN.OPENAPI_MFDB_DESCR_LEN, '')
    except TypeError:
      print("received a TypeError exception from getStringBuffer")
      sys.exit(1)
    except OpENBufferSizeError:
      print("received an OpENBufferSizeError exception")
      sys.exit(1)
    descr.pstart = dsecr_string
    descr.size = OpEN.OPEN_MFDB_MAC_LENGTH

    frwdIntMask = OpEN.open_buffdesc()
    try:
      frwdIntMask_string = open_.getStringBuffer(OpEN.OPEN_MFDB_INTF_LIST_LENGTH, '')
    except TypeError:
      print("received a TypeError exception from getStringBuffer")
      sys.exit(1)
    except OpENBufferSizeError:
      print("received an OpENBufferSizeError exception")
      sys.exit(1)
    frwdIntMask.pstart = frwdIntMask_string
    frwdIntMask.size = OpEN.OPEN_MFDB_INTF_LIST_LENGTH

    fltIntMask = OpEN.open_buffdesc()
    try:
      fltIntMask_string = open_.getStringBuffer(OpEN.OPEN_MFDB_INTF_LIST_LENGTH, '')
    except TypeError:
      print("received a TypeError exception from getStringBuffer")
      sys.exit(1)
    except OpENBufferSizeError:
      print("received an OpENBufferSizeError exception")
      sys.exit(1)
    fltIntMask.pstart = fltIntMask_string
    fltIntMask.size = OpEN.OPEN_MFDB_INTF_LIST_LENGTH

    absPortMask = OpEN.open_buffdesc()
    try:
      absPortMask_string = open_.getStringBuffer(OpEN.OPEN_MFDB_INTF_LIST_LENGTH, '')
    except TypeError:
      print("received a TypeError exception from getStringBuffer")
      sys.exit(1)
    except OpENBufferSizeError:
      print("received an OpENBufferSizeError exception")
      sys.exit(1)
    absPortMask.pstart = absPortMask_string
    absPortMask.size = OpEN.OPEN_MFDB_INTF_LIST_LENGTH

    nextProt = OpEN.new_OPEN_MFDB_PROTOCOL_TYPE_tp()
    compId = OpEN.new_OPEN_MFDB_PROTOCOL_TYPE_tp()

    type = OpEN.new_OPEN_MFDB_ENTRY_TYPE_tp()

    if (example.mfdb_entry_get_next(string, nextProt) != 0) :
      print("Failed to retrieve the first entry in the MFDB table.")
    else:
      print("The first entry in the MFDB table is %s" % (name_string.cast()))
      tempNextProt = OpEN.OPEN_MFDB_PROTOCOL_TYPE_tp_value(nextProt)
      if (example.mfdb_entry_data_get(string, tempNextProt, mac, vlanId, compId, type, descr, frwdIntMask, fltIntMask, absPortMask)) :
        print("Data of entry %s" % (name_string.cast()))
        print("   MAC address: %s" % (mac_string.cast()))
        print("   VLAN ID: %d" % (OpEN.uint32_tp_value(vlanId)))
        print("   component ID: %d" % (OpEN.OPEN_MFDB_PROTOCOL_TYPE_tp_value(compId)))
        print("   description: %s" % (descr_string.cast()))
        print("   forward interface mask: %s" % (frwdIntMask_string.cast()))
        print("   filter interface mask: %s" % (fltIntMask_string.cast()))
        print("   absolute port mask: %s" % (absPortMask_string.cast()))
      else :
        print("Failed to retrieve the data for entry in the MFDB table.")

    if (example.mfdb_curr_entries_get(currEntries) != 0) :
      print("Failed to retrieve the number of current entries in the MFDB table.")
    else :
      print("The number of current entries in the MFDB table is %d." % (OpEN.uint32_tp_value(currEntries)))

  else :
    print("Unable to connect.")
  open_.terminate()
if __name__ == '__main__': main()

