/*********************************************************************
*
* Copyright 2016-2017 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  bfd_delete.c
*
* @purpose Delete BFD session with specified session ID.
*
* @component OPEN
*
* @comments
*
* @create    09/09/2015
*
* @end
*
**********************************************************************/
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <signal.h>
#include <stdlib.h>
#include <pthread.h>
#include <fcntl.h>
#include <unistd.h>
#include <netdb.h>
#include <sys/ioctl.h>
#include <linux/if.h>
#include <linux/if_packet.h>
#include <sys/errno.h>
#include <ctype.h>

#include "rpcclt_openapi.h"
#include "proc_util.h"
#include "openapi_common.h"
#include "openapi_routing.h"
#include "openapi_mpls.h"


openapiClientHandle_t clientHandle;

/*********************************************************************
* @purpose  Delete a BFD session
*
* @param    client_handle    @b{(input)}   client handle from registration API
* @param    session_id       @b{(input)}   BFD Session ID to be deleted.
*
* @returns  none
*
* @notes  
*
* @end
*********************************************************************/
void rtrBfdSessionDelete(openapiClientHandle_t *client_handle, uint32_t session_id)
{
  open_error_t rc;
  openBfdEndpoint_t ep;

  memset(&ep, 0x0, sizeof(ep));

  rc = openapiBfdSessionDelete(client_handle, &ep, session_id);
 
  if (rc == OPEN_E_NONE)
  {
    printf("Successfully deleted BFD session %d\n", session_id);
  }
  else
  {
    printf("Failed to delete BFD session %d  rc=%d\n", session_id, rc);
  }
}

int main(int argc, char **argv)
{
  int rc;
  uint32_t session_id;

  if (argc != 2)
  {
    printf ("Usage: bfd_delete <session-id>\n");
    exit (1);
  }
  session_id = atoi (argv[1]);

  /* Register with OpEN */
  if ((rc = openapiClientRegister("bfd_delete", &clientHandle)) != OPEN_E_NONE)
  {
    printf("\nFailed to initialize RPC to OpEN. Exiting (result = %d)\n", rc);
    exit(2);
  }

  /* RPC call can fail until server starts. Keep trying */
  while (openapiConnectivityCheck(&clientHandle) != OPEN_E_NONE)
  {
    sleep(1);
  }

  rtrBfdSessionDelete(&clientHandle, session_id); 
 
  (void) openapiClientTearDown (&clientHandle);

  return 0;
}


