#!/usr/local/bin/perl
#
# Copyright 2016-2017 Broadcom
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

use File::Path;
use Shell;

my $root_dir = "../..";
my $openapi_inc_all = $root_dir . "/rpc/rpccom_openapi_all_incl.h"; 
my @openapi_include_files = &get_openapi_include_files;
my @rpc_header_files = ("proc_util.h","rpcclt_openapi.h","rpcclt_openapi_map.h","rpccom_openapi_all_incl.h","rpccom_openapi.h");
my @rpc_include_files = &get_rpc_include_files;
my $helper_function_file = $root_dir . "/swig/common/common.c";
my $helper_include_file = $root_dir . "/swig/common/instru.h";

my $swig_helper_common_functions = q'';
my $swig_helper_common_include = q'';
my $swig_helper_pointer_functions = q'';
my $swig_helper_ft_pointer_functions = q'';
my $swig_helper_dhcps_pointer_functions = q'';

my $swig_related_content = q'
%typemap(in) unsigned char[((OPEN_EVENT_LAST) / 8) + 1] (unsigned char tmp[((OPEN_EVENT_LAST) / 8) + 1]) {
$1 = &tmp[0];
memset((void *) $1, 0, ((OPEN_EVENT_LAST) / 8) + 1);
memcpy((void *) $1, (void *) PyString_AsString($input), strlen(PyString_AsString($input)));
}
%{
void buf_to_open_sysExtAgentPktRxDesc_t(char *buf, open_sysExtAgentPktRxDesc_t* dst)
{
  memcpy((char*)dst ,(char*)buf, sizeof(open_sysExtAgentPktRxDesc_t));
}
%}
%include "stdint.i"
%include "cpointer.i"
%pointer_functions(uint8_t, uint8_tp);
%pointer_functions(uint16_t, uint16_tp);
%pointer_functions(uint32_t, uint32_tp);
%pointer_functions(uint64_t, uint64_tp);
%pointer_functions(int8_t, int8_tp);
%pointer_functions(int16_t, int16_tp);
%pointer_functions(int32_t, int32_tp);
%pointer_functions(int64_t, int64_tp);
%pointer_functions(bool, bool_tp);
%pointer_functions(OPEN_TCAM_API_POLICYID_t, OPEN_TCAM_API_POLICYID_tp);
%pointer_functions(OPEN_VLAN_LIST_t, OPEN_VLAN_LIST_tp);
%pointer_functions(open_sysExtAgentPktRxDesc_t, open_sysExtAgentPktRxDesc_tp);
%pointer_functions(open_in6_addr_t, open_in6_addr_tp);
%pointer_functions(OPEN_DHCP_SNOOP_BINDING_t, OPEN_DHCP_SNOOP_BINDING_tp);
%pointer_functions(OPEN_DHCP_V6_SNOOP_BINDING_t, OPEN_DHCP_V6_SNOOP_BINDING_tp);

#if defined(L7_DOT1AD_PACKAGE)
%pointer_functions(OPEN_DOT1AD_SVCTYPE_t, OPEN_DOT1AD_SVCTYPE_tp);
%pointer_functions(OPEN_DOT1AD_PKTTYPE_t, OPEN_DOT1AD_PKTTYPE_tp);
%pointer_functions(OPEN_DOT1AD_INTERFACE_TYPE_t, OPEN_DOT1AD_INTERFACE_TYPE_tp);
#endif
#if L7_TIMERANGES_PACKAGE
%pointer_functions(OPEN_TIMERANGE_PERIODIC_ENTRY_t, OPEN_TIMERANGE_PERIODIC_ENTRY_tp);
#endif
#if L7_SNMP_PACKAGE
%pointer_functions(OPEN_SNMP_COMMUNITY_t, OPEN_SNMP_COMMUNITY_tp);
%pointer_functions(OPEN_SNMP_TRAP_CONFIG_t, OPEN_SNMP_TRAP_CONFIG_tp);
#endif
%include "carrays.i"
%array_functions(uint32_t, uint32_tArray);
%array_functions(uint16_t, uint16_tArray);
%array_functions(uint8_t, uint8_tArray);
%array_class(int, intArray);
%array_class(char, charArray);
%array_class(unsigned char, ucharArray);
%array_functions(OPEN_BOOL_t, OPEN_BOOL_tArray)
%array_functions(openapiTrapLogEntry_t, openapiTrapLogEntry_tArray)
#if defined(L7_GREEN_ETHERNET_PACKAGE)
%array_functions(openGreenPwrHistoryIntfEntry_t, openGreenPwrHistoryIntfEntry_tArray);
#endif
';

if ($ENV{'BLD_L7_COMPONENTS_ACL'} == 1)
{
  $swig_acl_helper_functions = q'
%pointer_functions(OPEN_ACL_VLAN_LIST_INFO_t, OPEN_ACL_VLAN_LIST_INFO_tp);
%pointer_functions(OPEN_ACL_INTF_LIST_INFO_t, OPEN_ACL_INTF_LIST_INFO_tp);
%pointer_functions(openIpAclRulesFields_t, openIpAclRulesFields_tp);
%pointer_functions(openMacAclRulesFields_t, openMacAclRulesFields_tp);
%array_functions(OPEN_ACL_VLAN_LIST_INFO_t, OPEN_ACL_VLAN_LIST_INFO_tArray);
%array_functions(OPEN_ACL_INTF_LIST_INFO_t, OPEN_ACL_INTF_LIST_INFO_tArray);
  ';
}

if ($ENV{'BLD_L7_COMPONENTS_DHCPS'} == 1)
{
  $swig_helper_dhcps_pointer_functions = q'
%pointer_functions(openDhcpsDefaultRouters_t, openDhcpsDefaultRouters_tp);
%pointer_functions(openDhcpsDnsServers_t, openDhcpsDnsServers_tp);
%pointer_functions(openDhcpsNetbiosServers_t, openDhcpsNetbiosServers_tp);
%pointer_functions(openDhcpsNtpServers_t, openDhcpsNtpServers_tp);
%pointer_functions(OPEN_DHCP_SERVER_POOL_NAME_t, OPEN_DHCP_SERVER_POOL_NAME_tp);
%pointer_functions(OPEN_DHCP_SERVER_POOL_VRF_NAME_t, OPEN_DHCP_SERVER_POOL_VRF_NAME_tp);
%pointer_functions(OPEN_DHCP_SERVER_CLIENT_ID_t, OPEN_DHCP_SERVER_CLIENT_ID_tp);
';
}

if ($ENV{'BLD_L7_COMPONENTS_INSTRU_APP'} == 1)
{
  $swig_helper_pointer_functions = q'
%pointer_functions(OPEN_ASIC_CAPABILITIES_t, OPEN_ASIC_CAPABILITIES_tp);
%pointer_functions(OPEN_ASIC_PORT_MAP_t, OPEN_ASIC_PORT_MAP_tp);
%pointer_functions(OPEN_BST_DEVICE_DATA_t, OPEN_BST_DEVICE_DATA_tp);
%pointer_functions(OPEN_BST_INGRESS_PORT_PG_DATA_t, OPEN_BST_INGRESS_PORT_PG_DATA_tp);
%pointer_functions(OPEN_BST_INGRESS_PORT_SP_DATA_t, OPEN_BST_INGRESS_PORT_SP_DATA_tp);
%pointer_functions(OPEN_BST_INGRESS_SP_DATA_t, OPEN_BST_INGRESS_SP_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_PORT_SP_DATA_t, OPEN_BST_EGRESS_PORT_SP_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_SP_DATA_t, OPEN_BST_EGRESS_SP_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_UC_QUEUE_DATA_t, OPEN_BST_EGRESS_UC_QUEUE_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_UC_QUEUEGROUPS_DATA_t, OPEN_BST_EGRESS_UC_QUEUEGROUPS_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_MC_QUEUE_DATA_t, OPEN_BST_EGRESS_MC_QUEUE_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_CPU_QUEUE_DATA_t, OPEN_BST_EGRESS_CPU_QUEUE_DATA_tp);
%pointer_functions(OPEN_BST_EGRESS_RQE_QUEUE_DATA_t, OPEN_BST_EGRESS_RQE_QUEUE_DATA_tp);
%pointer_functions(OPEN_BST_ASIC_SNAPSHOT_DATA_t, OPEN_BST_ASIC_SNAPSHOT_DATA_tp);
%pointer_functions(OPEN_BST_CONFIG_t, OPEN_BST_CONFIG_tp);
%pointer_functions(OPEN_BST_EGRESS_PORT_SP_THRESHOLD_t, OPEN_BST_EGRESS_PORT_SP_THRESHOLD_tp);
%pointer_functions(OPEN_BST_DEVICE_THRESHOLD_t, OPEN_BST_DEVICE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_INGRESS_PORT_PG_THRESHOLD_t, OPEN_BST_INGRESS_PORT_PG_THRESHOLD_tp);
%pointer_functions(OPEN_BST_INGRESS_PORT_SP_THRESHOLD_t, OPEN_BST_INGRESS_PORT_SP_THRESHOLD_tp);
%pointer_functions(OPEN_BST_INGRESS_SP_THRESHOLD_t, OPEN_BST_INGRESS_SP_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_SP_THRESHOLD_t, OPEN_BST_EGRESS_SP_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_UC_QUEUE_THRESHOLD_t, OPEN_BST_EGRESS_UC_QUEUE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_UC_QUEUEGROUPS_THRESHOLD_t, OPEN_BST_EGRESS_UC_QUEUEGROUPS_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_MC_QUEUE_THRESHOLD_t, OPEN_BST_EGRESS_MC_QUEUE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_CPU_QUEUE_THRESHOLD_t, OPEN_BST_EGRESS_CPU_QUEUE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_EGRESS_RQE_QUEUE_THRESHOLD_t, OPEN_BST_EGRESS_RQE_QUEUE_THRESHOLD_tp);
%pointer_functions(OPEN_BST_TRIGGER_CALLBACK_t, OPEN_BST_TRIGGER_CALLBACK_tp);
%pointer_functions(OPEN_PT_PACKET_t, OPEN_PT_PACKET_tp);
%pointer_functions(OPEN_PT_TRACE_PROFILE_t, OPEN_PT_TRACE_PROFILE_tp);
%pointer_functions(OPEN_BLACK_HOLE_CONFIG_t, OPEN_BLACK_HOLE_CONFIG_tp);
%pointer_functions(OPEN_BHD_PORT_SFLOW_SAMPLING_STATUS_t, OPEN_BHD_PORT_SFLOW_SAMPLING_STATUS_tp);
%pointer_functions(time_t, time_tp);
%pointer_functions(OPEN_SYSTEM_COSQ_HWQ_MAP_t, OPEN_SYSTEM_COSQ_HWQ_MAP_tp);
  ';
if ($ENV{'BLD_L7_FEAT_FT'} == 1)
{
  $swig_helper_ft_pointer_functions = q'
%pointer_functions(OPEN_FT_CAPABILITIES_t, OPEN_FT_CAPABILITIES_tp);
%pointer_functions(OPEN_FT_CONFIG_t, OPEN_FT_CONFIG_tp);
%pointer_functions(OPEN_FT_CL_INFO_t, OPEN_FT_CL_INFO_tp);
%pointer_functions(OPEN_FT_FLW_GRP_CONFIG_t, OPEN_FT_FLW_GRP_CONFIG_tp);
%pointer_functions(OPEN_FT_FLW_REC_TEMPLATE_t, OPEN_FT_FLW_REC_TEMPLATE_tp);
%pointer_functions(OPEN_FT_FLW_REC_TEMPLATE_INFO_t, OPEN_FT_FLW_REC_TEMPLATE_INFO_tp);
%pointer_functions(OPEN_IP_FIX_FLD_SPEC_WITH_EN_t, OPEN_IP_FIX_FLD_SPEC_WITH_EN_tp);
%pointer_functions(OPEN_FT_FLW_GRP_STATS_t, OPEN_FT_FLW_GRP_STATS_tp);
%array_functions(OPEN_IP_FIX_FLD_SPEC_WITH_EN_t, OPEN_IP_FIX_FLD_SPEC_WITH_EN_tArray);
%array_functions(OPEN_FT_FLW_REC_TEMPLATE_INFO_t, OPEN_FT_FLW_REC_TEMPLATE_INFO_tArray);
';
}

  $swig_helper_common_functions = get_helper_functions($helper_function_file);
  $swig_helper_common_include   = get_helper_functions($helper_include_file);
}

my $openwrap_content = qq|%module OpEN

%{
#define SWIG_FILE_WITH_INIT 1
#ifndef bool
#include <stdbool.h>
#endif
@{[&print_includes("#", @rpc_include_files)]}
@{[&print_includes("#", @openapi_include_files)]}

#if defined (OPENAPI_FT_H_INCLUDED)
void setFtFlowGroupCollectorName(OPEN_FT_FLW_GRP_CONFIG_t *dst, int idx, char x[OPEN_FT_MAX_NAME_LENGTH])
{
  int i;
  for (i = 0; i < OPEN_FT_MAX_NAME_LENGTH; i++)
  {
    dst->cl_name_list[idx][i] = x[i];
  }
}
#endif

char *getStringFromUcharArray(unsigned char x[])
{
  return (char *) x;
}

#if defined (OPENAPI_ROUTING_STATS_H_INCLUDED)
size_t getopenEcmpRouteProtocolCount_tSize()
{
  return sizeof(openEcmpRouteProtocolCount_t);
}
#endif

%}
%{
@{[$swig_helper_common_functions]}
%}
@{[$swig_related_content]}
@{[$swig_acl_helper_functions]}
@{[$swig_helper_pointer_functions]}
@{[$swig_helper_ft_pointer_functions]}
@{[$swig_helper_dhcps_pointer_functions]}
@{[&print_includes("%", @rpc_include_files)]}
@{[&print_includes("%", @openapi_include_files)]}
%include "../../api/include/openapi_swig_helpers.h"
@{[&print_enums]}
#if defined(__OPENAPI_L2OL3TUNNEL_H__)
%pointer_functions(open_l2ol3TunnelStats_t, open_l2ol3TunnelStats_tp);
#endif
#if defined(OPENAPI_BGP_CONFIG_H_INCLUDED)
%pointer_functions(open_bgpPeerStatus_t, open_bgpPeerStatus_tp);
%pointer_functions(open_bgpDecProcHist_t, open_bgpDecProcHist_tp);
#endif

#if defined (OPENAPI_ROUTING_STATS_H_INCLUDED)
%array_functions(openEcmpRouteProtocolCount_t, openEcmpRouteProtocolCount_tArray);
%pointer_functions(openRouteStats_t, openRouteStats_tp);
size_t getopenEcmpRouteProtocolCount_tSize();
#endif
#if defined(OPENAPI_ROUTING_H_INCLUDED)
%pointer_functions(openBfdSessionInfo_t, openBfdSessionInfo_tp);
#endif
#if defined(OPENAPI_MPLS_H_INCLUDED)
%pointer_functions(OPEN_MPLS_LABELS_t, OPEN_MPLS_LABELS_tp);
#endif
char *getStringFromUcharArray(unsigned char x[]);
#if defined (OPENAPI_FT_H_INCLUDED)
void setFtFlowGroupCollectorName(OPEN_FT_FLW_GRP_CONFIG_t *dst, int idx, char x[OPEN_FT_MAX_NAME_LENGTH]);
#endif

#if defined(OPENAPI_IPV4_DEVICE_TRACKING_H_INCLUDED)
%pointer_functions(OPEN_IPV4DT_CLEAR_REQUEST_t, OPEN_IPV4DT_CLEAR_REQUEST_tp);
%pointer_functions(OPEN_IPV4DT_ENTRY_t, OPEN_IPV4DT_ENTRY_tp);
%pointer_functions(OPEN_IPV4DT_SHOW_REQUEST_t, OPEN_IPV4DT_SHOW_REQUEST_tp);
%pointer_functions(OPEN_IPV4DT_ENTRIES_COUNT_t, OPEN_IPV4DT_ENTRIES_COUNT_tp);
#endif

#if defined(OPENAPI_DOT1CB_H_INCLUDED)
%pointer_functions(OPEN_DOT1CB_GLOBAL_STATS_t, OPEN_DOT1CB_GLOBAL_STATS_tp);
%pointer_functions(OPEN_DOT1CB_INTF_STATS_t, OPEN_DOT1CB_INTF_STATS_tp);
#endif

@{[$swig_helper_common_include]}
|;

open(OUTFILE, ">./openwrap.i");
print OUTFILE $openwrap_content;
close(OUTFILE);

sub get_helper_functions
{
  my ($filename) = @_;
  my $content;
  open(my $fh, '<', $filename) or die "cannot open file $filename";
  {
    local $/;
    $content = <$fh>;
  }
  close($fh);

  #remove comments in the file
  $content =~ s#/\*[^*]*\*+([^/*][^*]*\*+)*/
           |//[^\n]*
           |("(\\.|[^"\\])*" | '(\\.|[^'\\])*' | .[^/"'\\]*)
           #defined $2 ? $2 : ""#gsex;

  return $content;
}

sub print_enums
{
  my @enums = &get_enums;
  my $str = "";
  foreach my $enum (@enums)
  {
    $str .= "%pointer_functions(". $enum . ", " . $enum . "p" . ");\n";
  }
  return $str;
}

sub get_enums
{
  my @enums = ();

  foreach my $header_file (@openapi_include_files)
  {
    #read contents of a file into a variable
    my $content = do {
        local $/ = undef;
        open my $fh, "<", $header_file
            or die "could not open $header_file: $!";
        <$fh>;
    };
    #remove comments in the file
    $content =~ s#/\*[^*]*\*+([^/*][^*]*\*+)*/
             |//[^\n]*
             |q("(\\.|[^"\\])*" | '(\\.|[^'\\])*' | .[^/"'\\]*)
             #defined $2 ? $2 : ""#gsex;

    while ($content =~ /(typedef\s+enum\s*{[^}]*}[^;]+;)/g)
    {
      my ($tmp1, $enumName) = split("}", $1);
      $enumName =~ s/^\s+//; #remove leading spaces
      $enumName =~ s/\s+$//; #remove trailing spaces
      chop($enumName); #remove last character ';'
      push(@enums, $enumName);
    }
  }
  return @enums;
}

sub print_includes
{
  my ($suffix, @file_list) = @_;
  my $str = "";
  foreach my $this_file (@file_list)
  {
    $str .= $suffix . "include \"" . $this_file . "\"\n";
  }
  chomp($str);
  return $str;
}

sub get_rpc_include_files
{
  my @files = ();
  foreach $rpc_file (@rpc_header_files)
  {
    my $this_file = $root_dir . "/rpc/" . $rpc_file;
    push(@files, $this_file);
  }
  return @files;
}

sub get_openapi_include_files
{
  return &get_include_files;
}

sub get_include_files
{
  my ($suffix) = @_;
  my @files = ();

  my $inc_content = do {
      local $/ = undef;
      open my $fh, "<", $openapi_inc_all
          or die "could not open $openapi_inc_all: $!";
      <$fh>;
  };

  my $list_of_include_file = "";
  open(allHeaderFiles, "find $root_dir/api -name '*.h' -print|sort|");
  while (my $file = <allHeaderFiles>)
  {
    chomp($file);
    my $basename = basename($file);
    chomp($basename);
    if ($inc_content =~ /$basename/) 
    {
      push(@files, $file); 
    }
  }
  close(allHeaderFiles);
  return @files;
}

