/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  openapi_1213.h
*
* @purpose   Support for RFC 1213 parameters.
*
* @component OpEN
*
* @create    01/11/2015
*
* @end
*
**********************************************************************/
#ifndef _OPENAPI_SYSTEM_RFC1213_H_
#define _OPENAPI_SYSTEM_RFC1213_H_

#include "openapi_common.h"

#define  OPEN_RFC1213_PARAM_SIZE 256

/*********************************************************************
* @purpose  Get the system description
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    sys_descr        @b{(output)} System description
* @param    minimum buffer size @ref OPEN_RFC1213_PARAM_SIZE 
*
* @returns  OPEN_E_NONE      if system description get is successful.
* @returns  OPEN_E_FAIL      if system description get failed.
* @returns  OPEN_E_PARAM     invalid sys_descr parameter
*
*
* @supported-in-version OpEN API Version: 1.7
*
* @end
*********************************************************************/
open_error_t openapi1213SystemSysDescrGet( openapiClientHandle_t *client_handle,
                                           open_buffdesc         *sys_descr  );

/*********************************************************************
* @purpose  Set the system name
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    sys_name         @b{(input)}  System name
* @param    maximum buffer size @ref OPEN_RFC1213_PARAM_SIZE - 1
*
* @returns  OPEN_E_NONE      if system name set is successful.
* @returns  OPEN_E_FAIL      if system name set has failed.
* @returns  OPEN_E_PARAM     invalid system name parameter
*
* @notes    An administratively-assigned name for this managed node.
*           By convention, this is the node's fully-qualified domain
*           name.
*
* @supported-in-version OpEN API Version: 1.7
*
* @end
*********************************************************************/
open_error_t openapi1213SystemSysNameSet( openapiClientHandle_t *client_handle,
                                          open_buffdesc         *sys_name  );

/*********************************************************************
* @purpose  Get the system name
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    sys_name         @b{(output)} System name
* @param    minimum buffer size @ref OPEN_RFC1213_PARAM_SIZE 
*
* @returns  OPEN_E_NONE      if system name get is successful.
* @returns  OPEN_E_FAIL      if system name get has failed.
* @returns  OPEN_E_PARAM     invalid sys_name parameter
*
* @supported-in-version OpEN API Version: 1.7
*
* @end
*********************************************************************/
open_error_t openapi1213SystemSysNameGet( openapiClientHandle_t *client_handle,
                                          open_buffdesc         *sys_name  );

/*********************************************************************
* @purpose  Set the system location
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    sys_location     @b{(input)}  System location
* @param    maximum buffer size @ref OPEN_RFC1213_PARAM_SIZE - 1
*
* @returns  OPEN_E_NONE      if system location set is successful.
* @returns  OPEN_E_FAIL      if system location set has failed.
* @returns  OPEN_E_PARAM     invalid sys_location parameter
*
* @notes    The physical location of this node 
*           (e.g. 'telephone closet, 3rd floor')
*
* @supported-in-version OpEN API Version: 1.7
*
* @end
*********************************************************************/
open_error_t openapi1213SystemSysLocationSet( openapiClientHandle_t *client_handle,
                                              open_buffdesc         *sys_location  );

/*********************************************************************
* @purpose  Get the system location
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    sys_location     @b{(output)} System location
* @param    minimum buffer size @ref OPEN_RFC1213_PARAM_SIZE 
*
* @returns  OPEN_E_NONE      if system location get is successful.
* @returns  OPEN_E_FAIL      if system location get has failed.
* @returns  OPEN_E_PARAM     invalid sys_location parameter
*
* @supported-in-version OpEN API Version: 1.7
*
* @end
*********************************************************************/
open_error_t openapi1213SystemSysLocationGet( openapiClientHandle_t *client_handle,
                                              open_buffdesc         *sys_location  );

/*********************************************************************
* @purpose  Set the system contact information
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    sys_contact      @b{(input)}  System contact
* @param    maximum buffer size @ref OPEN_RFC1213_PARAM_SIZE - 1
*
* @returns  OPEN_E_NONE      if system contact set is successful.
* @returns  OPEN_E_FAIL      if system contact set has failed.
* @returns  OPEN_E_PARAM     invalid sys_contact parameter
*
* @notes    The textual identification of the contact person for this
*           managed node, together with information on how to contact
*           this person.
*
* @supported-in-version OpEN API Version: 1.7
*
* @end
*********************************************************************/
open_error_t openapi1213SystemSysContactSet( openapiClientHandle_t *client_handle,
                                             open_buffdesc         *sys_contact  );

/*********************************************************************
* @purpose  Get the system contact information
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    sys_contact      @b{(output)} System contact
* @param    minimum buffer size @ref OPEN_RFC1213_PARAM_SIZE 
*
* @returns  OPEN_E_NONE      if system contact get is successful.
* @returns  OPEN_E_FAIL      if system contact get has failed.
* @returns  OPEN_E_PARAM     invalid sys_contact parameter
*
* @supported-in-version OpEN API Version: 1.7
*
* @end
*********************************************************************/
open_error_t openapi1213SystemSysContactGet( openapiClientHandle_t *client_handle,
                                             open_buffdesc         *sys_contact  );

/*********************************************************************
* @purpose  Get the identification of the network management subsystem
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    sysOid           @b{(output)} System Oid
*                                         minimum buffer size is
                                          @ref OPEN_RFC1213_PARAM_SIZE
*
* @returns  OPEN_E_NONE      if system oid get is successful.
* @returns  OPEN_E_FAIL      if system oid get has failed.
* @returns  OPEN_E_PARAM     invalid sysOid parameter
*
* @supported-in-version OpEN API Version: 1.25
*
* @end
*********************************************************************/
open_error_t openapi1213SysObjectIDGet(openapiClientHandle_t *client_handle,
                                       open_buffdesc *sysOid);

#endif /* _OPENAPI_SYSTEM_RFC1213_H_ */
