/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  openapi_bcmsdk_access.h
*
* @purpose   BCM SDK shell
*
* @component OPEN
*
* @create    11/25/2012
*
* @end
*
**********************************************************************/
#ifndef OPENAPI_BCMSDK_ACCESS_H_INCLUDED
#define OPENAPI_BCMSDK_ACCESS_H_INCLUDED

#include "openapi_common.h"

/**********************************************************************************
* @purpose  Execute BCM SDK shell commands.
*
* @param    client_handle  @b{(input)}   client handle from registration API
* @param    cliCmd         @b{(input)}   Shell commands to be executed. Multiple shell
*                                        commands can be specified by separating them
*                                        by a semicolon.
* @param    fileName  @b{(input)} Name of file to which command output is written.
*                               The name must include the complete path for 
*                               the file. If the complete path is not specified,
*                               then the file is created in flash.
*                               NULL: Indicates output should be printed
*                                          to console
* @param    appendToFile @b{(input)} If the output is to be written to a file, OPEN_ENABLE
*                                  indicates that the output should be appended to the
*                                  file and OPEN_DISABLE indicates that the output should
*                                  override the contents of file.
* @notes
*   
* @warning This API should not be used to change any state in the
*          Broadcom switching silicon.
*
* @returns  OPEN_E_NONE        Executed BCM SDK shell commands.
* @returns  OPEN_E_FAIL        Failed to Execute BCM SDK shell commands.
* @returns  OPEN_E_PARAM       Error in parameter passed.
* @returns  OPEN_E_UNAVAIL     Not supported for this platform.
*
* @supported-in-version OpEN API Version: 1.1
*
* @end
***************************************************************************************/
open_error_t openapiSdkShellCmdRun (openapiClientHandle_t * client_handle,
				    open_buffdesc * cliCmd,
				    open_buffdesc * fileName,
				    uint32_t appendToFile);

/*********************************************************************
* @purpose  Read a register given its Name.
*
* @param    client_handle  @b{(input)}   client handle from registration API
* @param    bcmUnit        @b{(input)}   BCM unit number for the device.
* @param    regName        @b{(input)}   Register Name.
* @param    val            @b{(output)}  output location.
*
* @returns  OPEN_E_NONE        register read success.
* @returns  OPEN_E_FAIL        Failed to read the register.
* @returns  OPEN_E_PARAM       Error in parameter passed.
* @returns  OPEN_E_UNAVAIL     Not supported for this platform.
*
* @notes    Please note that the global register names can be determined using the
*           BCM shell on the switch via the "Listreg" command. In addition, the
*           registers are also listed in the associated Programmer's Register
*           Reference Guide.
*
* @supported-in-version OpEN API Version: 1.1
*
* @end
*********************************************************************/
open_error_t openapiSdkRegReadByName (openapiClientHandle_t * client_handle,
				      uint32_t bcmUnit,
				      open_buffdesc * regName, uint64_t * val);


/*********************************************************************
* @purpose  Read a Port Register given its Name.
*
* @param    client_handle  @b{(input)}   client handle from registration API
* @param    UnitIndex      @b{(input)}   unit number for the device.
* @param    regName        @b{(input)}   Register Name.
* @param    portNum        @b{(input)}   Port number.
* @param    val            @b{(output)}  output location.
*
* @returns  OPEN_E_NONE        Port register read success.
* @returns  OPEN_E_FAIL        Failed to read the port register.
* @returns  OPEN_E_PARAM       Error in parameter passed.
* @returns  OPEN_E_UNAVAIL     Not supported for this platform.
* 
* @notes    Please note that the port related register names can be determined using
*           the BCM shell on the switch via the "Listreg" command. In addition, the
*           registers are also listed in the associated Programmer's Register
*           Reference Guide.
* @supported-in-version OpEN API Version: 1.1
*
* @end
*********************************************************************/
open_error_t openapiSdkPortRegReadByName (openapiClientHandle_t *
					  client_handle, uint32_t UnitIndex,
					  open_buffdesc * regName,
					  uint32_t portNum, uint64_t * val);
#endif /* OPENAPI_BCMSDK_ACCESS_H_INCLUDED */
