/*********************************************************************
*
*  Copyright 2016-2018 Broadcom
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  openapi_config.h
*
* @purpose   Configuration status
*
* @component OPEN
*
* @create    12/02/2016
*
* @end
*
**********************************************************************/
#ifndef OPENAPI_CONFIG_H_INCLUDED
#define OPENAPI_CONFIG_H_INCLUDED

#include "openapi_common.h"

/*********************************************************************
* @purpose  Gets the value of a tracking variable whose value changes
*           when there is a change to the switch's running configuration.
*
* @param    client_handle          @b{(input)}  client handle from registration API
* @param    configChangeTracker    @b{(output)} integer value allowing detection of
*                                               configuration saved event
*
* @returns  OPEN_E_NONE        Tracking value returned.
* @returns  OPEN_E_PARAM       Error in parameter passed.
*
* @notes    In order to detect that a running configuration change has occurred
*           since the caller last retrieved the tracking value, a simple check
*           for equality is performed. If the values are different, one or more
*           running configuration changes have occurred. Other than equality,
*           the caller must not draw any conclusions about the tracker value.
*
* @supported-in-version OpEN API Version: 1.14
*
* @end
*********************************************************************/
open_error_t openapiConfigChangeTrackerGet(openapiClientHandle_t *client_handle,
                                           uint32_t *configChangeTracker);

/*********************************************************************
* @purpose  Gets the value of a tracking variable whose value changes
*           when the switch's running configuration is saved to startup
*           configuration.
*
* @param    client_handle       @b{(input)}  client handle from registration API
* @param    configSaveTracker   @b{(output)} integer value allowing detection of
*                                            configuration saved event
*
* @returns  OPEN_E_NONE        Tracking value returned.
* @returns  OPEN_E_PARAM       Error in parameter passed.
*
* @notes    In order to detect that running configuration change has been saved
*           since the caller last retrieved the tracking value, a simple check
*           for equality is performed. If the values are different, one or more
*           running configuration saves have occurred. Other than equality,
*           the caller must not draw any conclusions about the tracker value.
*
* @supported-in-version OpEN API Version: 1.14
*
* @end
*********************************************************************/
open_error_t openapiConfigSaveTrackerGet(openapiClientHandle_t *client_handle,
                                         uint32_t *configSaveTracker);

/*********************************************************************
* @purpose  Gets the value of a tracking variable whose value changes
*           when the switch's running configuration is cleared.
*
* @param    client_handle       @b{(input)}  client handle from registration API
* @param    configClearTracker  @b{(output)} integer value allowing detection of
*                                            configuration cleared event
*
* @returns  OPEN_E_NONE        Tracking value returned.
* @returns  OPEN_E_PARAM       Error in parameter passed.
*
* @notes    In order to detect that running configuration change has been cleared
*           since the caller last retrieved the tracking value, a simple check
*           for equality is performed. If the values are different, one or more
*           running configuration clear commands have occurred. Other than equality,
*           the caller must not draw any conclusions about the tracker value.
*
* @supported-in-version OpEN API Version: 1.14
*
* @end
*********************************************************************/
open_error_t openapiConfigClearTrackerGet(openapiClientHandle_t *client_handle,
                                          uint32_t *configClearTracker);

#endif /* OPENAPI_CONFIG_H_INCLUDED */
