/*********************************************************************
*
* Copyright 2016-2023 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  openapi_green_pwr_estimates.h
*
* @purpose   Green mode power savings estimates API
*
* @component OpEN
*
* @create    05/31/2023
*
* @end
*
**********************************************************************/
#ifndef OPENAPI_GREEN_PWR_ESTIMATES_H
#define OPENAPI_GREEN_PWR_ESTIMATES_H

/*********************************************************************
* @purpose  Get green mode current power consumption on given interface
*
* @param    client_handle  @b{(input)}  client handle from registration API
* @param    intIfNum       @b{(input)}  internal interface number
* @param    pwrConsumption @b{(output)} current power consumption
*
* @returns  OPEN_E_NONE             On success.
* @returns  OPEN_E_FAIL             On failure.
* @returns  OPEN_E_PARAM            Invalid argument.
* @returns  OPEN_E_INTERNAL         Internal error.
*
* @comments none
*
* @supported-in-version OpEN API Version: 1.26
*
* @end
*********************************************************************/
open_error_t openapiGreenPwrEstIntfCurPwrGet(openapiClientHandle_t *client_handle,
                                             uint32_t intIfNum,
                                             uint32_t *pwrConsumption);

/*********************************************************************
* @purpose  Get green mode current power consumption
*
* @param    client_handle  @b{(input)}  client handle from registration API
* @param    pwrConsumption @b{(output)} current power consumption
*
* @returns  OPEN_E_NONE             On success.
* @returns  OPEN_E_FAIL             On failure.
* @returns  OPEN_E_PARAM            Invalid argument.
* @returns  OPEN_E_INTERNAL         Internal error.
*
* @comments none
*
* @supported-in-version OpEN API Version: 1.26
*
* @end
*********************************************************************/
open_error_t openapiGreenPwrEstGlobalCurPwrGet(openapiClientHandle_t *client_handle,
                                               uint32_t *pwrConsumption);

/*********************************************************************
* @purpose  Get green mode cumulative power saving on given interface
*
* @param    client_handle  @b{(input)}  client handle from registration API
* @param    intIfNum       @b{(input)}  internal interface number
* @param    pwrSaving      @b{(output)} cumulative power saving
*
* @returns  OPEN_E_NONE             On success.
* @returns  OPEN_E_FAIL             On failure.
* @returns  OPEN_E_PARAM            Invalid argument.
* @returns  OPEN_E_INTERNAL         Internal error.
*
* @comments none
*
* @supported-in-version OpEN API Version: 1.26
*
* @end
*********************************************************************/
open_error_t openapiGreenPwrEstIntfCumSavingGet(openapiClientHandle_t *client_handle,
                                                uint32_t intIfNum,
                                                uint32_t *pwrSaving);

/*********************************************************************
* @purpose  Get green mode current power saving
*
* @param    client_handle  @b{(input)}  client handle from registration API
* @param    pwrSaving      @b{(output)} cumulative power saving
*
* @returns  OPEN_E_NONE             On success.
* @returns  OPEN_E_FAIL             On failure.
* @returns  OPEN_E_PARAM            Invalid argument.
* @returns  OPEN_E_INTERNAL         Internal error.
*
* @comments none
*
* @supported-in-version OpEN API Version: 1.26
*
* @end
*********************************************************************/
open_error_t openapiGreenPwrEstGlobalCumSavingGet(openapiClientHandle_t *client_handle,
                                                  uint32_t *pwrSaving);

/*********************************************************************
* @purpose  Get green mode power saving
*
* @param    client_handle  @b{(input)}  client handle from registration API
* @param    pwrSaving      @b{(output)} cumulative power saving
*
* @returns  OPEN_E_NONE             On success.
* @returns  OPEN_E_FAIL             On failure.
* @returns  OPEN_E_PARAM            Invalid argument.
* @returns  OPEN_E_INTERNAL         Internal error.
*
* @comments none
*
* @supported-in-version OpEN API Version: 1.26
*
* @end
*********************************************************************/
open_error_t openapiGreenEthrPwrEstGlobalPwrSavingGet(openapiClientHandle_t *client_handle,
                                                      uint32_t *pwrSaving);

/*********************************************************************
* @purpose  Clear green mode statistics for the given interface
*
* @param    client_handle  @b{(input)}  client handle from registration API
* @param    intIfNum       @b{(input)}  internal interface number
*
* @returns  OPEN_E_NONE             On success.
* @returns  OPEN_E_FAIL             On failure.
* @returns  OPEN_E_PARAM            Invalid argument.
* @returns  OPEN_E_INTERNAL         Internal error.
*
* @comments none
*
* @supported-in-version OpEN API Version: 1.26
*
* @end
*********************************************************************/
open_error_t openapiGreenEthrIntfStatisticsClear(openapiClientHandle_t *client_handle,
                                                 uint32_t intIfNum);
#endif /* OPENAPI_GREEN_PWR_ESTIMATES_H */
