/**********************************************************************
*
*  Copyright 2024 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
***********************************************************************
*
* @filename  openapi_interface_app.h
*
* @purpose   This code implements the OpEN interface app API
*
* @component OPEN
*
* @create    02/20/2024
*
* @end
*
*********************************************************************/
#ifndef OPENAPI_INTERFACE_APP_H_INCLUDED
#define OPENAPI_INTERFACE_APP_H_INCLUDED

#include "openapi_common.h"


/*****************************************************************************
 * @purpose   Get interface time range information.
 *
 * @param     client_handle  @b{(input)}  client handle from registration API
 * @param     intIfNum       @b{(input)}  Internal interface number
 * @param     pTimeRange     @b{(output)} Time range name
 *
 * @returns   OPEN_E_UNAVAIL          Not supported.
 * @returns   OPEN_E_NONE             On successful fetch of time range
 *                                    information.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     This API fetches interface time range information.
 *
 * @supported-in-version OpEN API Version: 1.28
 *
 * @end
 *****************************************************************************/
open_error_t
openapiInterfaceAppTimeRangeGet(openapiClientHandle_t *client_handle,
                                uint32_t intIfNum, open_buffdesc *pTimeRange);

/*****************************************************************************
 * @purpose   Set interface time range information.
 *
 * @param     client_handle  @b{(input)}  client handle from registration API
 * @param     intIfNum       @b{(input)}  Internal interface number
 * @param     pTimeRange     @b{(input)}  Time range name
 *
 * @returns   OPEN_E_UNAVAIL          Not supported
 * @returns   OPEN_E_NONE             On Successful set time range to interface.
 * @returns   OPEN_E_FAIL             On failure to set time range to interface.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     This API sets interface time range information.
 * @notes     Calling this API will change the running configuration of the switch.
 * @notes     To clear time range information for an interface,
 *            data of pTimeRange->pstart should be empty string and
 *            pTimeRange->size should be 1.
 *
 * @supported-in-version OpEN API Version: 1.28
 *
 * @end
 *****************************************************************************/
open_error_t
openapiInterfaceAppTimeRangeSet(openapiClientHandle_t *client_handle,
                                uint32_t intIfNum, open_buffdesc *pTimeRange);
#endif /* OPENAPI_INTERFACE_APP_H_INCLUDED */
