/**********************************************************************
*  Copyright 2023 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
***********************************************************************
* @filename  openapi_ip6radv.h
*
* @purpose   This code implements the OpEN IP6 RADV API
*
* @component OPEN
*
* @create    01/24/2023
*
* @end
*********************************************************************/
#ifndef OPENAPI_IP6RADV_H_INCLUDED
#define OPENAPI_IP6RADV_H_INCLUDED

#include "openapi_common.h"


/*****************************************************************************
 * @purpose   Set IPv6 router advertise Minimum advertisement interval.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(input)}  Value in seconds
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvMinAdvIntSet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t val);

/*****************************************************************************
 * @purpose   Get IPv6 router advertise Minimum advertisement interval.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(output)} Pointer to value in seconds
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvMinAdvIntGet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t *val);

/*****************************************************************************
 * @purpose   Set IPv6 router advertise Maximum advertisement interval.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(input)}  Value in seconds
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvMaxAdvIntSet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t val);

/*****************************************************************************
 * @purpose   Get IPv6 router advertise Maximum advertisement interval.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(output)} Pointer to value in seconds
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvMaxAdvIntGet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t *val);

/*****************************************************************************
 * @purpose   Set IPv6 router advertise lifetime.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(input)}  Value in seconds
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvAdvLifetimeSet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t val);

/*****************************************************************************
 * @purpose   Get IPv6 router advertise lifetime.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(output)} Pointer to value in seconds
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvAdvLifetimeGet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t *val);

/*****************************************************************************
 * @purpose   Set IPv6 router advertise link mtu.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(input)}  MTU value
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvAdvMtuSet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t val);

/*****************************************************************************
 * @purpose   Get IPv6 router advertise link mtu.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(output)} Pointer to MTU value
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvAdvMtuGet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t *val);

/*****************************************************************************
 * @purpose   Set IPv6 router preference.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(input)}  Preference value
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvRtrPrefSet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t val);

/*****************************************************************************
 * @purpose   Get IPv6 router preference.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     val            @b{(output)} Pointer to preference value
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvRtrPrefGet(openapiClientHandle_t *client_handle, uint32_t ifNum, uint32_t *val);

/*****************************************************************************
 * @purpose   Set IPv6 router advertise managed flag.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     flag           @b{(input)}  OPEN_TRUE or OPEN_FALSE
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvManagedFlagSet(openapiClientHandle_t *client_handle, uint32_t ifNum, OPEN_BOOL_t flag);

/*****************************************************************************
 * @purpose   Get IPv6 router advertise managed flag.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     flag           @b{(output)} OPEN_TRUE or OPEN_FALSE
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvManagedFlagGet(openapiClientHandle_t *client_handle, uint32_t ifNum, OPEN_BOOL_t *flag);

/*****************************************************************************
 * @purpose   Set IPv6 router advertise other-config flag.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     flag           @b{(input)}  OPEN_TRUE or OPEN_FALSE
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvOtherCfgFlagSet(openapiClientHandle_t *client_handle, uint32_t ifNum, OPEN_BOOL_t flag);

/*****************************************************************************
 * @purpose   Get IPv6 router advertise other-config flag.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     flag           @b{(output)} OPEN_TRUE or OPEN_FALSE
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvOtherCfgFlagGet(openapiClientHandle_t *client_handle, uint32_t ifNum, OPEN_BOOL_t *flag);

/*****************************************************************************
 * @purpose   Set IPv6 hop limit advertised on the interface to unspecified(0).
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     flag           @b{(input)}  OPEN_TRUE or OPEN_FALSE
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvHopLimitUnspec(openapiClientHandle_t *client_handle, uint32_t ifNum, OPEN_BOOL_t flag);

/*****************************************************************************
 * @purpose   Get whether IPv6 hop limit advertised on the interface to unspecified(0)
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     flag           @b{(output)} OPEN_TRUE or OPEN_FALSE
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvHopLimitUnspecGet(openapiClientHandle_t *client_handle, uint32_t ifNum, OPEN_BOOL_t *flag);

/*****************************************************************************
 * @purpose   Set IPv6 router advertise suppression.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     flag           @b{(input)}  OPEN_TRUE or OPEN_FALSE
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvSuppressSet(openapiClientHandle_t *client_handle, uint32_t ifNum, OPEN_BOOL_t flag);

/*****************************************************************************
 * @purpose   Get IPv6 router advertise suppression
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     flag           @b{(output)} OPEN_TRUE or OPEN_FALSE
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvSuppressGet(openapiClientHandle_t *client_handle, uint32_t ifNum, OPEN_BOOL_t *flag);

/*****************************************************************************
 * @purpose   Set IPv6 router as per prefix attributes.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     prefix         @b{(input)}  Pointer to prefix
 * @param     plen           @b{(input)}  Prefix length
 * @param     prefLife       @b{(input)}  Preferred life
 * @param     validLife      @b{(input)}  Valid life
 * @param     lifeDecrFlags  @b{(input)}  Flags for lifetime decrement mode
 * @param     onLink         @b{(input)}  Onlink flag (OPEN_TRUE or OPEN_FALSE)
 * @param     autonomous     @b{(input)}  Autonomous flag (OPEN_TRUE or OPEN_FALSE)
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvPrefixSet(openapiClientHandle_t *client_handle, uint32_t ifNum, open_inet_addr_t *prefix,
                                        uint32_t plen, uint32_t prefLife, uint32_t validLife,
                                        uint16_t lifeDecrFlags, OPEN_BOOL_t onLink, OPEN_BOOL_t autonomous);

/*****************************************************************************
 * @purpose   Get IPv6 router as per prefix attributes.
 *
 * @param     client_handle  @b{(input)}  Client handle from registration API
 * @param     ifNum          @b{(input)}  Internal Interface Number
 * @param     prefix         @b{(input)}  Pointer to prefix
 * @param     plen           @b{(input)}  Prefix length
 * @param     prefLife       @b{(output)} Preferred life
 * @param     validLife      @b{(output)} Valid life
 * @param     onLink         @b{(output)} Onlink flag (OPEN_TRUE or OPEN_FALSE)
 * @param     autonomous     @b{(output)} Autonomous flag (OPEN_TRUE or OPEN_FALSE)
 *
 * @returns   OPEN_E_UNAVAIL          Feature is not supported
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes     none
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiIp6RtrRadvPrefixGet(openapiClientHandle_t *client_handle, uint32_t ifNum, open_inet_addr_t *prefix,
                                        uint32_t plen, uint32_t *prefLife, uint32_t *validLife,
                                        OPEN_BOOL_t *onLink, OPEN_BOOL_t *autonomous);

#endif /* OPENAPI_IP6RADV_H_INCLUDED */

