/*********************************************************************
*
* Copyright 2017-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  openapi_issu.h
*
* @purpose   ISSU OpEN API
*
* @component OPEN
*
* @create    01/23/2017
*
* @end
*
**********************************************************************/
#ifndef _OPENAPI_ISSU_H_
#define _OPENAPI_ISSU_H_

#include <stdint.h>

/*********************************************************************
* @purpose  Register for ISSU events and gets last ISSU reset status.
*
* @param    client_handle       @b{(input)}  Client handle from registration API.
* @param    issuWarmRestart     @b{(output)} Whether last reset was a ISSU reset
*
* @returns  OPEN_E_NONE         If registration successful 
* @returns  OPEN_E_ERROR        Reached maximum client registration
*                               Not supported
*
* @notes    
* 
* @supported-in-version OpEN API Version: 1.15
* 
* @end
*********************************************************************/
open_error_t openapiISSUClientRegister(openapiClientHandle_t *client_handle,
                                       uint32_t *issuWarmRestart);

/*********************************************************************
* @purpose  Deregister for ISSU events and gets last ISSU reset status.
*
* @param    client_handle       @b{(input)}  Client handle from registration API.
*
* @returns  OPEN_E_NONE         If de-registration successful 
* @returns  OPEN_E_INTERNAL     Unexpected error.
* @returns  OPEN_E_PARAM        Invalid parameter.
* @returns  OPEN_E_ERROR        Not supported
*
* @notes    
* 
* @supported-in-version OpEN API Version: 1.15
* 
* @end
*********************************************************************/
open_error_t openapiISSUClientDeRegister(openapiClientHandle_t *client_handle);

/*********************************************************************
* @purpose  Indicates that OpenAPI app is done with ISSU saving
*
* @param    client_handle       @b{(input)} Client handle from registration API.
*
* @returns  OPEN_E_NONE         Successfully notified about data save
* @returns  OPEN_E_INTERNAL     Unexpected error.
* @returns  OPEN_E_PARAM        Invalid parameter.
* @returns  OPEN_E_ERROR        Not registered for ISSU 
*                               Not supported
*
* @notes    
* 
* @supported-in-version OpEN API Version: 1.15
* 
* @end
*********************************************************************/
open_error_t openapiISSUClientStateSaved(openapiClientHandle_t *client_handle);

/*********************************************************************
* @purpose  OpenAPI app is done with restoring data and ready
*           for HW reconciliation
*
* @param    client_handle       @b{(input)} Client handle from registration API.
*
* @returns  OPEN_E_NONE         Successfully notified about restoring data
* @returns  OPEN_E_INTERNAL     Unexpected error.
* @returns  OPEN_E_PARAM        Invalid parameter.
* @returns  OPEN_E_ERROR        Not registered for ISSU 
*                               Not supported
*
* @notes    
* 
* @supported-in-version OpEN API Version: 1.15
* 
* @end
*********************************************************************/
open_error_t openapiISSUClientReady(openapiClientHandle_t *client_handle);

/*********************************************************************
* @purpose  Indicates whether ISSU save has started
*
* @param    client_handle       @b{(input)} Client handle from registration API.
* @param    issuStart           @b{(input)} Indicates ISSU save started
*
* @returns  OPEN_E_NONE         Successfully fetched ISSU start status 
* @returns  OPEN_E_PARAM        Invalid parameter.
* @returns  OPEN_E_ERROR        Error.
*
* @notes     
* 
* @supported-in-version OpEN API Version: 1.15
* 
* @end
*********************************************************************/
open_error_t openapiIssuStartGet(openapiClientHandle_t *client_handle,
                                 uint32_t *issuStart);
#endif  /* _OPENAPI_ISSU_H_ */
