
/**********************************************************************
*
*  Copyright 2023 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
***********************************************************************
*
* @filename  openapi_nsdp.h
*
* @purpose   This code implements the OpEN NSDP API
*
* @component OPEN
*
* @create    03/21/2023
*
* @end
*
*********************************************************************/
#ifndef OPENAPI_NSDP_H_INCLUDED
#define OPENAPI_NSDP_H_INCLUDED

#include "openapi_common.h" 


/*****************************************************************************
 * @purpose   Sets the NSDP Admin Mode.
 *
 * @param     client_handle  @b{(input)}  client handle from registration API
 * @param     mode           @b{(input)}  mode sets the scc mode
 *
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes      
 * @notes      
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiNsdpModeSet(openapiClientHandle_t *client_handle, OPEN_CONTROL_t mode);

/*****************************************************************************
 * @purpose   Get the NSDP Admin Mode.
 *
 * @param     client_handle  @b{(input)}  client handle from registration API
 * @param     mode           @b{(output)} mode  pointer to scc mode
 *
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 *
 * @notes      
 * @notes      
 *
 * @supported-in-version OpEN API Version: 1.25
 *
 * @end
 *****************************************************************************/
open_error_t openapiNsdpModeGet(openapiClientHandle_t *client_handle, OPEN_CONTROL_t *mode);


#endif /* OPENAPI_NSDP_H_INCLUDED */
