import getopt, sys, os
import OpEN_py as OpEN
from OpENUtil import *
from time import time
from select import select
import fcntl
import os
import errno

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

def main(argv):
    regname = ''
    port = ''
    try:
        opt, args = getopt.getopt(argv, "hr:p:", ["help", "regname=", "port="])
    except getopt.GetoptError as err:
        print ("%s" % str(err))
        usage()
        sys.exit(2)
    output = None
    verbose = False
    total_args = len(argv)
    if total_args == 0:
      usage()
      sys.exit(2)
    for o, a in opt:
        if o in ("-h", "--help"):
            usage()
            sys.exit()
        elif o in ("-r", "--regname"):
            regname = a
        elif o in ("-p", "--port"):
            port = a
        else:
            assert False, "unhandled option"
    if regname == '' :
          print ("regname is mandatory")
          usage()
          sys.exit(2)
    if port == '' :
          print ("port is mandatory")
          usage()
          sys.exit(2)
    else :
      try:
        port = int(port)
      except ValueError:
        print ("Port number must be an integer")
        sys.exit(2)
    getregval(regname, port)

def getregval(regname, port):
    open = OpENUtil()
    ret = open.connect("sdkportregbyname")
    if ret == OpEN.OPEN_E_NONE :
      open.getNetworkOSVersion()
      open.getAPIVersion()
      client = open.get_client()
      try:
        reg_name = open.getStringBuffer(len(regname) + 1, regname)
      except OpENBufferSizeError:
        print("getregval: getStringBuffer raised OpENBufferSizeError")
        return
      except TypeError:
        print("getregval: getStringBuffer raised TypeError")
        return

      name_buff = OpEN.open_buffdesc()
      name_buff.pstart = reg_name
      name_buff.size = len(regname)+1
      ret_val_p = OpEN.new_uint64_tp()
      result = OpEN.openapiSdkPortRegReadByName(client, 0, name_buff, port, ret_val_p)
      if result != OpEN.OPEN_E_NONE :
        print ("Bad return code trying to read the register. (result = %d)\n" % result)
      else :
        ret_val = OpEN.uint64_tp_value(ret_val_p)
        print ("reg = %s, val = 0x%x\n" % (regname, ret_val))
    else :
      print ("Unable to connect")
    OpEN.delete_uint64_tp(ret_val_p)

def usage():
    usage = """
    -h --help            Prints this
    -r --regname         Name of the register
    -p --port            Port number
    """
    print (usage)

if __name__ == "__main__":
    main(sys.argv[1:])

