/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
***********************************************************************
*
* @filename sdkregbyaddr.c
*
* @purpose Direct access to SDK global registers by their name.
* @detail  Example application that uses the OpEN API to directly
*          access an SDK register (by address) and display its
*          contents.
*
* @comments none
*
* @create    11/26/2012
*
* @end
*
**********************************************************************/

#include <stdlib.h>
#include <unistd.h>

#include "rpcclt_openapi.h"
#include "proc_util.h"
#include "openapi_common.h"
#include "openapi_bcmsdk_access.h"
/*******************************************************************
*
* @brief  This is the main function that will demonstrate 
*         Packet OpEN APIs.
*
* @returns  0: Success
* @returns  1: Failure
*
*********************************************************************/
int
main(int argc, char *argv[])
{
  open_error_t result;
  open_buffdesc  regName ;
  open_buffdesc switch_os_revision;
  uint64_t  val = 0;
  openapiClientHandle_t clientHandle;
  char switch_os_revision_string[100];
  char name[100];


  if (argc != 2 || !argv[1])
  {
    printf("Usage: %s <regname> \n", argv[0]);
    exit(1);
  }
 
  memcpy(name, argv[1], 100);
  printf("name %s argv[1] %s\n",name,argv[1]); 
  regName.pstart = name;
  regName.size = sizeof(name);
  l7proc_crashlog_register ();

  /* Register with OpEN */
  if ((result = openapiClientRegister ("sdkregbyname", &clientHandle)) != OPEN_E_NONE)
  {
    printf ("\nFailed to initialize RPC to OpEN. Exiting (result = %d)\n",
        result);
    exit (2);
  }

  /* RPC call can fail until server starts. Keep trying */
  while (openapiConnectivityCheck (&clientHandle) != OPEN_E_NONE)
  {
    sleep (1);
  }

  L7PROC_LOGF (L7PROC_LOG_SEVERITY_INFO, 0,
      "Starting SDK access registers by name example application");

  printf ("\n");
  switch_os_revision.pstart = switch_os_revision_string;
  switch_os_revision.size = sizeof (switch_os_revision_string);
  if (openapiNetworkOSVersionGet (&clientHandle, &switch_os_revision) == OPEN_E_NONE)
    printf ("Network OS version = %s\n", switch_os_revision_string);
  else
    printf ("Network OS Version retrieve error\n");

  printf ("\n");

  if ((result = openapiSdkRegReadByName(&clientHandle, 0, &regName, &val)) != OPEN_E_NONE)
  {
    printf("  Bad return code trying to read the register. (result = %d)\n",result);
    return 0;
  }
  else
  {
    printf("reg = %s val = 0x%llx\n", name, val);
  }
  /* Log goodbye message with OPEN */
  L7PROC_LOGF (L7PROC_LOG_SEVERITY_INFO, 0,
                       "Stopping SDK register read by name example application");
  return 0;
}
