#
# Cookbook Name:: boa
# File:: providers/statistics.rb
#
# Copyright 2016 Broadcom.
#
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

require "OpEN"
require "OpENUtil"

open = OpENUtil.new()

def whyrun_supported?
  true
end

#Statistics
def statistics_get (client, counterId, ifNum, counterValue_p)
  ret = OpEN::openapiStatGet(client, counterId, ifNum, counterValue_p)
  if ret != OpEN::OPEN_E_NONE
    Chef::Log.info "Failed to get counter '#{counterId}' stats for interface '#{ifNum}', returned #{ret}" 
  end
end

def statistics_reset (client, counterId, ifNum)
  ret = OpEN::openapiStatReset(client, counterId, ifNum)
  if ret != OpEN::OPEN_E_NONE
    Chef::Log.info "Failed to reset counter '#{counterId}' stats for interface '#{ifNum}', returned #{ret}" 
  end
end

def statistics_intf_reset (client, ifNum)
  ret = OpEN::openapiInterfaceStatsReset(client, ifNum)
  if ret != OpEN::OPEN_E_NONE
    Chef::Log.info "Failed to reset stats for interface '#{ifNum}', returned #{ret}" 
  end
end

def statistics_counters_reset (client, ifNum)
  #counter ID (TX_TOTAL_BYTES)  
  counterId = OpEN::OPEN_CTR_TX_TOTAL_BYTES
  statistics_reset(client, counterId, ifNum)
  
  #counter ID (RX_TOTAL_BYTES)  
  counterId = OpEN::OPEN_CTR_RX_TOTAL_BYTES
  statistics_reset(client, counterId, ifNum)

  #counter ID (TX_TOTAL_FRAMES)  
  counterId = OpEN::OPEN_CTR_TX_TOTAL_FRAMES
  statistics_reset(client, counterId, ifNum)

  #counter ID (RX_TOTAL_FRAMES)  
  counterId = OpEN::OPEN_CTR_RX_TOTAL_FRAMES
  statistics_reset(client, counterId, ifNum)
end

def print_statistics_intf (client, ifNum)
  counterValue1_p = OpEN.new_uint64_tp()
  counterValue2_p = OpEN.new_uint64_tp()
  counterValue3_p = OpEN.new_uint64_tp()
  counterValue4_p = OpEN.new_uint64_tp()

  #counter ID (TX_TOTAL_BYTES)  
  counterId = OpEN::OPEN_CTR_TX_TOTAL_BYTES
  statistics_get(client, counterId, ifNum, counterValue1_p)
  counterValue1 = OpEN.uint64_tp_value(counterValue1_p)

  #counter ID (RX_TOTAL_BYTES)  
  counterId = OpEN::OPEN_CTR_RX_TOTAL_BYTES
  statistics_get(client, counterId, ifNum, counterValue2_p)
  counterValue2 = OpEN.uint64_tp_value(counterValue2_p)

  #counter ID (TX_TOTAL_FRAMES)  
  counterId = OpEN::OPEN_CTR_TX_TOTAL_FRAMES
  statistics_get(client, counterId, ifNum, counterValue3_p)
  counterValue3 = OpEN.uint64_tp_value(counterValue3_p)
  
  #counter ID (RX_TOTAL_FRAMES)  
  counterId = OpEN::OPEN_CTR_RX_TOTAL_FRAMES
  statistics_get(client, counterId, ifNum, counterValue4_p)
  counterValue4 = OpEN.uint64_tp_value(counterValue4_p)

  printf "\n%-9d %-16d %-16d %-16d %-16d ", ifNum, counterValue1, counterValue2, counterValue3,  counterValue4

  OpEN.delete_uint64_tp(counterValue1_p)
  OpEN.delete_uint64_tp(counterValue2_p)
  OpEN.delete_uint64_tp(counterValue3_p)
  OpEN.delete_uint64_tp(counterValue4_p)

end

action :print do
  converge_by("print statistics") do
    ret = open.connect("boa-statistics")
    if ret == OpEN::OPEN_E_NONE
      client = open.client

      #Print statistics (counter values) for all the physical interfaces.
      ifType = OpEN::OPEN_INTF_TYPE_PHY
      ifNum_p = OpEN.new_uint32_tp()
      printf "\nPort      Bytes Tx         Bytes Rx         Packets Tx       Packets Rx       "
      printf "\n----      --------         --------         ----------       ----------       "
  
      ret = OpEN::openapiIfFirstGet(client, ifType, ifNum_p)
      while ret == OpEN::OPEN_E_NONE do
        ifNum = OpEN.uint32_tp_value(ifNum_p)
        print_statistics_intf(client, ifNum)
        ret = OpEN::openapiIfNextGet(client, ifType, ifNum, ifNum_p)
      end #end while ret == OpEN::OPEN_E_NONE
  
      #Reset statistics (counter values) on the specified interface 1.
      ifNum = 2
      printf "\n\nResetting the counters on interface %d..", ifNum
      statistics_counters_reset(client, ifNum)

      #Print statistics (counter values) on the specified interface 1.
      printf "\n\nAfter resetting.........."
      print_statistics_intf(client, ifNum)
    
      #Reset all the statistics (counter values) on the specified interface 1.
      ifNum = 1
      printf "\n\nResetting all the counters on interface %d..", ifNum
      statistics_intf_reset(client, ifNum)

      #Print statistics (counter values) on the specified interface 1.
      printf "\n\nAfter resetting.........."
      print_statistics_intf(client, ifNum)
      printf "\nStatistics are all properly reset.\n"

      OpEN.delete_uint32_tp(ifNum_p)
    else
      Chef::Log.info "Failed to connect to 'boa-statistics' in 'print'." 
    end
    open.terminate()
  end
end

