import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#


class MirrorExample :
  def __init__(self, client) :
    self.m_client = client

  def sw_port_monitor_list_get (self, sessionNum, intfList) :
      result = OpEN.openapiSwPortMonitorSourcePortsListGet(self.m_client, sessionNum, intfList)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def mirror_source_port_direction_get (self, sessionNum, intIfNum, probType) :
      result = OpEN.openapiMirrorSourcePortDirectionGet(self.m_client, sessionNum, intIfNum, probType)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def mirror_sw_port_source_add (self, sessionNum, intIfNum, probType) :
      result = OpEN.openapiSwPortMonitorSourcePortAdd(self.m_client, sessionNum, intIfNum, probType)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def mirror_sw_port_source_remove (self, sessionNum, intIfNum) :
      result = OpEN.openapiSwPortMonitorSourcePortRemove(self.m_client, sessionNum, intIfNum)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def mirror_sw_port_monitor_mode_set (self, sessionNum, mode) :
      result = OpEN.openapiSwPortMonitorModeSet(self.m_client, sessionNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def mirror_sw_port_monitor_mode_get (self, sessionNum, mode) :
      result = OpEN.openapiSwPortMonitorModeGet(self.m_client, sessionNum, mode)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def mirror_sw_port_monitor_src_intf_first_get (self, intIfNum) :
      result = OpEN.openapiSwPortMonitorValidSrcIntfFirstGet(self.m_client, intIfNum)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def mirror_sw_port_monitor_src_intf_next_get (self, intIfNum, nextIntf) :
      result = OpEN.openapiSwPortMonitorValidSrcIntfNextGet(self.m_client, intIfNum, nextIntf)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def sw_port_monitor_src_intf_list_get (self, srcList) :
      result = OpEN.openapiSwPortMonitorValidSrcIntfListGet(self.m_client, srcList)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def sw_monitor_vlan_list_set (self, sessionNum, vlanIdListIn, updateAction) :
      result = OpEN.openapiSwMonitorVlanListSet(self.m_client, sessionNum, vlanIdListIn, updateAction)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

  def sw_monitor_vlan_list_get (self, sessionNum, vlanIdListOut) :
      result = OpEN.openapiSwMonitorVlanListGet(self.m_client, sessionNum, vlanIdListOut)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else:
       return 0

def main() :
    """Demonstrate OpEN usage for Mirror APIs"""
    ret = open_.connect("mirror_example")
    if ret == OpEN.OPEN_E_NONE :
      open_.getNetworkOSVersion()
      client = open_.get_client()
      
      example = MirrorExample(client)
      string = OpEN.open_buffdesc()
      try:
        name_string = open_.getStringBuffer(OpEN.OPENAPI_CLI_MAX_STRING_LENGTH, '')
      except OpENBufferSizeError:
        print("main: getStringBuffer raised OpENBufferSizeError")
        return
      except TypeError:
        print("main: getStringBuffer raised TypeError")
        return
      string.pstart = name_string
      string.size = OpEN.OPENAPI_CLI_MAX_STRING_LENGTH
      session = OpEN.new_uint32_tp()
      OpEN.uint32_tp_assign(session, 1)
      sessionNum = OpEN.uint32_tp_value(session)
      interface = OpEN.new_uint32_tp()
      OpEN.uint32_tp_assign(interface, 1)
      interfaceNum = OpEN.uint32_tp_value(interface)
      mode = OpEN.new_OPEN_CONTROL_tp()
      probType = OpEN.new_OPENAPI_MIRROR_DIRECTION_tp()
      text = ''

      if (example.sw_port_monitor_list_get(sessionNum, string) != 0) :
       print("Failed to retrive the list of source interfaces for session.")
      else:
       print("The list of source interfaces for session %s is: %s" % (sessionNum, name_string.cast()))

      if (example.mirror_source_port_direction_get(sessionNum, interfaceNum, probType) != 0) :
       print("Failed to retrive the direction to be mirrored for a source port %s." % (interfaceNum))
      else:
       probTypeValue = OpEN.OPENAPI_MIRROR_DIRECTION_tp_value(probType)
       if (probTypeValue == OpEN.OPENAPI_MIRROR_UNCONFIGURED) :
        text = "unconfigured."
       elif (probTypeValue == OpEN.OPENAPI_MIRROR_BIDIRECTIONAL) :
        text = "bidirectional."
       elif (probTypeValue == OpEN.OPENAPI_MIRROR_INGRESS) :
        text = "ingress."
       elif (probTypeValue == OpEN.OPENAPI_MIRROR_EGRESS) :
        text = "egress."
       elif (probTypeValue == OpEN.OPENAPI_MIRROR_SFLOW) :
        text = "swlow."
       else :
        text = "unknown."
       print("The direction to be mirrored for a source port %s is %s" % (interfaceNum, text))

      probTypeValue = OpEN.OPENAPI_MIRROR_DIRECTION_tp_value(probType)
      if (example.mirror_sw_port_source_add(sessionNum, interfaceNum, probTypeValue) != 0) :
       print("Failed to add the interface %s to the mirrored ports of session %s." % (interfaceNum, sessionNum))
      else:
       print("The interface %s added to the mirrored port of session %s with direction %s" % (interfaceNum, sessionNum, text))

      if (example.mirror_sw_port_source_remove(sessionNum, interfaceNum) != 0) :
       print("Failed to add the interface %s to the mirrored ports of session %s." % (interfaceNum, sessionNum))
      else:
       print("The interface %s removed from the mirrored port of session %s." % (interfaceNum, sessionNum))

      if (example.mirror_sw_port_monitor_mode_set(sessionNum, OpEN.OPEN_TRUE) != 0) :
       print("Failed to set the port monitoring mode for session %s." % (sessionNum))
      else:
       print("The port monitoring mode for session %s set with value 'true'." % (sessionNum))

      if (example.mirror_sw_port_monitor_mode_get(sessionNum, mode) != 0) :
       print("Failed to retrieve the port monitoring mode for session %s" % (sessionNum))
      else:
       if (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_ENABLE) :
        textMode = "enabeled."
       elif (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_DISABLE) :
        textMode = "disableed."
       else :
        textMode = "undefined."
       print("The port monitoring mode for session %s is %s" % (sessionNum, textMode))

      if (example.mirror_sw_port_monitor_src_intf_first_get(interface) == 0) :
       print("The first valid interface that can be configured as source port is %s." % (OpEN.uint32_tp_value(interface)))
       if (example.mirror_sw_port_monitor_src_intf_next_get(OpEN.uint32_tp_value(interface), interface) == 0) :
        print("The next valid interface that can be configured as source port is %s" % (OpEN.uint32_tp_value(interface)))
       else :
        print("Failed to retrieve the next valid interface that can be configured as source port.")
      else :
       print("Failed to retrieve the first valid interface that can be configured as source port.")

      if (example.sw_port_monitor_src_intf_list_get(string) != 0) :
       print("Failed to retrive the list of valid interfaces that can be configured as source port.")
      else:
       print("The list of valid interfaces that can be configured as source port is: %s" % (name_string.cast()))

      vlan_str = '1'
      try:
        vlan_string = open_.getStringBuffer(256, vlan_str)
      except OpENBufferSizeError:
        print("main: getStringBuffer raised OpENBufferSizeError")
        return
      except TypeError:
        print("main: getStringBuffer raised TypeError")
        return
      string.pstart = vlan_string
      string.size = 256
      if (example.sw_monitor_vlan_list_set(sessionNum, string, OpEN.OPEN_ENABLE) != 0) :
       print("Failed to set the VLAN id and number of VLANs for session %s." % (sessionNum))
      else:
       print("The VLAN id and number of VLANs for session %s set with values is: %s" % (sessionNum, vlan_string.cast()))

      if (example.sw_monitor_vlan_list_get(sessionNum, string) != 0) :
       print("Failed to retrieve the VLAN IDs attached to the session %s." % (sessionNum))
      else:
       print("The VLAN IDS attached to the session %s is: %s" % (sessionNum, vlan_string.cast()))

    else :
     print("Unable to connect.")
    open_.terminate()
if __name__ == '__main__': main()

