#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

class mplsTaggedRoutesAdd:
  def __init__(self, client):
    self.m_client = client

  def routesAdd(self):
    ip_prefix      = OpEN.open_inet_pfx_t()
    ip_nhop        = OpEN.open_inet_addr_t()
    labels         = OpEN.OPEN_MPLS_LABELS_t()
    out_parm_p     = OpEN.new_uint32_tp()


    
    # Create 3000 routes to 1000 ToR switches via 22.23.0.5
    #
    total_routes = 0
    print("Adding routes to 61.0.0.0/24 via 22.23.0.5")
    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    start_time = OpEN.uint32_tp_value(out_parm_p)

    for tor in range(0, 1000):
      for rt_per_tor in range(0, 3):
    	ip_prefix.pfxLen = 24
    	ip_prefix.ipAddr.family = OpEN.OPEN_AF_INET
    	ip_prefix.ipAddr.addr.ipv4 = 0x3d000000 + (tor << 16) + (rt_per_tor << 8)  # IP 61.0.0.0

    	ip_nhop.family = OpEN.OPEN_AF_INET
    	ip_nhop.addr.ipv4 = 0x16170005   # Next Hop 22.23.0.5 

    	egress_if = 76  # Port-based routing interface 0/76

    	# One label in the MPLS stack.
    	OpEN.uint32_tArray_setitem(labels.label,0,1000 + tor)

	result = OpEN.openapiIpRouteAdd(self.m_client, OpEN.OPEN_AF_INET, ip_prefix, 
					ip_nhop, 1, egress_if, labels)   	
	total_routes = total_routes + 1

    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    end_time = OpEN.uint32_tp_value(out_parm_p)
    delta_time = end_time - start_time
    print("Added %d routes in %d ms" % (total_routes, delta_time))

    # Add 3000 routes to 1000 ToR switches via 55.0.0.5 at lower priorority.
    #
    total_routes = 0
    print("Adding routes to 61.0.0.0/24 via 55.0.0.5")
    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    start_time = OpEN.uint32_tp_value(out_parm_p)

    for tor in range(0, 1000):
      for rt_per_tor in range(0, 3):
    	ip_prefix.pfxLen = 24
    	ip_prefix.ipAddr.family = OpEN.OPEN_AF_INET
    	ip_prefix.ipAddr.addr.ipv4 = 0x3d000000 + (tor << 16) + (rt_per_tor << 8)  # IP 61.0.0.0

    	ip_nhop.family = OpEN.OPEN_AF_INET
    	ip_nhop.addr.ipv4 = 0x37000005   # Next Hop 55.0.0.5 

    	egress_if = 1  # Port-based routing interface 0/1

    	# One label in the MPLS stack.
    	OpEN.uint32_tArray_setitem(labels.label,0,1000 + tor)

	result = OpEN.openapiIpRouteAdd(self.m_client, OpEN.OPEN_AF_INET, ip_prefix, 
					ip_nhop, 10, egress_if, labels)   	
	total_routes = total_routes + 1

    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    end_time = OpEN.uint32_tp_value(out_parm_p)
    delta_time = end_time - start_time
    print("Added %d routes in %d ms" % (total_routes, delta_time))

    # Delete 3000 routes to 1000 ToR switches via 22.23.0.5
    #
    total_routes = 0
    print("Deleting routes to 61.0.0.0/24 via 22.23.0.5")
    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    start_time = OpEN.uint32_tp_value(out_parm_p)

    for tor in range(0, 1000):
      for rt_per_tor in range(0, 3):
    	ip_prefix.pfxLen = 24
    	ip_prefix.ipAddr.family = OpEN.OPEN_AF_INET
    	ip_prefix.ipAddr.addr.ipv4 = 0x3d000000 + (tor << 16) + (rt_per_tor << 8)  # IP 61.0.0.0

    	ip_nhop.family = OpEN.OPEN_AF_INET
    	ip_nhop.addr.ipv4 = 0x16170005   # Next Hop 22.23.0.5 

    	egress_if = 76  # Port-based routing interface 0/76

    	# One label in the MPLS stack.
    	OpEN.uint32_tArray_setitem(labels.label,0,1000 + tor)

	result = OpEN.openapiIpRouteDel(self.m_client, OpEN.OPEN_AF_INET, ip_prefix, 
					ip_nhop, egress_if, labels)   	
	total_routes = total_routes + 1

    OpEN.openapiSystemUpTimeMsecGet(self.m_client, out_parm_p)
    end_time = OpEN.uint32_tp_value(out_parm_p)
    delta_time = end_time - start_time
    print("Deleted %d routes in %d ms" % (total_routes, delta_time))

def main():
  """Demonstrate OpEN usage MPLS-tagged routes"""

  open = OpENUtil()
  ret = open.connect("add_tagged_routes")
  if ret == OpEN.OPEN_E_NONE :
    open.getNetworkOSVersion()
    open.getAPIVersion()
    client = open.get_client()
    mplsExample = mplsTaggedRoutesAdd(client)
    mplsExample.routesAdd()
    open.terminate()
  else :
    print("Unable to connect")

if __name__ == '__main__': main()
