#!/usr/local/bin/perl
#
# Copyright 2016-2017 Broadcom
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

use File::Path;
use Shell;

my $root_dir = "../..";
my $openapi_inc_all = $root_dir . "/rpc/rpccom_openapi_all_incl.h"; 
my @openapi_include_files = &get_openapi_include_files;
my @rpc_header_files = ("proc_util.h","rpcclt_openapi.h","rpcclt_openapi_map.h","rpccom_openapi_all_incl.h","rpccom_openapi_routing.h");
my @rpc_include_files = &get_rpc_include_files;

my $swig_helper_pointer_functions = q'';
my $swig_helper_ft_pointer_functions = q'';

my $swig_related_content = q'
%typemap(in) unsigned char[((OPEN_EVENT_LAST) / 8) + 1] (unsigned char tmp[((OPEN_EVENT_LAST) / 8) + 1]) {
$1 = &tmp[0];
memset((void *) $1, 0, ((OPEN_EVENT_LAST) / 8) + 1);
memcpy((void *) arg2, (void *) RSTRING_PTR(argv[0]), RSTRING_LEN(argv[0]));
}
%{
void buf_to_open_sysExtAgentPktRxDesc_t(char *buf, open_sysExtAgentPktRxDesc_t* dst)
{
  memcpy((char*)dst ,(char*)buf, sizeof(open_sysExtAgentPktRxDesc_t));
}
%}
%include "stdint.i"
%include "cpointer.i"
%pointer_functions(uint8_t, uint8_tp);
%pointer_functions(uint16_t, uint16_tp);
%pointer_functions(int32_t, int32_tp);
%pointer_functions(uint32_t, uint32_tp);
%pointer_functions(uint64_t, uint64_tp);
%pointer_functions(bool, bool_tp);
%pointer_functions(open_in6_addr_t, open_in6_addr_tp);
%pointer_functions(OPEN_TCAM_API_POLICYID_t, OPEN_TCAM_API_POLICYID_tp);
%pointer_functions(open_sysExtAgentPktRxDesc_t, open_sysExtAgentPktRxDesc_tp);


%include "carrays.i"
%array_functions(uint32_t, uint32_tArray);
%array_functions(uint16_t, uint16_tArray);
%array_functions(uint8_t, uint8_tArray);
%array_class(int, IntArray);
%array_class(char, CharArray);
%array_class(unsigned char, UcharArray);
%array_functions(OPEN_BOOL_t, OPEN_BOOL_tArray)
';




my $openwrap_content = qq|%module OpEN_routing

%{
#define SWIG_FILE_WITH_INIT 1
#ifndef bool
#include <stdbool.h>
#endif
@{[&print_includes("#", @rpc_include_files)]}
@{[&print_includes("#", @openapi_include_files)]}


char *getStringFromUcharArray(unsigned char x[])
{
  return (char *) x;
}

#if defined (OPENAPI_ROUTING_STATS_H_INCLUDED)
size_t getopenEcmpRouteProtocolCount_tSize()
{
  return sizeof(openEcmpRouteProtocolCount_t);
}
#endif

%}

@{[$swig_related_content]}
@{[$swig_helper_pointer_functions]}
@{[$swig_helper_ft_pointer_functions]}
@{[&print_includes("%", @rpc_include_files)]}
@{[&print_includes("%", @openapi_include_files)]}
%include "../../api/include/openapi_swig_helpers.h"
@{[&print_enums]}

#if defined(OPENAPI_BGP_CONFIG_H_INCLUDED)
%pointer_functions(open_bgpPeerStatus_t, open_bgpPeerStatus_tp);
%pointer_functions(open_bgpDecProcHist_t, open_bgpDecProcHist_tp);
#endif

#if defined(OPENAPI_ROUTING_H_INCLUDED)
%pointer_functions(openBfdSessionInfo_t, openBfdSessionInfo_tp);
#endif

char *getStringFromUcharArray(unsigned char x[]);

#if defined (OPENAPI_ROUTING_STATS_H_INCLUDED)
%array_functions(openEcmpRouteProtocolCount_t, openEcmpRouteProtocolCount_tArray);
%pointer_functions(openRouteStats_t, openRouteStats_tp);
size_t getopenEcmpRouteProtocolCount_tSize();
#endif

#if defined(OPENAPI_MPLS_H_INCLUDED)
%pointer_functions(OPEN_MPLS_LABELS_t, OPEN_MPLS_LABELS_tp);
#endif

|;

open(OUTFILE, ">./openwrap_routing.i");
print OUTFILE $openwrap_content;
close(OUTFILE);

sub get_helper_functions
{
  my ($filename) = @_;
  my $content;
  open(my $fh, '<', $filename) or die "cannot open file $filename";
  {
    local $/;
    $content = <$fh>;
  }
  close($fh);

  #remove comments in the file
  $content =~ s#/\*[^*]*\*+([^/*][^*]*\*+)*/
           |//[^\n]*
           |("(\\.|[^"\\])*" | '(\\.|[^'\\])*' | .[^/"'\\]*)
           #defined $2 ? $2 : ""#gsex;

  return $content;
}

sub print_enums
{
  my @enums = &get_enums;
  my $str = "";
  foreach my $enum (@enums)
  {
    $str .= "%pointer_functions(". $enum . ", " . $enum . "p" . ");\n";
  }
  return $str;
}

sub get_enums
{
  my @enums = ();

  foreach my $header_file (@openapi_include_files)
  {
    #read contents of a file into a variable
    my $content = do {
        local $/ = undef;
        open my $fh, "<", $header_file
            or die "could not open $header_file: $!";
        <$fh>;
    };
    #remove comments in the file
    $content =~ s#/\*[^*]*\*+([^/*][^*]*\*+)*/
             |//[^\n]*
             |q("(\\.|[^"\\])*" | '(\\.|[^'\\])*' | .[^/"'\\]*)
             #defined $2 ? $2 : ""#gsex;

    while ($content =~ /(typedef\s+enum\s*{[^}]*}[^;]+;)/g)
    {
      my ($tmp1, $enumName) = split("}", $1);
      $enumName =~ s/^\s+//; #remove leading spaces
      $enumName =~ s/\s+$//; #remove trailing spaces
      chop($enumName); #remove last character ';'
      push(@enums, $enumName);
    }
  }
  return @enums;
}

sub print_includes
{
  my ($suffix, @file_list) = @_;
  my $str = "";
  foreach my $this_file (@file_list)
  {
    $str .= $suffix . "include \"" . $this_file . "\"\n";
  }
  chomp($str);
  return $str;
}

sub get_rpc_include_files
{
  my @files = ();
  foreach $rpc_file (@rpc_header_files)
  {
    my $this_file = $root_dir . "/rpc/" . $rpc_file;
    push(@files, $this_file);
  }
  return @files;
}

sub get_openapi_include_files
{
  return &get_include_files;
}

sub get_include_files
{
  my ($suffix) = @_;
  my @files = ();

  my $inc_content = do {
      local $/ = undef;
      open my $fh, "<", $openapi_inc_all
          or die "could not open $openapi_inc_all: $!";
      <$fh>;
  };
  @i_files = ( "openapi_common.h",
"openapi_bgp_config.h",
"openapi_dhcp_server.h",
"openapi_dhcp6s.h",
"openapi_ip_route_table.h",
"openapi_ip6map.h",
"openapi_ip6radv.h",
"openapi_iphelper.h",
"openapi_ipsla.h",
"openapi_ipv4_device_tracking.h",
"openapi_issu.h",
"openapi_l2ol3tunnel.h",
"openapi_ospf_config.h",
"openapi_routing_arptable.h",
"openapi_routing_config.h",
"openapi_common.h",
"openapi_routing_rtrdisc.h",
"openapi_routing_stats.h",
"openapi_routing.h",
"openapi_sdm.h",
"openapi_mpls.h");

  my $list_of_include_file = "";
  open(allHeaderFiles, "find $root_dir/api -name '*.h' -print|sort|");
  while (my $file = <allHeaderFiles>)
  {
    
    chomp($file);
    my $basename = basename($file);
    chomp($basename);
    if ($inc_content =~ /$basename/  && ("@i_files" =~ /\b$basename\b/)) 
    {
      push(@files, $file); 
    }
  }
  close(allHeaderFiles);
  return @files;
}

