/*********************************************************************
*
*  Copyright 2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  openapi_pml.h
*
* @purpose   Port MAC Locking (PML) Configuration and Status
*
* @component OPEN
*
* @create    09/10/2018
*
* @end
*
**********************************************************************/
#ifndef OPENAPI_PML_H_INCLUDED
#define OPENAPI_PML_H_INCLUDED

#include "openapi_common.h"

/*********************************************************************
*
* @purpose  Get the Port MAC Locking Global Admin mode
*
* @param    clientHandle   @b{(input)}   client handle from registration API
* @param    adminMode      @b{(output)}  on success, PML global admin mode.
*
* @returns OPEN_E_NONE     On success. 
* @returns OPEN_E_PARAM    Bad parameter was passed.
* @returns OPEN_E_FAIL     On failure.
*
* @supported-in-version OpEN API Version: 1.18
*
* @end
*********************************************************************/
open_error_t openapiPmlGlobalAdminModeGet(openapiClientHandle_t *clientHandle, OPEN_CONTROL_t *adminMode);

/*********************************************************************
*
* @purpose Get whether an interface is a valid PML interface or not.
*
* @param    clientHandle   @b{(input)}   client handle from registration API
* @param    ifNum          @b{(input)}   interface number
* @param    isValid        @b{(output)}  if OPEN_TRUE, valid. Otherwise, OPEN_FALSE
*
* @returns OPEN_E_NONE     On success. 
* @returns OPEN_E_PARAM    Bad parameter was passed.
* @returns OPEN_E_FAIL     On failure.
*
* @supported-in-version OpEN API Version: 1.18
*
* @end
*

*********************************************************************/
open_error_t openapiPmlIntfIsValid(openapiClientHandle_t *clientHandle, uint32_t ifNum, OPEN_BOOL_t *isValid);

/*********************************************************************
*
* @purpose  Get the Port MAC Locking mode for the specified interface.
*
* @param    clientHandle   @b{(input)}   client handle from registration API
* @param    ifNum          @b{(input)}   interface number
* @param    mode           @b{(output)}  on success, PML interface admin mode
*
* @returns OPEN_E_NONE     On success.
* @returns OPEN_E_UNAVAIL  Interface is not a valid PML interface.
* @returns OPEN_E_PARAM    Bad parameter was passed.
* @returns OPEN_E_FAIL     On failure.
*
* @supported-in-version OpEN API Version: 1.18
*
* @end
*********************************************************************/
open_error_t openapiPmlIntfModeGet(openapiClientHandle_t *clientHandle, uint32_t ifNum, OPEN_CONTROL_t *mode);

/*********************************************************************
*
* @purpose  Get the Port MAC Locking dynamic limit for the specified interface
*
* @param    clientHandle   @b{(input)}   client handle from registration API
* @param    ifNum          @b{(input)}   interface number
* @param    limit          @b{(output)}  on success, dynamic limit
*
* @returns OPEN_E_NONE     On success. 
* @returns OPEN_E_UNAVAIL  Interface is not a valid PML interface.
* @returns OPEN_E_PARAM    Bad parameter was passed.
* @returns OPEN_E_FAIL     On failure.
*
* @supported-in-version OpEN API Version: 1.18
*
* @end
*********************************************************************/
open_error_t openapiPmlIntfDynamicLimitGet(openapiClientHandle_t *clientHandle, uint32_t ifNum, uint32_t *limit);

/*********************************************************************
*
* @purpose  Get the Port MAC Locking static limit for the specified interface
*
* @param    clientHandle   @b{(input)}   client handle from registration API
* @param    ifNum          @b{(input)}   interface number
* @param    limit          @b{(output)}  on success, static limit
*
* @returns OPEN_E_NONE     On success.
* @returns OPEN_E_UNAVAIL  Interface is not a valid PML interface.
* @returns OPEN_E_PARAM    Bad parameter was passed.
* @returns OPEN_E_FAIL     On failure.
*
* @supported-in-version OpEN API Version: 1.18
*
* @end
*********************************************************************/
open_error_t openapiPmlIntfStaticLimitGet(openapiClientHandle_t *clientHandle, uint32_t ifNum, uint32_t *limit);

/*********************************************************************
*
* @purpose  Get the Port MAC Locking violation trap mode for the specified interface
*
* @param    clientHandle   @b{(input)}   client handle from registration API
* @param    ifNum          @b{(input)}   interface number
* @param    trapMode       @b{(output)}  on success, PML violation trap mode
*
* @returns OPEN_E_NONE     On success.
* @returns OPEN_E_UNAVAIL  Interface is not a valid PML interface.
* @returns OPEN_E_PARAM    Bad parameter was passed.
* @returns OPEN_E_FAIL     On failure.
*
* @supported-in-version OpEN API Version: 1.18
*
* @end
*********************************************************************/
open_error_t openapiPmlIntfViolationTrapModeGet(openapiClientHandle_t *clientHandle, uint32_t ifNum, OPEN_CONTROL_t *trapMode);

/*********************************************************************
*
* @purpose  Get the Port MAC Locking violation D-Disable mode for the specified interface
*
* @param    clientHandle   @b{(input)}   client handle from registration API
* @param    ifNum          @b{(input)}   interface number
* @param    mode           @b{(output)}  on success, PML violation D-Disable mode
*
* @returns OPEN_E_NONE     On success.
* @returns OPEN_E_UNAVAIL  Interface is not a valid PML interface.
* @returns OPEN_E_PARAM    Bad parameter was passed.
* @returns OPEN_E_FAIL     On failure.
*
* @supported-in-version OpEN API Version: 1.18
*
* @end
*********************************************************************/
open_error_t openapiPmlIntfViolationDDisableModeGet(openapiClientHandle_t *clientHandle, uint32_t ifNum, OPEN_CONTROL_t *mode);

/*********************************************************************
*
* @purpose  Get the Port MAC Locking sticky mode for the specified interface
*
* @param    clientHandle   @b{(input)}   client handle from registration API
* @param    ifNum          @b{(input)}   interface number
* @param    stickyMode     @b{(output)}  on success, PML sticky mode
*
* @returns OPEN_E_NONE     On success.
* @returns OPEN_E_UNAVAIL  Interface is not a valid PML interface.
* @returns OPEN_E_PARAM    Bad parameter was passed.
* @returns OPEN_E_FAIL     On failure.
*
* @supported-in-version OpEN API Version: 1.18
*
* @end
*********************************************************************/
open_error_t openapiPmlIntfStickyModeGet(openapiClientHandle_t *clientHandle, uint32_t ifNum, OPEN_CONTROL_t *stickyMode);

#endif /* OPENAPI_PML_H_INCLUDED */
