/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  openapi_registry.h
*
* @purpose   To access System Registry Parameters 
*
* @component OpEN
*
* @create    01/11/2015
*
* @end
*                                    
**********************************************************************/
#ifndef OPENAPI_REGISTRY_H_INCLUDED
#define OPENAPI_REGISTRY_H_INCLUDED

#include "openapi_common.h"

#define  OPEN_REGISTRY_PARAM_SIZE 256

/*********************************************************************
* @purpose  Get the serial number
*
* @param    client_handle    @b{(input)}  Client handle from 
*                                         registration API
* @param    serial_number    @b{(output)} Serial Number
*
* @returns  OPEN_E_NONE      if serial number get successful.
* @returns  OPEN_E_FAIL      if serial number get failed.
* @returns  OPEN_E_PARAM     if serial_number->size supplied is not enough.
*
* @notes   Minimum size of serial_number should be OPEN_REGISTRY_PARAM_SIZE. 
* 
* @supported-in-version OpEN API Version: 1.3
*
* @end
*********************************************************************/
open_error_t openapiSystemRegSerialNumGet ( openapiClientHandle_t *client_handle,
                                            open_buffdesc         *serial_number  );

/*********************************************************************
* @purpose  Get the Machine Model number
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    machine_model    @b{(output)} Machine Model Number
*
* @returns  OPEN_E_NONE      if model number get successful.
* @returns  OPEN_E_FAIL      if model number get failed.
* @returns  OPEN_E_PARAM     if machine_model->size supplied is not enough.
*
* @notes   Minimum size of machine_model should be OPEN_REGISTRY_PARAM_SIZE.
*
* @supported-in-version OpEN API Version: 1.3
*
* @end
*********************************************************************/
open_error_t openapiSystemRegMachineModelGet ( openapiClientHandle_t *client_handle,
                                               open_buffdesc         *machine_model );

/*********************************************************************
* @purpose  Get the Machine Type Information
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    machine_type     @b{(output)} Machine type
*
* @returns  OPEN_E_NONE      if model type get successful.
* @returns  OPEN_E_FAIL      if model type get failed.
* @returns  OPEN_E_PARAM     if machine_type->size supplied is not enough.
*
* @notes   Minimum size of machine_type should be OPEN_REGISTRY_PARAM_SIZE.
*
* @supported-in-version OpEN API Version: 1.3
*
* @end
*********************************************************************/
open_error_t openapiSystemRegMachineTypeGet ( openapiClientHandle_t *client_handle,
                                              open_buffdesc         *machine_model );

/*********************************************************************
* @purpose  Get the software version information
*
* @param    client_handle    @b{(input)}  Client handle from
*                                         registration API
* @param    code_version     @b{(output)} Software version
*
* @returns  OPEN_E_NONE      Get successful.
* @returns  OPEN_E_FAIL      Get failed.
* @returns  OPEN_E_PARAM     Error in parameter passed.
*
* @notes   Minimum size of code_version should be OPEN_REGISTRY_PARAM_SIZE.
*
* @supported-in-version OpEN API Version: 1.19
*
* @end
*********************************************************************/
open_error_t openapiSystemRegCodeVersionGet(openapiClientHandle_t *client_handle,
                                            open_buffdesc *code_version);

#endif /* OPENAPI_REGISTRY_H_INCLUDED */
