/**********************************************************************
*
*  Copyright 2019 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
***********************************************************************
*
* @filename  openapi_static_filter.h
*
* @purpose   This code implements the OpEN Static Filter API
*
* @component OPEN
*
* @create    06/08/2019
*
* @end
*
*********************************************************************/
#ifndef OPENAPI_STATIC_FILTER_H_INCLUDED
#define OPENAPI_STATIC_FILTER_H_INCLUDED

#include "openapi_common.h" 

/*****************************************************************************
 * @purpose   Create a MAC Static Filter.
 *
 * @param     client_handle  @b{(input)} client handle from registration API
 * @param     buf            @b{(input)} static MAC address for the filter
 * @param     vlanID         @b{(input)} VLAN ID for the filter
 * @param     -              Minimum value @ref OPENAPI_DOT1Q_MIN_VLAN_ID
 * @param     -              Maximum value @ref OPENAPI_DOT1Q_MAX_VLAN_ID
 * 
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 * @returns   OPEN_E_INTERNAL         Internal error.
 * @returns   OPEN_E_EXISTS           Already exists.
 * @returns   OPEN_E_FULL             Maximum count reached or table full.
 *
 * @notes      
 *
 * @supported-in-version OpEN API Version: 1.20
 *
 * @end
 *****************************************************************************/
open_error_t openapiFilterCreate(openapiClientHandle_t *client_handle,
                                 open_buffdesc *buf, uint32_t vlanID);

/*****************************************************************************
 * @purpose   Remove a configured MAC Static Filter.
 *
 * @param     client_handle  @b{(input)} client handle from registration API
 * @param     buf            @b{(input)} static MAC address for the filter
 * @param     vlanID         @b{(input)} VLAN ID for the filter
 * @param     -              Minimum value @ref OPENAPI_DOT1Q_MIN_VLAN_ID
 * @param     -              Maximum value @ref OPENAPI_DOT1Q_MAX_VLAN_ID
 *
 * @returns   OPEN_E_NONE             On success.
 * @returns   OPEN_E_FAIL             On failure.
 * @returns   OPEN_E_PARAM            Invalid argument.
 * @returns   OPEN_E_INTERNAL         Internal error.
 *
 * @notes      
 *
 * @supported-in-version OpEN API Version: 1.20
 *
 * @end
 *****************************************************************************/
open_error_t openapiFilterRemove(openapiClientHandle_t *client_handle,
                                 open_buffdesc *buf, uint32_t vlanID);

#endif /* OPENAPI_STATIC_FILTER_H_INCLUDED */
