/*********************************************************************
*
*  Copyright 2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  openapi_switch_cpu.h
*
* @purpose   Switch CPU API
*
* @component OpEN
*
* @create    08/31/2018
*
* @end
*                                    
**********************************************************************/
#ifndef OPENAPI_SWITCH_CPU_H_INCLUDED
#define OPENAPI_SWITCH_CPU_H_INCLUDED

#include "openapi_common.h"

#define OPEN_CPU_UTIL_SCALAR 10000

typedef struct
{
  uint32_t timePeriod;   /**< Time period (secs) over which CPU utilization is being measured. */
  uint32_t utilization;  /**< Utilization of the CPU (% * OPEN_CPU_UTIL_SCALAR) */
} OPEN_CPU_PERIOD_UTIL_INFO_t;

/*********************************************************************
* @purpose  Get  CPU utilization for all tracked periods.
*
* @param    client_handle    @b{(input)}  Client handle from 
*                                         registration API
* @param    data             @b{(output)} CPU Utilization data.
*
* @returns  OPEN_E_NONE      operation was successful.
* @returns  OPEN_E_FAIL      a failure occurred.
* @returns  OPEN_E_PARAM     an invalid parameter was passed.
*
* @notes   Minimum number of bytes in data buffer is found by calling
*          openapiCpuUtilMaxPeriodsGet() and multiplying the result by 
*          sizeof(OPEN_CPU_PERIOD_UTIL_INFO_t). 
* @notes   Values in the utilization field of OPEN_CPU_PERIOD_UTIL_INFO_t
*          are floating point scaled by OPEN_CPU_UTIL_SCALAR and represented
*          as unsigned integer values. For example, 15.4567% will be 
*          represented as 154567. 
* 
* @supported-in-version OpEN API Version: 1.18
*
* @end
*********************************************************************/
open_error_t openapiTotalCpuUtilArrayGet(openapiClientHandle_t *client_handle,
                                         open_buffdesc *data);

/*********************************************************************
* @purpose  Get the maximum number of periods tracked for CPU utilization.
*
* @param    client_handle    @b{(input)}  Client handle from 
*                                         registration API
* @param    max              @b{(output)} Maximum number of tracked CPU utilization periods.
*
* @returns  OPEN_E_NONE      operation was successful.
* @returns  OPEN_E_PARAM     an invalid parameter was passed.
*
* @notes    
* 
* @supported-in-version OpEN API Version: 1.18
*
* @end
*********************************************************************/
open_error_t openapiCpuUtilMaxPeriodsGet(openapiClientHandle_t *client_handle,
                                         uint32_t *max);

#endif  /* OPENAPI_SWITCH_CPU_H_INCLUDED */
