
/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
**********************************************************************
*
* @filename  ip_example.c
*
* @purpose   Switch IP APIs Example.
*
* @component OPEN
*
* @comments
*
* @create    22/06/2015
*
* @end
*
**********************************************************************/
#include <stdlib.h>
#include <unistd.h>

#include "rpcclt_openapi.h"
#include "openapi_ip.h"
#include "openapi_common.h"
#include "proc_util.h"

/*******************************************************************
*
* @brief  This is the main function that will demonstrate 
*         Interface OpEN APIs.
*
* @returns  0: Success
* @returns  1: Failure
*
********************************************************************/
int main(int argc, char **argv)
{
  openapiClientHandle_t clientHandle;
  open_error_t result = OPEN_E_FAIL;
  open_buffdesc switch_os_revision;
  char switch_os_revision_string[100];
  char ipAddr[16];
  open_buffdesc strIpAddr;
  uint32_t intIpAddr = 0;
  uint32_t decimalIpValue = 0;
  uint32_t ifNum = 0;

  l7proc_crashlog_register();

  /* Register with OpEN */
  if ((result = openapiClientRegister("ip_example", &clientHandle)) != OPEN_E_NONE)
  {
    printf("\nFailed to initialize RPC to OpEN. Exiting result = %d\n", result);
    exit(2);
  }

  /* RPC call can fail until server starts. Keep trying */
  while (openapiConnectivityCheck(&clientHandle) != OPEN_E_NONE)
  {
    sleep(1);
  }
  printf("\n");
  switch_os_revision.pstart = switch_os_revision_string;
  switch_os_revision.size = sizeof(switch_os_revision_string);
  if (openapiNetworkOSVersionGet(&clientHandle, &switch_os_revision) == OPEN_E_NONE)
  {
    printf("Network OS version = %s\n", switch_os_revision_string);
  }
  else
  {
    printf("Network OS version retrieve error\n");
  }

  printf("\n");

  strcpy(ipAddr, "1.2.3.4");
  strIpAddr.pstart = ipAddr;
  strIpAddr.size = strlen(ipAddr)+1;

  if ((result = openapiInetAton(&clientHandle, &strIpAddr, &intIpAddr)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to convert internet address string to a 32 bit integer. result = %d\n", result);
    return 1;
  }
  else
  {
    printf("IP address is: string - \"%s\" integer - \"%d\" \n", ipAddr, intIpAddr);
  }

  if ((result = openapiIfFirstGet(&clientHandle, OPEN_INTF_TYPE_PHY, &ifNum)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to get first physical interface. result = %d\n", result);
    return 1;
  }

  if ((result = openapiIpAdEntAddrGet(&clientHandle, intIpAddr, ifNum)) != OPEN_E_NONE)
  {
    printf("The specified address entry does not exist. result = %d\n", result);
  }
  else
  {
    printf("Specified address entry exists.\n");
  }

  if ((result = openapiIpAdEntAddrGetNext(&clientHandle, &intIpAddr, &ifNum)) != OPEN_E_NONE)
  {
    printf("The first interface (%d) does not contain an address entry. result = %d\n", ifNum, result);
  }
  else
  {
    printf("The first interface (%d) contains address entry %d.\n", ifNum, intIpAddr);
  }

  if ((result = openapiIpAdEntAddrGetNext(&clientHandle, &intIpAddr, &ifNum)) != OPEN_E_NONE)
  {
    printf("The second interface (%d) does not contain an address entry. result = %d\n", ifNum, result);
  }
  else
  {
    printf("The second interface (%d) contains address entry %d.\n", ifNum, intIpAddr);
  }

  decimalIpValue = 0;
  if ((result = openapiIpEntIfIndexGet(&clientHandle, intIpAddr, &decimalIpValue)) != OPEN_E_NONE)
  {
    printf("The last interface index value does not exist. result = %d\n", result);
  }
  else
  {
    printf("The last interface index value is: %u\n", decimalIpValue);
  }

  decimalIpValue = 0;
  if ((result = openapiIpAdEntNetMaskGet(&clientHandle, intIpAddr, &decimalIpValue)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to get the subnet mask. result = %d\n", result);
  }
  else
  {
    printf("IP Address  (digital value) is: %d\n", intIpAddr);
    printf("Subnet mask (digital value) is: %u\n", decimalIpValue);
  }

  decimalIpValue = 0;
  if ((result = openapiIpAdEntBCastGet(&clientHandle, intIpAddr, &decimalIpValue)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to get the value of the least-significant bit in the IP broadcast address. result = %d\n", result);
  }
  else
  {
    printf("Value of the least-significant bit in the IP broadcast address is: %u\n", decimalIpValue);
  }

  decimalIpValue = 0;
  if ((result = openapiIpAdEntReasmMaxSizeGet(&clientHandle, intIpAddr, &decimalIpValue)) != OPEN_E_NONE)
  {
    printf("Bad return code trying to get the size of the largest IP datagram. result = %d\n", result);
  }
  else
  {
    printf("Size of the largest IP datagram is: %u\n", decimalIpValue);
  }
  /* Log goodbye message with OPEN */
  L7PROC_LOGF (L7PROC_LOG_SEVERITY_INFO, 0, "Stopping IP API example application");

  (void) openapiClientTearDown(&clientHandle);
  return 0;
}
