#
#  Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

#
# Python 2.6.6
#

import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

class ipRouteTableExample:
  def __init__(self, client):
    self.m_client = client

  def ipRouteTableExampleExampleUsage(self):
    routeDest_p = OpEN.new_uint32_tp()
    OpEN.uint32_tp_assign(routeDest_p, 0)

    routeMask_p = OpEN.new_uint32_tp()
    OpEN.uint32_tp_assign(routeMask_p, 0)

    routeProto_p = OpEN.new_OPEN_RTO_PROTOCOL_INDICES_tp()
    OpEN.OPEN_RTO_PROTOCOL_INDICES_tp_assign(routeProto_p, 0)

    routePref_p = OpEN.new_uint32_tp()
    OpEN.uint32_tp_assign(routePref_p, 0)
    
    result = OpEN.openapiIpRouteEntryGetNext(self.m_client, routeDest_p, routeMask_p, routeProto_p, routePref_p)
    if result != OpEN.OPEN_E_NONE:
      print "Cannot get IP Route Table entry. Error = '%d'" % (result)
    else:
      print "Route destination IP address(integer) is: %d" % (OpEN.uint32_tp_value(routeDest_p))
      print "Route mask is(integer): %d" % (OpEN.uint32_tp_value(routeMask_p))
      print "Route protocol(integer) is: %d" % (OpEN.OPEN_RTO_PROTOCOL_INDICES_tp_value(routeProto_p))
      print "Route preference is: %d" % (OpEN.uint32_tp_value(routePref_p))


      metric_p = OpEN.new_uint32_tp()
      result = OpEN.openapiIpRouteMetricGet(self.m_client, routeDest_p, routeMask_p, routeProto_p, routePref_p, metric_p)
      if result != OpEN.OPEN_E_NONE:
        print "Cannot get route metric. Error = '%d'" % (result)
      else
        print "Route metric is: %d" % (OpEN.uint32_tp_value(metric_p))
      OpEN.delete_uint32_tp(metric_p)


      routeAge_p = OpEN.new_uint32_tp()
      result = OpEN.openapiIpRouteAgeGet(self.m_client, routeDest_p, routeMask_p, routeProto_p, routePref_p, routeAge_p)
      if result != OpEN.OPEN_E_NONE:
        print "Cannot get route age. Error = '%d'" % (result)
      else
        print "Route age is: %d" % (OpEN.uint32_tp_value(routeAge_p))
      OpEN.delete_uint32_tp(routeAge_p)


      hwFailure_p = OpEN.new_OPEN_BOOL_tp()
      result = OpEN.openapiIpRouteHwFailureGet(self.m_client, routeDest_p, routeMask_p, routeProto_p, routePref_p, hwFailure_p)
      if result != OpEN.OPEN_E_NONE:
        print "Cannot get hardware failure status. Error = '%d'" % (result)
      else
        print "Hardware failure status is: %d" % (OpEN.OPEN_BOOL_tp_value(hwFailure_p))
      OpEN.delete_OPEN_BOOL_tp(hwFailure_p)


      next_hop_intf = OpEN.open_buffdesc()
      next_hop_intf.size = OpEN.OPEN_API_ROUTE_NEXT_HOP_INTF_BUF_MIN
      buf_intf = open_.getStringBuffer(next_hop_intf.size)
      next_hop_intf.pstart = buf_intf

      result = OpEN.openapiIpRouteNextHopIntfGet(self.m_client, routeDest_p, routeMask_p, routeProto_p, routePref_p, next_hop_intf)
      if result != OpEN.OPEN_E_NONE:
        print "Cannot get next hop interfaces. Error = '%d'" % (result)
      else
        print "Next hop interfaces: %s" % (buf_intf.cast())


      next_hop_addr = OpEN.open_buffdesc()
      next_hop_addr.size = OpEN.OPEN_API_ROUTE_NEXT_HOP_ADDR_BUF_MIN
      buf_addr = open_.getStringBuffer(next_hop_addr.size)
      next_hop_addr.pstart = buf_addr

      result = OpEN.openapiIpRouteNextHopAddrGet(self.m_client, routeDest_p, routeMask_p, routeProto_p, routePref_p, next_hop_addr)
      if result != OpEN.OPEN_E_NONE:
        print "Cannot get next hop IP addresses. Error = '%d'" % (result)
      else
        print "Next hop IP addresses: %s" % (buf_addr.cast())


    OpEN.delete_uint32_tp(routePref_p)
    OpEN.delete_uint32_tp(routeProto_p)
    OpEN.delete_uint32_tp(routeMask_p)
    OpEN.delete_uint32_tp(routeDest_p)



def main():
  """Demonstrate OpEN usage for IP Route Table APIs"""

  open = OpENUtil()
  ret = open.connect("ipRouteTableExample")
  if ret == OpEN.OPEN_E_NONE :
    open.getNetworkOSVersion()
    open.getAPIVersion()
    client = open.get_client()
    ipRouteTableExample = ipRouteTableExample(client)
    ipRouteTableExample.ipRouteTableExampleExampleUsage()
    open.terminate()
  else :
    print "Unable to connect"

if __name__ == '__main__': main()
