import OpEN_py as OpEN
from OpENUtil import *

open_ = OpENUtil()

#
# Copyright 2016 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#


class SnoopingExample :
  def __init__(self, client) :
    self.m_client = client


  def snooping_protocol_get (self, family, status) :
      result = OpEN.openapiSnoopProtocolGet(self.m_client, family, status)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def snooping_admin_mode_get (self, mode, family) :
      result = OpEN.openapiSnoopAdminModeGet(self.m_client, mode, family)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def snooping_control_frames_process_get (self, processedFrames, family) :
      result = OpEN.openapiSnoopControlFramesProcessedGet(self.m_client, processedFrames, family)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def snooping_control_frames_forwarded_get (self, forwardedFrames, family) :
      result = OpEN.openapiSnoopDataFramesForwardedGet(self.m_client, forwardedFrames, family)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def snooping_vlan_check_valid (self, valId) :
      result = OpEN.openapiSnoopVlanCheckValid(self.m_client, valId)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def snooping_vlan_next_get (self, valId, nextVlanId) :
      result = OpEN.openapiSnoopVlanNextGet(self.m_client, valId, nextVlanId)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def snooping_vlan_fast_leave_get (self, vlanID, status, family) :
      result = OpEN.openapiSnoopVlanFastLeaveModeGet(self.m_client, vlanID, status, family)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def snooping_vlan_maxim_response_time_get (self, vlanID, vlanResponseTime, family) :
      result = OpEN.openapiSnoopVlanMaximumResponseTimeGet(self.m_client, vlanID, vlanResponseTime, family)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

  def snooping_vlan_maxim_response_time_set (self, vlanID, vlanResponseTime, family) :
      result = OpEN.openapiSnoopVlanMaximumResponseTimeSet(self.m_client, vlanID, vlanResponseTime, family)
      if (result != OpEN.OPEN_E_NONE) :
       return -1
      else :
       return 0

def main() :
    """Demonstrate OpEN usage for Snooping APIs"""
    ret = open_.connect("snooping_example")
    if ret == OpEN.OPEN_E_NONE :
      open_.getNetworkOSVersion()
      client = open_.get_client()
      
      example = SnoopingExample(client)
      status = OpEN.new_OPEN_BOOL_tp()
      mode = OpEN.new_OPEN_CONTROL_tp()
      processedFrames = OpEN.new_uint32_tp()
      forwardedFrames = OpEN.new_uint32_tp()
      vlanId = OpEN.new_uint32_tp()
      OpEN.uint32_tp_assign(vlanId, 1)
      vlanResponseTime = OpEN.new_uint16_tp()

      if (example.snooping_protocol_get(OpEN.OPEN_AF_INET, status) != 0) :
       print "Failed to check if the passed family type snooping is supported or not."
      else :
       if (OpEN.OPEN_BOOL_tp_value(status) == OpEN.OPEN_FALSE) :
        print "Family type isn't supported." 
       else :
        print "Family type is supported."
      
      if (example.snooping_admin_mode_get(mode, OpEN.OPEN_AF_INET) != 0) :
       print "Failed to retrieve the IGMP Snooping Admin mode."
      else :
       if (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_ENABLE) :
        textMode = "enabeled."
       elif (OpEN.OPEN_CONTROL_tp_value(mode) == OpEN.OPEN_DISABLE) :
        textMode = "disableed."
       else :
        textMode = "undefined."
       print "The IGMP Snooping Admin mode is: %s" % (textMode)

      if (example.snooping_control_frames_process_get(processedFrames, OpEN.OPEN_AF_INET) != 0) :
       print "Failed to retrieve the number of multicast control frames processed."
      else :
       print "The number of multicast control frames processed is: %s" % (OpEN.uint32_tp_value(processedFrames))

      if (example.snooping_control_frames_forwarded_get(forwardedFrames, OpEN.OPEN_AF_INET) != 0) :
       print "Failed to retrieve the number of multicast data frames forwarded."
      else :
       print "The number of multicast data frames forwarded is: %s" % (OpEN.uint32_tp_value(forwardedFrames))

      if (example.snooping_vlan_check_valid(OpEN.uint32_tp_value(vlanId)) == 0) :
       print "Vlan ID is: %s." % (OpEN.uint32_tp_value(vlanId))
      else :
       if (example.snooping_vlan_next_get(OpEN.uint32_tp_value(vlanId), vlanId) == 0) :
        print "Vlan ID is: %s." % (OpEN.uint32_tp_value(vlanId))
       else :
        print "Failed to get vlan ID."

      if (example.snooping_vlan_fast_leave_get(OpEN.uint32_tp_value(vlanId), status, OpEN.OPEN_AF_INET) != 0) :
       print "Failed to get fast leave mode."
      else :
       if (OpEN.OPEN_BOOL_tp_value(status) == OpEN.OPEN_TRUE) :
        text = "enabled." 
       elif (OpEN.OPEN_BOOL_tp_value(status) == OpEN.OPEN_FALSE) :
        text = "disabled."
       else :
        text = "undefined."
       print "Snooping fast leave mode is: %s" % (text)

       if (example.snooping_vlan_maxim_response_time_get(OpEN.uint32_tp_value(vlanId), vlanResponseTime, OpEN.OPEN_AF_INET) != 0) :
        print "Failed to get IGMP snooping maximum response time for the specified VLAN."
       else :
        print "Snooping maximum response time for the specified VLAN[%s] is: %s" % (OpEN.uint32_tp_value(vlanId), OpEN.uint16_tp_value(vlanResponseTime))
  
       OpEN.uint16_tp_assign(vlanResponseTime, 5)
       if (example.snooping_vlan_maxim_response_time_set(OpEN.uint32_tp_value(vlanId), OpEN.uint16_tp_value(vlanResponseTime), OpEN.OPEN_AF_INET) != 0) :
        print "Failed to set IGMP snooping maximum response time for the specified VLAN."
       else :
        print "IGMP snooping maximum response time for the specified VLAN was sets successfully."

       if (example.snooping_vlan_maxim_response_time_get(OpEN.uint32_tp_value(vlanId), vlanResponseTime, OpEN.OPEN_AF_INET) != 0) :
        print "Failed to get IGMP snooping maximum response time for the specified VLAN."
       else :
        print "Snooping maximum response time for the specified VLAN[%s] is: %s" % (OpEN.uint32_tp_value(vlanId), OpEN.uint16_tp_value(vlanResponseTime))

    else :
     print "Unable to connect."
    open_.terminate()
if __name__ == '__main__': main()

