import OpEN_py as OpEN
from OpENUtil import *
import socket, struct

open_ = OpENUtil()

#
# Copyright 2016-2017 Broadcom.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#


#
# Python 2.6.6
#

def open_inet_addr_t2str(ip):
  return socket.inet_ntoa(struct.pack("!I", ip.addr.ipv4))

class SystemExample :
  def __init__(self, client):
    self.clientHandle = client

  def systemHostNameSet(self, hostName):
    try:
      buf = open_.getStringBuffer(len(hostName) + 1, hostName)
    except OpENBufferSizeError:
      print("systemHostNameSet: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("systemHostNameSet: getStringBuffer raised TypeError")
      return
    buffdesc = OpEN.open_buffdesc()
    buffdesc.pstart = buf
    buffdesc.size = len(hostName) + 1

    result = OpEN.openapiSystemHostnameSet(self.clientHandle, buffdesc)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to set system hostname. (result = %d)\n" % (result)
    else:
      print "System hostname is set successfully. (result = %d)\n" % (result)

    return
  
  
  def systemHostNameGet(self):
    hostnameSize_p = OpEN.new_uint32_tp()
    result = OpEN.openapiSystemHostnameSizeGet(self.clientHandle, hostnameSize_p)
    maxSize = OpEN.uint32_tp_value(hostnameSize_p)
    try:
      buf = open_.getStringBuffer(maxSize)
    except OpENBufferSizeError:
      print("systemHostNameGet: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("systemHostNameGet: getStringBuffer raised TypeError")
      return

    buffdesc = OpEN.open_buffdesc()
    buffdesc.pstart = buf
    buffdesc.size = maxSize
    
    result = OpEN.openapiSystemHostnameGet(self.clientHandle, buffdesc)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to get system hostname. (result = %d)\n" % (result)
    else:
      print "System hostname: %s. (result = %d)\n" % (buf.cast(), result)

    return
    
    
  def networkPortIPv4ParametersSet(self, ipStr, netmaskStr, gatewayStr):

    ipAddr = OpEN.open_inet_addr_t()
    netmask = OpEN.open_inet_addr_t()
    gateway = OpEN.open_inet_addr_t()
    
    ipBuffdesc = OpEN.open_buffdesc()
    try:
      str = open_.getStringBuffer(len(ipStr) + 1, ipStr)
    except OpENBufferSizeError:
      print("networkPortIPv4ParametersSet: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("networkPortIPv4ParametersSet: getStringBuffer raised TypeError")
      return
    ipBuffdesc.pstart = str
    ipBuffdesc.size = len(ipStr) + 1
    
    maskBuffdesc = OpEN.open_buffdesc()
    try:
      str1 = open_.getStringBuffer(len(netmaskStr) + 1, netmaskStr)
    except OpENBufferSizeError:
      print("networkPortIPv4ParametersSet: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("networkPortIPv4ParametersSet: getStringBuffer raised TypeError")
      return
    maskBuffdesc.pstart = str1
    maskBuffdesc.size = len(netmaskStr) + 1 
    
    gatewayBuffdesc = OpEN.open_buffdesc()
    try:
      str2 = open_.getStringBuffer(len(gatewayStr) + 1, gatewayStr)
    except OpENBufferSizeError:
      print("networkPortIPv4ParametersSet: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("networkPortIPv4ParametersSet: getStringBuffer raised TypeError")
      return
    gatewayBuffdesc.pstart = str2
    gatewayBuffdesc.size = len(gatewayStr) + 1
    
    ''' Validate IP address '''
    result = OpEN.openapiInetAddrGet(self.clientHandle, ipBuffdesc, ipAddr)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to convert IP address. (result = %d)\n" % (result)
      return

    ''' Validate network mask '''
    result = OpEN.openapiInetAddrGet(self.clientHandle, maskBuffdesc, netmask)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to convert network mask. (result = %d)\n" % (result)
      return

    ''' Validate gateway '''
    result = OpEN.openapiInetAddrGet(self.clientHandle, gatewayBuffdesc, gateway)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to convert gateway IP address. (result = %d)\n" % (result)
      return

    result = OpEN.openapiNetworkPortIPv4ParametersSet(self.clientHandle, ipAddr, netmask, gateway)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to set network port parameters. (result = %d)\n" % (result)
    else:
      print "Network port parameter are set successfully. (result = %d)\n" % (result)

    return
    
    
  def networkPortIPv4ParametersGet(self ):
    ipAddr = OpEN.open_inet_addr_t()
    netmask = OpEN.open_inet_addr_t()
    gateway = OpEN.open_inet_addr_t()


    ''' Get the IP address  and netmask'''
    result = OpEN.openapiNetworkPortIPv4AddrGet(self.clientHandle, ipAddr, netmask)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to get nework port IP address and subnet mask. (result = %d)\n" % (result)
    else:
      print "Network IP address: %s\n" % (open_inet_addr_t2str(ipAddr))
      print "Subnet Mask: %s\n" % (open_inet_addr_t2str(netmask))

    ''' Get the gateway '''
    result = OpEN.openapiNetworkPortGatewayIPv4AddrGet(self.clientHandle, gateway)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to get nework port gateway. (result = %d)\n" % (result)
    else:
      print "Gateway: %s\n" % (open_inet_addr_t2str(gateway))
    
    return

  def systemMaintenanceLevel(self):
    maxSize = OpEN.OPEN_SYSTEM_PARAM_SIZE
    try:
      buf = open_.getStringBuffer(maxSize)
    except OpENBufferSizeError:
      print("systemMaintenanceLevel: getStringBuffer raised OpENBufferSizeError")
      return
    except TypeError:
      print("systemMaintenanceLevel: getStringBuffer raised TypeError")
      return

    buffdesc = OpEN.open_buffdesc()
    buffdesc.pstart = buf
    buffdesc.size = maxSize

    result = OpEN.openapiMaintenanceLevelGet(self.clientHandle, buffdesc)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to get system maintenance level. (result = %d)\n" % (result)
    else:
      print "System Maintenance level: %s. (result = %d)\n" % (buf.cast(), result)

    return

  def clientResourceTrackingSet(self):
    ''' Enable client resource tracking '''
    result = OpEN.openapiClientResourceTrackingSet(self.clientHandle, OpEN.OPEN_ENABLE)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to enable client resource tracking. (result = %d)\n" % (result)
    else:
      print "Client resource tracking enabled. (result = %d)\n" % (result)

    ''' Disable client resource tracking '''
    result = OpEN.openapiClientResourceTrackingSet(self.clientHandle, OpEN.OPEN_DISABLE)
    if result != OpEN.OPEN_E_NONE:
      print "Bad return code trying to disable client resource tracking. (result = %d)\n" % (result)
    else:
      print "Client resource tracking disabled. (result = %d)\n" % (result)

    return
    
def main():
  ret = open_.connect("system_example")
  if ret == OpEN.OPEN_E_NONE:
    open_.getNetworkOSVersion()
    open_.getAPIVersion()
    client = open_.get_client()

    sysExample = SystemExample(client)
    sysExample.systemHostNameSet('test')
    sysExample.systemHostNameGet()
    sysExample.networkPortIPv4ParametersSet('1.2.3.4', '255.255.0.0', '1.2.3.1')
    sysExample.networkPortIPv4ParametersGet()
    sysExample.systemMaintenanceLevel()
    sysExample.clientResourceTrackingSet()

    open_.terminate()
  else:
    print "Unable to connect"


if __name__ == '__main__': main()
