/*********************************************************************
*
* Copyright 2016-2018 Broadcom.
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*      http://www.apache.org/licenses/LICENSE-2.0
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*************************************************************************
*
* @filename  userapp_example.c
*
* @purpose   Userapp config db Example.
*
* @component OPEN
*
* @comments
*
* @create    2/1/2016
*
* @end
*
***************************************************************************/
#include <stdlib.h>
#include <stdbool.h>
#include <unistd.h>

#include "rpcclt_openapi.h"
#include "proc_util.h"
#include "openapi_common.h"
#include "openapi_userapp_config_db.h"

#define MAX_STR_LEN 256

void testUserAppConfigDbGetNext(openapiClientHandle_t *clientHandle)
{
  open_error_t result = OPEN_E_FAIL;
  const uint32_t testDBSize = 5;
  uint32_t counter = 0;
  uint32_t index = 0;
  const uint32_t maxStrLen = MAX_STR_LEN;
  char *keyAppDbName = "databaseExample";
  char keyStr[MAX_STR_LEN + 1] = {'\0'};
  char dataStr[MAX_STR_LEN + 1] = {'\0'};

  open_buffdesc appDbName = {(strnlen(keyAppDbName, maxStrLen) + 1), keyAppDbName};
  open_buffdesc key = {maxStrLen, keyStr};
  open_buffdesc data = {maxStrLen, dataStr};
  const open_buffdesc keys[] =
  {
    {(strnlen("keyName1", maxStrLen) + 1), "keyName1"},
    {(strnlen("keyName2", maxStrLen) + 1), "keyName2"},
    {(strnlen("keyName3", maxStrLen) + 1), "keyName3"},
    {(strnlen("keyName4", maxStrLen) + 1), "keyName4"},
    {(strnlen("keyName5", maxStrLen) + 1), "keyName5"}
  };
  const open_buffdesc dataArr[] =
  {
    {(strnlen("data1", maxStrLen) + 1), "data1"},
    {(strnlen("data2", maxStrLen) + 1), "data2"},
    {(strnlen("data3", maxStrLen) + 1), "data3"},
    {(strnlen("data4", maxStrLen) + 1), "data4"},
    {(strnlen("data5", maxStrLen) + 1), "data5"}
  };
  
  if (OPEN_E_NONE != openapiUserAppConfigDbCreateAppDb(clientHandle, appDbName))
  {
    printf("Creating new database:  %s  FAILURE\n", (char *) appDbName.pstart);
    printf("Test openapiUserAppConfigDbGetNext() function was finished.\n");
    return;
  }
  
  while (index < testDBSize)
  {
    printf("Key name: %s\n", (char *) keys[index].pstart);
    printf("Key size: %u\n", keys[index].size);
    printf("Data: %s\n", (char *) dataArr[index].pstart);
    printf("Data size: %u\n", dataArr[index].size);
	
    if (OPEN_E_NONE == openapiUserAppConfigDbSet(clientHandle, appDbName, keys[index], dataArr[index]))
    {
      printf("Applying entry to database: %s, with keyname: %s, and value: %s  SUCCESS\n", (char *) appDbName.pstart,
             (char *) keys[index].pstart, (char *) dataArr[index].pstart);
    }
    else
    {
      printf("Applying entry to database: %s, with keyname: %s, and value: %s  FAILURE\n", (char *) appDbName.pstart,
             (char *) keys[index].pstart, (char *) dataArr[index].pstart);
      printf("Test openapiUserAppConfigDbGetNext() function was finished.\n");
      return;
    }
    index++;
  }

  /* This example returns the first element */
  result = openapiUserAppConfigDbGetNext(clientHandle, appDbName, &key, &data);
  switch (result)
  {
    case OPEN_E_NONE:
      printf("First element key: %s\n", (char *) key.pstart);
      printf("First element key size: %u\n", key.size);
      printf("First element key data: %s\n", (char *) data.pstart);
      break;
    case OPEN_E_PARAM:
      printf("OPEN_E_PARAM: Invalid input parameters.\n");
      break;
    case OPEN_E_NOT_FOUND:
      printf("OPEN_E_NOT_FOUND: Application DB was not found.\n");
      break;
    case OPEN_E_UNAVAIL:
      printf("OPEN_E_UNAVAIL: Item with specified keyName wasn't found.\n");
      break;
    default:
      printf("OPEN_E_FAIL: Internal error.\n");
      break;
  }

  /* This example returns the next element */
  snprintf(key.pstart, maxStrLen, "keyName3");
  key.size = maxStrLen;
  memset(data.pstart, 0, maxStrLen);
  data.size = maxStrLen;
  result = openapiUserAppConfigDbGetNext(clientHandle, appDbName, &key, &data);
  switch (result)
  {
    case OPEN_E_NONE:
      printf("Next element key: %s\n", (char *) key.pstart);
      printf("Next element key size: %u\n", key.size);
      printf("Next element key data: %s\n", (char *) data.pstart);
      break;
    case OPEN_E_PARAM:
      printf("OPEN_E_PARAM: Invalid input parameters.\n");
      break;
    case OPEN_E_NOT_FOUND:
      printf("OPEN_E_NOT_FOUND: Application DB was not found.\n");
      break;
    case OPEN_E_UNAVAIL:
      printf("OPEN_E_UNAVAIL: Item with specified keyName wasn't found.\n");
      break;
    default:
      printf("OPEN_E_FAIL: Internal error.\n");
      break;
  }

  /* This example returns all values after a given key */
  snprintf(key.pstart, maxStrLen, "keyName2");
  memset(data.pstart, 0, maxStrLen);
  data.size = maxStrLen;
  do
  {
    key.size = maxStrLen;
    result = openapiUserAppConfigDbGetNext(clientHandle, appDbName, &key, &data);
    switch (result)
    {
      case OPEN_E_NONE:
        printf("Number of element:  %u\n", counter);
        printf("Next key: %s\n", (char *) key.pstart);
        printf("Next key size: %u\n", key.size);
        printf("Next key data: %s\n------------------------------------\n", (char *) data.pstart);
        counter++;
        break;
      case OPEN_E_PARAM:
        printf("OPEN_E_PARAM: Invalid input parameters.\n");
        break;
      case OPEN_E_NOT_FOUND:
        printf("OPEN_E_NOT_FOUND: Application DB was not found.\n");
        break;
      case OPEN_E_UNAVAIL:
        printf("OPEN_E_UNAVAIL: Item with specified keyName wasn't found.\n");
        break;
      default:
        printf("OPEN_E_FAIL: Internal error.\n");
        break;
    }
  } while (result == OPEN_E_NONE);

  if (OPEN_E_NONE == openapiUserAppConfigDbDeleteAppDb(clientHandle, appDbName))
  {
    printf("Deleting database:  %s  SUCCESS\n", (char *) appDbName.pstart);
  }
  else
  {
    printf("Deleting database:  %s  FAILURE\n", (char *) appDbName.pstart);
  }
}

/*******************************************************************
*
* @brief  This is the main function that will demonstrate 
*         userapp_config_db OpEN APIs.
*
* @returns  0: Success
* @returns  1: Failure
*
********************************************************************/
int main(int argc, char **argv)
{
  char *keyAppDbName = "database_example";
  char *keyNameMode = "entry_example";
  char *keyData = "data_example";
  openapiClientHandle_t clientHandle;
  open_error_t result = OPEN_E_FAIL;
  open_buffdesc switch_os_revision;
  char switch_os_revision_string[100];
  l7proc_crashlog_register();
  open_buffdesc keyName, dataget;
  char datagt[100] = "\0";

  /* Register with OpEN */
  if ((result = openapiClientRegister("userapp_config_db_example", &clientHandle)) != OPEN_E_NONE)
  {
    printf("\nFailed to initialize RPC to OpEN. Exiting result = %d\n", result);
    exit(2);
  }

  /* RPC call can fail until server starts. Keep trying */
  while (openapiConnectivityCheck(&clientHandle) != OPEN_E_NONE)
  {
    sleep(1);
  }
  printf("\n");
  switch_os_revision.pstart = switch_os_revision_string;
  switch_os_revision.size = sizeof(switch_os_revision_string);
  if (openapiNetworkOSVersionGet(&clientHandle, &switch_os_revision) == OPEN_E_NONE)
  {
    printf("Network OS version = %s\n", switch_os_revision_string);
  }
  else
  {
    printf("Network OS version retrieve error\n");
  }
  printf("\n");

  open_buffdesc appDbName = {strnlen(keyAppDbName, MAX_STR_LEN) + 1,
                           keyAppDbName};
  open_buffdesc data = {strnlen(keyData, MAX_STR_LEN) + 1,
                           keyData};

  if (OPEN_E_NONE == openapiUserAppConfigDbCreateAppDb(&clientHandle, appDbName))
  {
    printf("Creating new database:  %s  SUCCESS\n",(char *) appDbName.pstart);
  }
  else
  {
    printf("Creating new database:  %s  FAILURE\n",(char *) appDbName.pstart);
  }

  keyName.size = strlen(keyNameMode)+1;
  keyName.pstart = keyNameMode;

  dataget.size = 100;
  dataget.pstart = datagt;

  if (OPEN_E_NONE == openapiUserAppConfigDbSet(&clientHandle, appDbName, keyName, data))
  {
    printf("Applying entry to database: %s, with keyname: %s, and value: %s  SUCCESS\n", (char *) appDbName.pstart,
           (char *) keyName.pstart, (char *) data.pstart);
  }
  else
  {
    printf("Applying entry to database: %s, with keyname: %s, and value: %s  FAILURE\n", (char *) appDbName.pstart,
            (char *) keyName.pstart, (char *) data.pstart);
  }

  if (OPEN_E_NONE == openapiUserAppConfigDbGet(&clientHandle, appDbName, keyName, &dataget))
  {
    printf("Fetching value for keyname: %s SUCCESS\n",(char *) keyName.pstart);
  }
  else
  {
    printf("Fetching value for keyname: %s FAILURE\n",(char *) keyName.pstart);
  }

  printf("\n-------Test openapiUserAppConfigDbGetNext() function-------\n");
  testUserAppConfigDbGetNext(&clientHandle);
  printf("-------Test openapiUserAppConfigDbGetNext() function-------\n\n");

  if (OPEN_E_NONE == openapiUserAppConfigDbRemoveItem(&clientHandle, appDbName, keyName))
  {
    printf("Removing entry for keyname: %s SUCCESS\n",(char *) keyName.pstart);
  }
  else
  {
    printf("Removing entry for keyname: %s FAILURE\n",(char *) keyName.pstart);
  }
  
  if (OPEN_E_NONE == openapiUserAppConfigDbGet(&clientHandle, appDbName, keyName, &dataget))
  {
    printf("Fetching value for keyname: %s exist FAILURE\n", (char *) keyName.pstart);
  }
  else
  {
    printf("Fetching value for keyname: %s doesn't exist SUCCESS\n", (char *) keyName.pstart);
  }


  if (OPEN_E_NONE == openapiUserAppConfigDbDeleteAppDb(&clientHandle, appDbName))
  {
    printf("Deleting database:  %s  SUCCESS\n", (char *) appDbName.pstart);
  }
  else
  {
    printf("Deleting database:  %s  FAILURE\n", (char *) appDbName.pstart);
  }

  /* Log goodbye message */
  L7PROC_LOGF(L7PROC_LOG_SEVERITY_INFO, 0, "Stopping userapp example application");

  (void) openapiClientTearDown(&clientHandle);
  return 0;
}

