#!/bin/sh

ip=$1
image=$2
userid=$3
password=$4
paramnum=$#
min=2

if [ $paramnum -lt $min ]; then 
 echo "Input parameter number : $paramnum "
 echo "The input parameter number should be more than 2."
 echo "Example: ./ucpld_oob.sh <BMC IP> <CPLD Image> <user ID> <password>"
 echo "         <BMC IP> and <CPLD Image> is necessary. "
 cd ../..
 exit 0
fi

if [ "$userid" = "" ]; then
 userid="qct.admin"
fi

if [ "$password" = "" ]; then
 password="qct.admin"
fi


cd linuxflash

#check architecture
CMD=`uname -m | cut -c 1-6`
if [ "$CMD" = "x86_64" ]; then
   cd Linux_x86_64
   echo ""
   echo Linux x86_64 Environment
   chmod 777 Yafuflash2

   if [ -f "../../$image" ]; then
   		./Yafuflash2 -d 4 -nw -ip $ip -u $userid -p $password ../../$image
   else 
	   	 echo "can not find $image"   
   fi
else
   cd Linux_x86_32
   echo ""
   echo Linux x86 Environment
   chmod 777 Yafuflash2

   if [ -f "../../$image" ]; then
   		./Yafuflash2 -d 4 -nw -ip $ip -u $userid -p $password ../../$image
   else
   	     echo "can not find $image"  
   fi

fi

cd ../..
