/*
Ŀ
PCOPY_MARK: this procedure provide the copy mark function for the character   
marks.                                                                        

*/
defproc pcopy_mark(var destfirstline,var destlastline,var destfirstcol,var destlastcol)
   if marktype()='CHAR' then
      getmark firstline,lastline,firstcol,lastcol,mkfileid
      getfileid thisfileid
      samefile=(thisfileid=mkfileid)

      if not .line then insert; .line=1 endif /* Corrected HURLEYJ */
      if .line<1 or .line>.last then
        sayerror 'Error in pcopy_mark: .line='.line
        stop
      endif

      /* compute the overlay condition */
      if samefile then         -- Don't bother if different files.
         if (.line = lastline and .line = firstline and firstcol <= .col and .col <= lastcol) or
            (.line = firstline and .line <> lastline and firstcol <= .col ) or
            (.line = lastline and .line <> firstline and .col <= lastcol) or
            (firstline < .line and .line < lastline )
         then
            sayerror 'Source and target conflict'
            stop
         endif
      endif

      getline line
      if .col = 1 then
         leftline =''
      else
         leftline = substr(line,1,.col-1)
      endif
      rightline = substr(line,.col)

      /* first case lastline=firstline */
      if lastline = firstline then
         getline firstmarkedline,firstline,mkfileid
         replaceline leftline||substr(firstmarkedline,firstcol,lastcol+1-firstcol)||rightline
         len = lastcol+1-firstcol

         /* compute new position of source marked area and destination (for pmove) */
         destfirstline = .line; destlastline = .line
         destfirstcol = .col; destlastcol = destfirstcol+len-1
         if samefile and .line=firstline then
            if .col < firstcol then
               firstcol = firstcol+len
               lastcol  = lastcol+len
            else
               destfirstcol = .col-len; destlastcol = destfirstcol+len-1
            endif
         endif
      else
         /* the other cases */
         svfirstline = firstline; svlastline = lastline
         destfirstline = .line; destfirstcol = .col
         getline firstmarkedline,firstline,mkfileid
         getline lastmarkedline,lastline,mkfileid

         /* proceed the first line */
         replaceline leftline||substr(firstmarkedline,firstcol)
         /* proceed intermediate lines */
         fix=lastline-firstline-1
         if samefile then
            if firstline>=.line then
               firstline=firstline+fix
               lastline=lastline+fix
            else
               destfirstline = destfirstline-fix-1
            endif
         endif
         destlastline = destfirstline + fix + 1
         for i=.line+1 to .line+fix
            insertline '',i
         endfor
         for i = firstline+1 to lastline-1
            getline markedline,i,mkfileid
            replaceline  markedline,.line + i - firstline
         endfor
         /* proceed the last line */
         insertline substr(lastmarkedline,1,lastcol)||rightline,.line+lastline-firstline

         /* compute new position of source marked area and destination (for pmove) */
         destfirstcol=.col
         destlastcol=length(substr(lastmarkedline,1,lastcol))
         firstline = svfirstline; lastline = svlastline
         if .line <= firstline then
            if .line = firstline then
               firstcol = lastcol+firstcol+1-.col
            endif
            len = lastline-firstline
            firstline = firstline+len; lastline = lastline+len
         endif
         if samefile and destlastline=lastline and lastcol<.col then
            destfirstcol=.col+firstcol-1-lastcol
         endif
      endif
      /* set the new marks if necessary */
      if samefile then
;        unmark   -- Ver. 3.09a:  pset_mark does an unmark
         call pset_mark(firstline,lastline,firstcol,lastcol,'CHAR',mkfileid)
      endif
      rc=0
   else
      /* Added so that VARs are always defined - HURLEYJ */
      getmark destfirstline,destlastline,destfirstcol,destlastcol,mkfileid

      rc=0    /* Watch for memory-full, return its rc. */
      copy_mark
   endif
   return rc


/*
Ŀ
PCOMMON_ADJUST_OVERLAY:  provide the adjust mark and overlay mark function    
for the character and line marks.                                             

*/
defproc pcommon_adjust_overlay(letter)
   call checkmark()
   mt=marktype()
   if mt<>'BLOCK' then             -- Change to block mark
      getmark firstline,lastline,firstcol,lastcol,mkfileid
      if mt='CHAR' & firstline<>lastline then
         sayerror 'Character marks must begin and end on the same line.'
         stop
      endif
      call pset_mark(firstline,lastline,firstcol,lastcol,'BLOCK',mkfileid)
   endif
   if letter='A' then adjustblock
   elseif letter='O' then overlay_block
   endif
   if mt<>'BLOCK' then             -- Restore mark type
      getmark firstline,lastline,firstcol,lastcol,mkfileid
      call pset_mark(firstline,lastline,firstcol,lastcol,mt,mkfileid)
   endif

/*
Ŀ
PDELETE_MARK: provide delete mark function for character mark                 

*/
defproc pdelete_mark(var destfirstline,var destlastline,var destfirstcol,var destlastcol)
   if marktype()='CHAR' then
      getmark firstline,lastline,firstcol,lastcol,mkfileid
      getline firstmarkedline,firstline,mkfileid
      /* build the new line */
      if firstcol = 1 then
         leftline = ''
      else
         leftline = substr(firstmarkedline,1,firstcol-1)
      endif
      getline lastmarkedline,lastline,mkfileid
      replaceline leftline||substr(lastmarkedline,lastcol+1),firstline,mkfileid
      /* delete the intermediate lines */
      if firstcol=1 and lastcol>=length(firstmarkedline) then
         i=0
         if destfirstline>firstline then
            destfirstline=destfirstline-1
            destlastline=destlastline-1
         endif
      else
         i=1
      endif
      for i = lastline to firstline+i by -1
         deleteline i,mkfileid
      endfor
      unmark
   else
      delete_mark
   endif

/*
Ŀ
PFILL_MARK: provide fill mark function for character mark                     

*/
defproc pfill_mark
   if marktype() = 'CHAR' then
      if not arg() then
         sayerror 'Type a character';k = getkey()
         /* Display error message - HURLEYJ */
         if length(k) > 1 then sayerror 'Error in PFill_Mark'; stop endif
      else
         k=substr(arg(1),1,1)
      endif
      call psave_pos(save_pos)
      call pinit_extract()
      do forever
         code = pextract_string(string)
         if code = 1 then leave endif
         if code = 0 then
            string = substr('',1,length(string),k)
            call pput_string_back(string)
         endif
      end
      call prestore_pos(save_pos)
      sayerror 0
   else
      if arg() then
         fill_mark arg(1)
      else
         fill_mark
      endif
   endif

/*
Ŀ
PMOVE_MARK: provide move mark function for the character marks.               

*/
defproc pmove_mark
   if marktype()='CHAR' then
      getfileid fileid
      call pcopy_mark(destfirstline,destlastline,destfirstcol,destlastcol)
      call pdelete_mark(destfirstline,destlastline,destfirstcol,destlastcol)
      /* marks the right area (we use the value computed in pcopy_mark) */
      call pset_mark(destfirstline,destlastline,destfirstcol,destlastcol,'CHAR',fileid)
      .line=destfirstline;.col=destfirstcol
   else
      move_mark
   endif

