/*                    C keys                            */
/*                                                      */
/*  The enter and space bar keys have been defined to do*/
/* specific C editing features.                         */

CONST
   I_like_my_cases_under_my_switch = 1
   I_like_a_semicolon_supplied_after_default = 0

defkeys c_keys

def ' '=
   universal expand_on

   if expand_on then
      if  not c_first_expansion() then
	 keyin ' '
      endif
   else
      keyin ' '
   endif

def enter=
   universal expand_on

   if expand_on & not pcommand_state() then
      if c_second_expansion() then
	 call maybe_autosave()
      else
	 call my_enter()
      endif
   else
      call my_enter()
   endif

/* Taken out, interferes with some people's c_enter. */
;def c_enter=   /* I like Ctrl-Enter to finish the comment field also. */
;   getline line
;   if pos('/*',line) then
;      if not pos('*/',line) then
;         end_line;keyin' */'
;      endif
;   endif
;   down;begin_line

def c_x=       /* Force expansion if we don't have it turned on automatic */
   if not c_first_expansion() then
      call c_second_expansion()
   endif

defproc c_first_expansion
   retc=1
   if .line and (not pcommand_state()) then
      getline line
      line=strip(line,'T')
      w=line
      word=upcase(w)
      if word='FOR' then
	 replaceline w' (; ; ) {'
	 insertline substr(word,1,length(word)-3)'} /* endfor */',.line+1
	 if not insert_state() then insert_toggle endif
	 .col=.col+2
      elseif word='IF' then
	 replaceline w' () {'
	 insertline substr(word,1,length(word)-2)'} else {',.line+1
	 insertline substr(word,1,length(word)-2)'} /* endif */',.line+2
	 if not insert_state() then insert_toggle endif
	 .col=.col+2
      elseif word='WHILE' then
	 replaceline w' () {'
	 insertline substr(word,1,length(word)-5)'} /* endwhile */',.line+1
	 if not insert_state() then insert_toggle endif
	 .col=.col+2
      elseif word='DO' then
	 replaceline w' {'
	 insertline substr(' ',1,length(word)-2,' ')'} while (  ); /* enddo */',.line+1
	 call einsert_line()
	 .col=.col+C_SYNTAX_INDENT    /* indent for new line */
      elseif word='SWITCH' then
	 replaceline w' () {'
	 insertline substr(word,1,length(word)-6)'} /* endswitch */',.line+1
	 if not insert_state() then insert_toggle endif
	 .col=.col+2    /* move cursor between parentheses of switch ()*/
      elseif word='MAIN' then
	 call enter_main_heading()
      else
	 retc=0
      endif
   else
      retc=0
   endif
   return retc

defproc c_second_expansion
   retc=1
   if .line then
      getline line
      parse value upcase(line) with '{' +0 a
      parse value line with word rest
      i=verify(word,'({:;','M',1)-1
      if i<=0 then i=length(word) endif
      firstword=upcase(substr(word,1,i))
      if firstword='FOR' then
	 /* do tabs to fields of C for statement */
	 cp=pos(';',line,.col)
	 if cp and cp>=.col then
	     .col=cp+2
	 else
	   cpn=pos(';',line,cp+1)
	   if cpn and (cpn>=.col) then
	     .col=cpn+2
	   else
	     call einsert_line()
	     .col=.col+C_SYNTAX_INDENT
	   endif
	 endif
      elseif firstword='CASE' or firstword='DEFAULT' then
	 call einsert_line()
	 if .line>2 then  /* take a look at the previous line */
	    getline prevline,.line-2
	    prevline=upcase(prevline)
	    parse value prevline with w .
	    if w='CASE' then  /* align case statements */
	       i=pos('C',prevline)
	       replaceline substr('',1,i-1)||word rest,.line-1
	       .col=i
	    elseif w<>'CASE' and w<>'SWITCH' then  /* shift current line over */
	       i=verify(prevline,' ')
	       if i then .col=i endif
	       if i>C_SYNTAX_INDENT then i=i-C_SYNTAX_INDENT else i=1 endif
	       .col=i
	       replaceline substr('',1,i-1)||word rest,.line-1
	    endif
	    /* get rid of line containing just a ; */
	    if firstword='DEFAULT' and .line <.last then
	       getline line,.line+1
	       if line=';' then
	          deleteline .line+1
	       endif
	    endif
	 endif
	 .col=.col+C_SYNTAX_INDENT
      elseif firstword='BREAK' then
	 call einsert_line()
	 c=.col
	 if .col>C_SYNTAX_INDENT then
	    .col=.col-C_SYNTAX_INDENT
	 endif
	 keyin 'case :';left
	 insertline substr('',1,c-1)'break;',.line+1
      elseif firstword='SWITCH' then
	 call einsert_line()
	 c=.col
	 if I_like_my_cases_under_my_switch then
	    keyin 'case :';left
	 else
	    keyin substr(' ',1,C_SYNTAX_INDENT)'case :';left
	    c=c+C_SYNTAX_INDENT
	 endif
	 insertline substr(' ',1,c+C_SYNTAX_INDENT-1)'break;',.line+1
	 /* look at the next line to see if this is the first time */
	 /* the user typed enter on this switch statement */
	 if .line<=.last-2 then
	    getline line,.line+2
	    i=verify(line,' ')
	    if i then
	       if substr(line,i,1)='}' then
	          if I_like_my_cases_under_my_switch then
	             if i>1 then
	                i=i-1
	                insertline substr(' ',1,i)'default:',.line+2
	             else
	                insertline 'default:',.line+2
	             endif
	          else
	             i=i+C_SYNTAX_INDENT-1
	             insertline substr(' ',1,i)'default:',.line+2
	          endif
	          if I_like_a_semicolon_supplied_after_default then
	             insertline substr(' ',1,i+C_SYNTAX_INDENT)';',.line+3
	          endif
	       endif
	    endif
	 endif
      elseif a='{' or firstword='{' then  /* firstword or last word {?*/
	 if firstword='{' then
	    replaceline  word rest
	    call einsert_line();.col=C_SYNTAX_INDENT+1
	 else
	    call einsert_line()
	    .col=.col+C_SYNTAX_INDENT
	 endif
      elseif firstword='MAIN' then
	 call enter_main_heading()
      elseif firstword='DO' then
	 insert
	 .col=length(a)+2
      elseif pos('/*',line) then
	 if not pos('*/',line) then
	    end_line;keyin' */'
	 endif
	 call einsert_line()
      else
	 retc=0
      endif
   else
      retc=0
   endif
   return retc

defproc enter_main_heading
   temp=substr('',1,C_SYNTAX_INDENT)  /* indent spaces */
   replaceline 'main(argc, argv, envp)'
   insertline temp'int argc;',.line+1         /* double indent */
   insertline temp'char **argv;',.line+2
   insertline temp'char **envp;',.line+3
   insertline '{',.line+4
   insertline '',.line+5
   if .cursory<7 then
      .cursory=7
   endif
   .line=.line +5
   .col=C_SYNTAX_INDENT+1
   insertline '}',.line+1
