/**********************************************************************/
/*                                                                    */
/*  SlimDraw            Revised from Davis Foulger's DRAW.E           */
/*                                                                    */
/*  Revised by Bryan Lewis 10/87 to save space (700 bytes saved out   */
/*  of 3760), avoid global state variables (no drawvar) and avoid key */
/*  redefinitions.  Uses a getkey loop instead of key defs, so can be */
/*  installed anywhere in E.E.                                        */
/*                                                                    */
/* 8/8/88:  Russ Williams added re-pressing F6 to change draw mode in */
/*          mid-stream.                                               */
/**********************************************************************/

compile if WANT_DRAW <> 1
def F6=
   cursor_command; delete; begin_line
   'draw'
compile endif

defc draw
   universal boxtab1,boxtab2,boxtab3,boxtab4
   universal g1,g2,g3,g4,g5,g6,g7,g8,g9,ga,gb

   style=upcase(substr(arg(1),1,1))
   if not length(style) or verify(style,"123456B/") then
      sayerror 'Valid args are:  1=  2=  3=|  4=  5=  6=  B=blank  or  /Any character'
      keyin 'Draw '
      return
   endif
   draw_setup(style)            /* RHW */

   if pcommand_state() then cursor_data endif
   istate=insert_state(); if istate=1 then insert_toggle endif

   loop
      k=getkey()
      /* Insert key toggles drawing; if insert is on, simply do the key. */
      if insert_state() then executekey k; iterate; endif
      if k=left then
	 draw_left()
      elseif k=right then
	 draw_right()
      elseif k=up then
	 draw_up()
      elseif k=down then
	 draw_down()
      /* Allow a few other keys for minor editing. */
      elseif k=backspace or k=' ' or k=home or k=end or k=del or k=ins then
	 executekey k
      /* allow change of draw mode if F6 pressed */
      elseif k=F6 then                                          /* RHW */
	sayerror 'Enter new mode:  1=  2=  3=|  4=  5=  6=  B=blank  or  /Any character' /* RHW */
	k=getkey()                                              /* RHW */
	if not length(k) or verify(k,"123456Bb/") then leave endif /* RHW */
	if k='/' then k=k||getkey() endif                       /* RHW */
	draw_setup(k)                                           /* RHW */
      else /* All other keys simply exit draw. */
	 leave
      endif
   endloop
   if istate<>insert_state() then insert_toggle endif
   sayerror 'Draw mode ended'

defproc draw_setup
   universal boxtab1,boxtab2,boxtab3,boxtab4
   universal g1,g2,g3,g4,g5,g6,g7,g8,g9,ga,gb

   style=upcase(substr(arg(1),1,1))
   /* Pick characters from a packed string rather than if's, to save space. */
   all6='Ź+|+++++++-+۵ض'
   if style='/' then
      drawchars=substr('',1,11,substr(arg(1),2,1)) /* 11 copies of 2nd char */
   elseif style='B' then
      drawchars=substr('',1,11,' ')
   else
      drawchars=substr(all6,11*style-10,11)
   endif
   g1=substr(drawchars,1,1); g2=substr(drawchars,2,1); g3=substr(drawchars,3,1)
   g4=substr(drawchars,4,1); g5=substr(drawchars,5,1); g6=substr(drawchars,6,1)
   g7=substr(drawchars,7,1); g8=substr(drawchars,8,1); g9=substr(drawchars,9,1)
   ga=substr(drawchars,10,1);gb=substr(drawchars,11,1)
   boxtab1=g1||g2||g4||g5||g7||g9||gb
   boxtab2=g1||g2||g3||g6||g8||g9||gb
   boxtab3=g1||ga||g4||g3||g7||g8||gb
   boxtab4=g9||ga||g5||g6||g7||g8||gb
   sayerror 'Draw mode:  arrow keys to draw;'||
	    '  Insert to raise the pen;  Esc or Enter to cancel.'
   return ''


defproc get_char
   universal linepos,colpos,target
   colpos=.col
   linepos=.line
   getline target
   return substr(target,.col,1)

defproc draw_up      /* draw logic for the up key */
   universal last,l,r,u,d,boxtab1,linepos,colpos
   universal g1,g2,g3,g4,g5,g6,g7,g8,g9,ga,gb

   if last='d' then up
   else c=get_char()
      if last=='u' and c==' ' then keyin g2;up;left
	 elseif not verify(c,boxtab1) then up
	 elseif c==g3 then keyin g1;up;left
	 elseif c==g6 then keyin g9;up;left
	 elseif c==g8 then keyin gb;up;left
	 elseif c==ga then
	    call left_right()
	    if l=1 and r=1 then keyin g7 elseif l=1 then keyin g4 else keyin g5 endif
	    up;left
	 else call left_right()
	      if last='r' and l=1 then keyin g4
	         elseif last='l' and r=1 then keyin g5
	         else keyin g2
	         endif
	      up;left
	 endif
      if linepos=1 then insert; .col=colpos
      else
	 c=get_char()
	 if c==g4 then keyin g1;left
	    elseif c==g5 then keyin g9;left
	    elseif c==g7 then keyin gb;left
	    elseif c==ga then
	        call left_right()
	        if l=1 and r=1 then keyin g8
	           elseif l=1 then keyin g3
	           else keyin g6
	           endif
	        left
	    endif
	 endif
      endif
   last='u'


defproc draw_down /* Draw logic for the Down key */
   universal last,l,r,u,d,boxtab2,linepos,colpos
   universal g1,g2,g3,g4,g5,g6,g7,g8,g9,ga,gb

   if last='u' then down
   else c=get_char()
      if last=='d' and c==' ' then keyin g2;down;left
	 elseif not verify(c,boxtab2) then down
	 elseif c==g4 then keyin g1;down;left
	 elseif c==g5 then keyin g9;down;left
	 elseif c==g7 then keyin gb;down;left
	 elseif c==ga then
	    call left_right()
	    if l=1 and r=1 then keyin g8 elseif l=1 then keyin g3 else keyin g6 endif
	    down;left
	 else call left_right()
	      if last='r' and l=1 then keyin g3
	         elseif last='l' and r=1 then keyin g6
	         else keyin g2
	         endif
	      down;left
	 endif
      if linepos=.last then insert;.col=colpos
      else
	 c=get_char()
	 if c==g3 then keyin g1;left
	    elseif c==g6 then keyin g9;left
	    elseif c==g8 then keyin gb;left
	    elseif c==ga then
	        call left_right()
	        if l=1 and r=1 then keyin g7
	           elseif l=1 then keyin g4
	           else keyin g5
	           endif
	        left
	    endif
	 endif
      endif
   last='d'


defproc left_right   /* Check character left and right of cursor position */
   universal last,l,r,boxtab3,boxtab4,lpos,rpos,target,colpos
   universal g1,g2,g3,g4,g5,g6,g7,g8,g9,ga,gb

   lpos=colpos-1
   if lpos > 0 then l = substr(target,lpos,1) else l = ' ' endif
   rpos=colpos+1
   if rpos < 255 then r = substr(target,rpos,1) else r = ' ' endif
   l=not verify(l,boxtab4) /*if verify(l,boxtab4)==0 then l=1 else l=0 endif*/
   r=not verify(r,boxtab3) /*if verify(r,boxtab3)==0 then r=1 else r=0 endif*/


defproc draw_left    /* Draw logic for the Left key */
   universal last,u,d,boxtab3
   universal g1,g2,g3,g4,g5,g6,g7,g8,g9,ga,gb

   if last=='r' then left
   else
      c=get_char()
      if last=='l' and c==' ' then keyin ga;left;left
	 elseif not verify(c,boxtab3) then left
	 elseif c==g5 then keyin g7;left;left
	 elseif c==g6 then keyin g8;left;left
	 elseif c==g9 then keyin gb;left;left
	 elseif c==g2 then
	    call up_down()
	    if u=1 and d=1 then keyin g1 elseif u=1 then keyin g4 else keyin g3 endif
	    left;left
	 else call up_down()
	      if last='u' and d=1 then keyin g3
	         elseif last='d' and u=1 then keyin g4
	         else keyin ga
	         endif
	      left;left
      endif
      c=get_char()
      if c==g4 then keyin g7;left
	 elseif c==g2 then
	     call up_down()
	     if u=1 and d=1 then keyin g9
	        elseif d=1 then keyin g6
	        else keyin g5
	        endif
	     left
	 elseif c==g3 then keyin g8;left
	 elseif c==g1 then keyin gb;left
      endif
   endif
   last='l'


defproc draw_right   /* Draw logic for the Right key */
   universal last,u,d,boxtab4,colpos
   universal g1,g2,g3,g4,g5,g6,g7,g8,g9,ga,gb

   if last=='l' then right
   else c=get_char()
      if last=='r' and c==' ' then
	keyin ga
      else
	 if not verify(c,boxtab4) then right
	 elseif c==g4 then keyin g7
	 elseif c==g3 then keyin g8
	 elseif c==g1 then keyin gb
	 elseif c==g2 then
	    call up_down()
	    if u=1 and d=1 then keyin g9 elseif d=1 then keyin g6 else keyin g5 endif
	 else call up_down()
	      if last='u' and d=1 then keyin g6
	         elseif last='d' and u=1 then keyin g5
	         else keyin ga
	         endif
	 endif
	 call left_right()
      endif
      c=get_char()
      if c==g5 then keyin g7;left
	 elseif c==g2 then
	     call up_down()
	     if u=1 and d=1 then keyin g1
	        elseif u=1 then keyin g4
	        else keyin g3
	        endif
	     left
	 elseif c==g6 then keyin g8;left
	 elseif c==g9 then keyin gb;left
      endif
   endif
   last='r'
   if colpos = 255 then left endif


defproc up_down   /* Check character above and below cursor position */
   universal u,d,boxtab1,boxtab2,linepos,colpos,dpos,upos,target
   universal g1,g2,g3,g4,g5,g6,g7,g8,g9,ga,gb

   if linepos=1 then u=0
      else
	 upos=linepos-1
	 getline target,upos
	 u = substr(target,colpos,1)
	 u=not verify(u,boxtab2)
   endif
   dpos=linepos+1
   if dpos > .last then d=' '
     else getline target,dpos
	  d = substr(target,colpos,1)
     endif
   d=not verify(d,boxtab1)
   getline target,linepos

