/*                    E      keys                       */
/*                                                      */
/* The enter and space bar keys have been defined to do */
/* specific E3 syntax structures.                       */

defkeys e_keys

def ' '=
   universal expand_on
   if expand_on then
      if  not e_first_expansion() then
         keyin ' '
      endif
   else
      keyin ' '
   endif

def enter=
   universal expand_on

   if expand_on & not pcommand_state() then
      if e_second_expansion() then
         call maybe_autosave()
      else
         call my_enter()
      endif
   else
      call my_enter()
   endif

/* Taken out, interferes with some people's c_enter. */
;def c_enter=   /* I like Ctrl-Enter to finish the comment field also. */
;   getline line
;   if pos('/*',line) then
;      if not pos('*/',line) then
;         end_line;keyin' */'
;      endif
;   endif
;   down;begin_line

def c_x=       /* Force expansion if we don't have it turned on automatic */
   if not e_first_expansion() then
      call e_second_expansion()
   endif

defproc e_first_expansion
   /*  up;down */
   retc=1
   if .line and (not pcommand_state()) then
      getline line
      line=strip(line,'T')
      w=line
      word=upcase(w)
      if word='FOR' then
         replaceline w' =  to'
         insertline substr(word,1,length(word)-3)'endfor',.line+1
         if not insert_state() then insert_toggle endif
         keyin ' '
      elseif word='IF' then
         replaceline w' then'
         insertline substr(word,1,length(word)-2)'else',.line+1
         insertline substr(word,1,length(word)-2)'endif',.line+2
         if not insert_state() then insert_toggle endif
         keyin ' '
      elseif word='ELSEIF' then
         replaceline w' then'
         if not insert_state() then insert_toggle endif
         keyin ' '
      elseif word='WHILE' then
         replaceline w' do'
         insertline substr(word,1,length(word)-5)'endwhile',.line+1
         if not insert_state() then insert_toggle endif
         keyin ' '
      elseif word='LOOP' then
         replaceline w
         insertline substr(word,1,length(word)-4)'endloop',.line+1
         call einsert_line();right;right
      else
         retc=0
      endif
   else
      retc=0
   endif
   return retc

defproc e_second_expansion
   retc=1
   if .line then
      getline line
      parse value line with word rest
      firstword=upcase(word)
      if firstword='FOR' then
         /* do tabs to fields of pascal for statement */
         parse value upcase(line) with a '='
         if length(a)>=.col then
            .col=length(a)+3
         else
            parse value upcase(line) with a 'TO'
            if length(a)>=.col then
               .col=length(a)+4
            else
               call einsert_line()
               .col=.col+E_SYNTAX_INDENT
            endif
         endif
      elseif firstword='IF' or firstword='ELSEIF' or firstword='WHILE' or firstword='LOOP' or firstword='ELSE' then
         call einsert_line()
         .col=.col+E_SYNTAX_INDENT
         if firstword='LOOP' then
            line=substr(line,1,.col-E_SYNTAX_INDENT-1)'endloop'
            insertline line,.line+1
         endif
      elseif pos('/*',line) then
;     elseif substr(firstword,1,2)='/*' then  /*see speed requirements */
         if not pos('*/',line) then
            end_line;keyin' */'
         endif
         call einsert_line()
      else
         retc=0
      endif
   else
      retc=0
   endif
   return retc

