/* Hex2Dec       Usage:  DecimalOut=Hex2Dec(HexStringIn)                   */
/*                       where HexStringIn may optionally begin with 'X'.  */
/*  If hex number is invalid, null string is returned.                     */
defproc hex2dec

   if arg(2)<>'' then base=arg(2) else base=16 endif
   hex=arg(1)
   if hex='' then
     return('')
   endif
   dec=0
   loop
      i=upcase(substr(hex,1,1))
      if i='' then leave endif
      if i<>'X' then                     /* Ignore initial X if any. */
         i=pos(i,'0123456789ABCDEF')
         if not i then
            return('')
         endif
         dec=dec*base -1 +i
      endif
      hex=substr(hex,2)
   endloop
   return(dec)

/* Dec2Hex       Usage:  HexStringOut=Dec2Hex(DecimalIn)          */
/*               Result will be a string be ginning with 'X'.      */
/*  If decimal number is invalid, null string is returned.        */
defproc dec2hex
   universal maxint

   if arg(2)<>'' then base=arg(2);output='o' else base=16;output='x' endif
   if base='' then base=16 endif
   dec=arg(1)
   if dec<0 then
     dec=dec+ maxint+1
   endif
   if not isnum(dec) then
      return('')
   endif
   hex=''
   while dec>0 do
      i=dec/base
      hex=substr('0123456789ABCDEF',dec-i*base+1,1)hex
      dec=i
   endwhile
   if arg(1)<0 then
     if base=8 then
       hex='1'hex
     else
       hex='F'substr(hex,2)
     endif
   endif
   return(output''hex)


defc matho=

      input=arg(1)
      if evalinput(result,input,'o') then
        call experror();stop
      else
        setcommand 'matho' input'= 'result
      endif
defc mathx=

      input=arg(1)
      if evalinput(result,input,'x') then
        call experror();stop
      else
        setcommand 'mathx' input'= 'result
      endif

defc math=

      input=arg(1)
      if evalinput(result,input,'') then
        call experror();stop
      else
        setcommand 'math' input'= 'result
      endif

defproc skip_spaces
  universal input,i

  j=verify(input,' ','',i)
  if j then
    i=j
  else
    i=length(input)+1
  endif



defproc experror
  sayerror  'Syntax error'

defproc lex_number
  universal input,i
  universal sym
  universal j

      if not j then j=length(input)+1 endif
      sym=substr(input,i+1,j-i-1)
      sym=hex2dec(sym,arg(1))
      if sym=='' then
        call experror();stop
      endif
      i=j

defproc next_sym
  universal sym
  universal input,i
  universal j

  call skip_spaces()
  if i>length(input) then sym='$';return('') endif
  sym=substr(input,i,1)
  if pos(sym,'Oo\xX0123456789+-/*()') then
    if isnum(sym) then
      j=verify(input,'0123456789','',i)
      if not j then j=length(input)+1 endif
      sym=substr(input,i,j-i)
      i=j
    elseif upcase(sym)='X' then
      j=verify(input,'0123456789ABCDEFabcdef','',i+1)
      call lex_number(16)
    elseif upcase(sym)='O' or sym='\' then
      j=verify(input,'01234567','',i+1)
      call lex_number(8)
    else
      i=i+1
    endif
  else
    call experror();stop
  endif

defproc unary_exp
  universal exp_stack
  universal sym

  if sym='(' then
    call next_sym()
    call exp()
    if sym<>')' then experror();stop endif
    call  next_sym()
  elseif isnum(sym) then
    exp_stack=sym exp_stack
    call next_sym()
  elseif sym='-' then
    call next_sym()
    call unary_exp()
    parse value exp_stack with e1 exp_stack
    exp_stack=-e1 exp_stack
  elseif sym='+' then
    call next_sym()
    call unary_exp()
  else
    call experror();stop
  endif

defproc reduce_dualop
  universal exp_stack

  parse value exp_stack with e2 e1 exp_stack
  if arg(1)='+' then
    exp_stack=e1+e2 exp_stack
  elseif arg(1)='-' then
    exp_stack=e1-e2 exp_stack
  elseif arg(1)='*' then
    exp_stack=e1*e2 exp_stack
  elseif arg(1)='/' then
    exp_stack=e1/e2 exp_stack
  endif

defproc prec
  return(pos(arg(1),'$+-*/'))

defproc exp
  universal sym

   op_stack='$'
   loop
      call unary_exp()
      /* look for dual operator */
      if not pos(sym,'+-*/') then
        if not isnum(sym) then
          leave
        endif
        oldsym=sym;
        sym='+'
      else
        oldsym=''
      endif
      while prec(substr(op_stack,length(op_stack)))>=prec(sym) do
        call reduce_dualop(substr(op_stack,length(op_stack)))
        op_stack=substr(op_stack,1,length(op_stack)-1)
      endwhile
      op_stack=op_stack''sym
      if oldsym='' then
        call next_sym()
      else
        sym=oldsym;
      endif
   endloop
   for j=length(op_stack) to 2 by -1
     call reduce_dualop(substr(op_stack,j,1))
   endfor
 /* returns 0 if expression evaluated successfully. */
 /* result is set to evaluation of expression when successfull */
 /* returns 1 if error.  No message displayed */
defproc evalinput(var result,var sourceline,output)
  universal i,input
  universal exp_stack
  universal sym

  exp_stack='';
  input=sourceline
  i=pos('=',input)
  if i then
    input=substr(input,1,i-1)
    sourceline=input
  endif
  i=1;call next_sym()
  call exp()
  if sym<>'$' then
    return(1)
  else
    result=exp_stack
    if output='x' then
      result=dec2hex(result)
    elseif output='o' then
      result=dec2hex(result,8)
    endif
    return(0)
  endif
