/*  Ctrl-G = Global-find key.    Standard E3 lets you press Ctrl-F to    */
/*  repeat-find in the current file.  Now Ctrl-G does the repeat-find    */
/*  on ALL the files in the ring.  Very useful when I'm editing several  */
/*  small program modules and I want to find where something's defined.  */
/*                                                                       */
/*  Installation:  Include this in your MYKEYS.E.  There's nothing       */
/*  special about the choice of key Ctrl-G, change the DEF if you like.  */
/*                                                                       */
/*  03/08/87:  Converted from old E2 proc by Bryan Lewis.                */
/*  06/19/87:  Made to work with messy-desk windowing by Jim Hurley.     */
/*  07/22/87:  Made to save cursor position if no match, by Jum Hurley.  */
DEF c_g=
   if pcommand_state() then command_toggle endif
   /* Remember our current file so we don't search forever.  */
   getfileid StartFileID
   /* First repeat-find in the current file in case we don't have to move.*/

   /* Note:  Jim Hurley prefers to say 'executekey c_f' here because he's */
   /* modified c_f to adjust cursor position.  Disadvantage of hardwiring */
   /* the key name is somebody might be using c_f for something else, in  */
   /* which case it would be better to say 'repeat_find'.  In distribution*/
   /* version of E3 they're the same.                                     */
   executekey c_f    /* or repeat_find */

   if rc=0 then stop endif
   fileid=StartFileID
   loop
      call pnextfile() /* Works with either messy-desk or tiled. */
      getfileid fileid
      activatefile fileid

      /* Include this refresh if you like to see each file as it's */
      /* searched.  Causes too much screen flashing for my taste,  */
      /* but I use tiled windowing. Makes more sense in messy-desk.*/
      if fileid.windowoverlap=1 then
         refresh
      endif

      /* Start from top of file, but save current posn in case no match. */
      call psave_pos(save_pos)
      top ; .col=1
      executekey c_f   /* or repeat_find */
      if rc=0 then
         if fileid=StartFileID then
            sayerror "String not found anywhere else"
         else
            sayerror 0
         endif
         leave
      else
         /* no match in file - restore file location */
         call prestore_pos(save_pos)
      endif
      if fileid=StartFileID then
         sayerror "String not found anywhere at all!"
         leave
      endif
   endloop
   activatefile fileid
   /* Optional resetting of state, depends on how much special setup you do */
   /* in select_edit_keys().  (Like different tabs for different filetypes.)*/
   /* call select_edit_keys() */
