; MATH.E      Combines old MATH.E and EXP.E.
;             Commands first, then procs, alphabetized.

defc add=
   call checkmark()
   call column_math('+')

defc math=
   call mathcommon(arg(1),'')

defc matho=
   call mathcommon(arg(1),'o')

defc mathx=
   call mathcommon(arg(1),'x')

defc mult=
   call checkmark()
   call column_math('*')

; Ver. 3.09:  Passes its argument along to EXP(), in order to fix bug where
; MULT command gave wrong results when numbers were marked horizontally.
defproc column_math
  getmark firstline,lastline,firstcol,lastcol,fileid
  if arg(1)='+' then
    result=0
  else
    result=1
  endif
  call pinit_extract()
  loop
    code = pextract_string(line)
    if code = 1 then leave endif
    if code = 0 then  /* ignore blank lines */
        if evalinput(tempresult,line,'',arg(1)) then
           call experror()
        else
          if arg(1)='+' then
            result=result+tempresult
          else
            result=result*tempresult
          endif
        endif
    endif
  endloop
  insertline substr('',1,firstcol-1)result,lastline+1,fileid


/* returns 0 if expression evaluated successfully. */
/* result is set to evaluation of expression when successful */
/* returns 1 if error.  No message displayed */
defproc evalinput(var result,var sourceline,output)
   universal i,input
   universal exp_stack
   universal sym

   exp_stack=''
   i=pos('=',sourceline)
   if i then
      sourceline=substr(sourceline,1,i-1)
   endif
   input=sourceline
   i=1;call next_sym()
   call exp(arg(4))  -- Ver. 3.09 - accept & pass to exp an optional 4th argument
   if sym<>'$' then
      return 1
   else
      result=exp_stack
      if output='x' then
         result=dec2hex(result)
      elseif output='o' then
         result=dec2hex(result,8)
      endif
      return 0
   endif


;  Ver. 3.09:  EXP takes an optional argument saying what the default operator
;  should be.  (I.e., what operator should be assumed if 2 numbers appear one
;  after the other).  If not given, error.  ('+' was assumed previously.)
defproc exp
   universal sym
   op_stack='$'
   loop
      call unary_exp(arg(1))   -- 3.09:  Pass to unary_exp, because it calls us.
      /* look for dual operator */
      if not pos(sym,'+-*%/') then
         if not isnum(sym) & sym<>'(' then  -- '(' OK for column math.
            leave
         endif
         oldsym=sym
         if arg(1) then sym=arg(1); else call experror(); stop; endif
      else
         oldsym=''
      endif
      while prec(substr(op_stack,length(op_stack)))>=prec(sym) do
         call reduce_dualop(substr(op_stack,length(op_stack)))
         op_stack=substr(op_stack,1,length(op_stack)-1)
      endwhile
      op_stack=op_stack||sym
      if oldsym='' then
         call next_sym()
      else
         sym=oldsym
      endif
   endloop
   for j=length(op_stack) to 2 by -1
      call reduce_dualop(substr(op_stack,j,1))
   endfor


defproc experror
   sayerror 'Syntax error'


/* Dec2Hex       Usage:  HexStringOut=Dec2Hex(DecimalIn)          */
/*               Result will be a string beginning with 'X'.      */
/*  If decimal number is invalid, null string is returned.        */
defproc dec2hex
   universal maxint

   if arg(2)<>'' then base=arg(2);output='o' else base=16;output='x' endif
   if base='' then base=16 endif
   dec=arg(1)
   if dec<0 then
      dec=dec+ maxint+1
   endif
   if not isnum(dec) then
      return ''
   endif
   vhex=''
   while dec>0 do
      i=dec/base
      vhex=substr('0123456789ABCDEF',dec-i*base+1,1)vhex
      dec=i
   endwhile
   if vhex='' then
      vhex='0'
   endif
   if arg(1)<0 then
      if base=8 then
         vhex='1'vhex
      else
         vhex='F'substr(vhex,2)
      endif
   endif
   return output||vhex


/* Hex2Dec       Usage:  DecimalOut=Hex2Dec(HexStringIn)                   */
/*                       where HexStringIn may optionally begin with 'X'.  */
/*  If hex number is invalid, null string is returned.                     */
defproc hex2dec
   if arg(2)<>'' then base=arg(2) else base=16 endif
   vhex=arg(1)
   if vhex='' then
      return ''
   endif
   dec=0
   loop
      i=upcase(substr(vhex,1,1))
      if i='' then leave endif
      if i<>'X' then                     /* Ignore initial X if any. */
         i=pos(i,'0123456789ABCDEF')
         if not i then
            return ''
         endif
         dec=dec*base -1 +i
      endif
      vhex=substr(vhex,2)
   endloop
   return dec

defproc lex_number
   universal input,i
   universal sym
   universal j

   if not j then j=length(input)+1 endif
   sym=substr(input,i+1,j-i-1)
   sym=hex2dec(sym,arg(1))
   if sym=='' then
      call experror();stop
   endif
   i=j

defproc mathcommon(input,suffix)
   if evalinput(result,input,suffix) then
      call experror();stop
   else
      setcommand 'math'suffix input'= 'result
   endif

defproc next_sym
   universal sym
   universal input,i
   universal j

   call skip_spaces()
   if i>length(input) then sym='$';return '' endif
   sym=substr(input,i,1)
   if pos(sym,'Oo\xX0123456789+-/%*()') then
      if isnum(sym) then
         j=verify(input,'0123456789','',i)
         if not j then j=length(input)+1 endif
         sym=substr(input,i,j-i)
         i=j
      elseif upcase(sym)='X' then
         j=verify(input,'0123456789ABCDEFabcdef','',i+1)
         call lex_number(16)
      elseif upcase(sym)='O' or sym='\' then
         j=verify(input,'01234567','',i+1)
         call lex_number(8)
      else
         i=i+1
      endif
   else
      call experror();stop
   endif

defproc prec
   /* Group operators in 3's so +- and *%/ have same precedence. */
   return pos(arg(1),'$ +- *%/')/3+1

defproc reduce_dualop
   universal exp_stack
   parse value exp_stack with e2 e1 exp_stack
   if arg(1)='+' then
      exp_stack=e1+e2 exp_stack
   elseif arg(1)='-' then
      exp_stack=e1-e2 exp_stack
   elseif arg(1)='*' then
      exp_stack=e1*e2 exp_stack
   elseif arg(1)='/' then
      exp_stack=e1/e2 exp_stack
/*   elseif arg(1)='%' then
      exp_stack=e1%e2 exp_stack */
   endif

defproc skip_spaces
   universal input,i
   j=verify(input,' ','',i)
   if j then
      i=j
   else
      i=length(input)+1
   endif

defproc unary_exp
   universal exp_stack
   universal sym

   if sym='(' then
      call next_sym()
      call exp(arg(1))
      if sym<>')' then experror();stop endif
      call  next_sym()
   elseif isnum(sym) then
      exp_stack=sym exp_stack
      call next_sym()
   elseif sym='-' then
      call next_sym()
      call unary_exp(arg(1))
      parse value exp_stack with e1 exp_stack
      exp_stack=-e1 exp_stack
   elseif sym='+' then
      call next_sym()
      call unary_exp()
   else
      call experror();stop
   endif

