/*                    PASCAL keys                       */
/*                                                      */
/*  The enter and space bar keys have been defined to do*/
/* specific pascal editing features.                    */

defkeys pas_keys

def ' '=
  universal expand_on

        if expand_on then
           if  pas_first_expansion()=0 then
             keyin ' '
           endif
         else
           keyin ' '
         endif

def enter=
  universal expand_on

  if pcommand_state() then
    execute
  else
    call maybe_autosave()
    if expand_on then
      if pas_second_expansion()=0 then
        call einsert_line()
      endif
    else
      call einsert_line()
    endif
  endif
def c_x=  if pas_first_expansion()=0 then
           call pas_second_expansion()
         endif

defproc pas_first_expansion
   retc=1
   if .line>0 and (not pcommand_state()) then
     getline line
     line=strip(line,'T')
     parse value line with w     /* remove leading spaces */
     word=upcase(w)
     getfileid fileid
     if word='FOR' then
       replaceline w' :=  to  do begin'
       insertline substr(word,1,length(word)-3)'end; {endfor}',fileid.line+1
       if not insert_state() then insert_toggle endif
       keyin ' '
     elseif word='IF' then
       replaceline w' then begin'
       insertline substr(word,1,length(word)-2)'end else begin',fileid.line+1
       insertline substr(word,1,length(word)-2)'end; {endif}',fileid.line+2
       if not insert_state() then insert_toggle endif
       keyin ' '
    elseif word='WHILE' then
       replaceline w' do begin'
       insertline substr(word,1,length(word)-5)'end; {endwhile}',fileid.line+1
       if not insert_state() then insert_toggle endif
       keyin ' '
     elseif word='REPEAT' then
       replaceline w
       insertline substr(word,1,length(word)-6)'until  ; {endrepeat}',fileid.line+1
       key enter
     elseif word='CASE' then
       replaceline w' of'
       insertline substr(word,1,length(word)-4)'end; {endcase}',fileid.line+1
       if not insert_state() then insert_toggle endif
       keyin ' '
     else
       retc=0
     endif
   else
     retc=0
   endif
   return(retc)

defproc pas_second_expansion
    retc=1
    getfileid fileid
    if fileid.line>0 then
      getline line
      parse value upcase(line) with 'BEGIN' +0 a /* get stuf after begin */
      parse value line with word rest
      firstword=upcase(word)
      if firstword='FOR' then
        /* do tabs to fields of pascal for statement */
        parse value upcase(line) with a ':='
        if length(a)>=fileid.col then
            fileid.col=length(a)+4
        else
          parse value upcase(line) with a 'TO'
          if length(a)>=fileid.col then
            fileid.col=length(a)+4
          else
            call einsert_line()
            fileid.col=fileid.col+P_SYNTAX_INDENT
          endif
        endif
      elseif a='BEGIN' or firstword='BEGIN' or firstword='CASE' or firstword='REPEAT' then  /* firstword or last word begin?*/
        if firstword='BEGIN' then
          replaceline  word rest
          call einsert_line();fileid.col=P_SYNTAX_INDENT+1
        else
          call einsert_line()
          fileid.col=fileid.col+P_SYNTAX_INDENT
        endif
      elseif firstword='VAR' or firstword='CONST' or firstword='TYPE' or firstword='LABEL' then
        if substr(line,1,2)<>'  ' or substr(line,1,3)='   ' then
          getline line2
          replaceline  '  'word rest
          call einsert_line();fileid.col=fileid.col+P_SYNTAX_INDENT
        else
          call einsert_line()
        endif
      elseif firstword='PROGRAM' then
        /* make up a nice program block */
        parse value rest with name ';'
        getline bottomline,fileid.last,fileid
        parse value bottomline with lastname .
        if  lastname = 'end.' then
          retc= 0     /* no expansion */
        else
          replaceline  word rest
          call einsert_line()
          insertline 'begin {' name '}',fileid.last+1
          insertline 'end. {' name '}',fileid.last+1
        endif
      elseif firstword='PROCEDURE' then
        /* make up a nice program block */
        name= getheading_name(rest)
        replaceline  word rest
        call einsert_line()
        insertline 'begin {' name '}',fileid.line+1
        insertline 'end; {' name '}',fileid.line+2
      elseif firstword='FUNCTION' then
        /* make up a nice program block */
        name=getheading_name(rest)
        replaceline  word rest
        call einsert_line()
        insertline 'begin {' name '}',fileid.line+1
        insertline 'end; {' name '}',fileid.line+2
      elseif pos('{',line)<>0 then
;      elseif substr(firstword,1,2)='{' then   /* see speed requirements */
        if pos('}',line)=0 then
          end_line;keyin' }'
        endif
        call einsert_line()
      else
        retc=0
      endif
    else
      retc=0
    endif
    return(retc)

defproc getheading_name          /*  (heading ) name of heading */
  name=''
  for i=1 to length(arg(1))
    if isid(substr(arg(1),i,1)) then name= name||substr(arg(1),i,1)
    else leave
    endif
  endfor
  return(name)

defproc isid
  ch=upcase(arg(1))
  if ch>='A' and ch<='Z' then
    return(1)
  elseif ch>='0' and ch<='9' then
    return(1)
  elseif ch='_' then
    return(1)
  endif
  return(0)

