/****************************************/
/*   procedures for host file support   */
/*                                      */
/****************************************/

const
   HOSTDRIVE= 'H:'         /* Dummy drive letter to stand for Host files.   */
                           /* Make sure the drive letter is in upper case.  */


defproc loadfile(files,options)
   universal hostfileid

   if check_for_host_file(files) then
      /* check if file is already in ring */
      rc=0
      'xcom e 'options '/n' TEMP_PATH'eeeeeeee.eee'
      if rc then
         getfileid hostfileid
         'xcom q'
         call load_host_file(options)
         if rc then
            activatefile hostfileid     /* make hidden ring active if hidden */
         endif                          /* option was used */
      endif
   else
      'xcom e 'options files
   endif

defproc savefile(name)
   options=arg(2)
   if check_for_printer(name) then
      if not printer_ready() then
         call messageNwait("Printer not ready.  Type any key...")
         return 1
      endif
   elseif check_for_host_file(name) then
      call save_host_file(name)
      .modify=0
      return 0      /* Return 0, some terminal emulators do not give us */
   endif            /* meaningful error codes.                          */
   'xcom s 'options name
   if not rc and name=.filename then
      .modify=0
   endif
   return rc

defproc namefile()
   universal hostfileid,hostfilespec,hname,htype,hmode
   newname=arg(1)
   if check_for_host_file(newname) then
      .filename=HOSTDRIVE||hostfilespec
   elseif parse_filename(newname,.filename) then
      sayerror 'Invalid filename.'
   else
      'xcom n 'newname
   endif

defproc quitfile()
   universal hostfileid,hostfilespec,hname,htype,hmode
   universal autosave

   if .windowoverlap then
      modify=(.modify and .views=1)
   else
      modify=.modify
   endif
   k='Y'
   if modify then
compile if SMARTQUIT
      call message('Throw away changes?  Press Y, N or File key')
compile else
      call message('Throw away changes? Press Y or N')
compile endif
      loop
         k=upcase(getkey())
compile if SMARTQUIT
         if k=FILEKEY then 'File'; return 1               endif
compile endif
         if k='Y' or k='N' then leave                     endif
         if k=esc          then call message(1); return 1 endif
      endloop
      call message(1)
   endif
   if k='Y' then
      if not .windowoverlap or .views=1 then
         .modify=0
      endif
   else
      return 1
   endif
   if autosave>0 then               -- Erase the tempfile if autosave is on.
      call erasetemp(MakeTempName())
   endif
   name=.filename
   if .windowoverlap then
      quitview
   else
      'xcom q'
   endif
;; call select_edit_keys()      -- This is done by DEFC Q.
;; .box=2                       --  "


/* warning this procedure may sayerror Invalid host filename and stop */
defproc check_for_host_file
   universal hostfileid,hostfilespec,hname,htype,hmode

   hostfilespec=upcase(strip(arg(1)))
   i=pos(HOSTDRIVE,hostfilespec)
   if i<>1 then return 0 endif  -- Ver. 3.09  Don't accept garbage before H:
   hostfilespec=substr(hostfilespec,i+length(HOSTDRIVE))
   parse value hostfilespec with hname htype hmode
   if hmode='' then hmode='A';hostfilespec=hostfilespec hmode endif
   if htype='' or length(hmode)>2 then sayerror 'Invalid filename';stop endif
   if verify(hostfilespec,':;+?*\/|><.,','M') then
      sayerror 'Characters in filename not supported'
      stop
   endif
   hostfilespec=hname htype hmode   /* remove extra spaces */
   return 1

defproc load_host_file(options)
   universal hostfileid,hostfilespec,hname,htype,hmode
   universal hostcopy

   call message('Loading 'HOSTDRIVE||hostfilespec)
   line=hostcopy hostdrive||hname htype hmode TEMP_PATH'eeeeeeee.'hostfileid
   quiet_shell line
   if rc then /* assume host file not found */
      'xcom e 'options '/n .newfile'
      call message('Assuming host file not found')
      rc=sayerror('New file')
   else
      'xcom e 'options TEMP_PATH'eeeeeeee.'hostfileid
      if rc then
         call message(rc)
         return ''
      else
         call message(1)
      endif
   endif
   call erasetemp(TEMP_PATH'eeeeeeee.'hostfileid)
   .filename=HOSTDRIVE||hostfilespec

; Note:  Save_host_file ignores its arguments.
defproc save_host_file
   universal hostfileid,hostfilespec,hname,htype,hmode
   universal hostcopy

   getfileid hostfileid
   'xcom save' TEMP_PATH'eeeeeeee.'hostfileid
   if rc then stop endif
   call message('Saving 'HOSTDRIVE||hostfilespec)
   /* is this a binary file ? */
   if length(htype)>=3 then
      if upcase(substr(htype,length(htype)-2))=='BIN' then
         hostfilespec=hostfilespec '/b'
      endif
   endif
   quiet_shell hostcopy TEMP_PATH'eeeeeeee.'hostfileid' 'hostdrive||hostfilespec
   if rc then
      call host_error(rc)
   else
      hostfileid.modify=0
      call erasetemp(TEMP_PATH'eeeeeeee.'hostfileid)
      call message(1)
   endif

defproc host_error
   universal hostfileid,hostfilespec,hname,htype,hmode
;  rc=arg(1)
   sayerror 'Host error; host save cancelled.  File saved in' TEMP_PATH'eeeeeeee.'hostfileid
   stop

defproc filetype()        -- Ver. 3.09 - split out from Select.E
   universal htype
   fileid=arg(1)
   if fileid='' then fileid=.filename  endif
   fileid=upcase(fileid)
   if check_for_host_file(fileid) then
      return htype
   else
      i=lastpos('.',fileid)
      if i then
         return substr(fileid,i+1)
      endif
   endif
;  return ''       -- added by ET; no need to duplicate.

defproc vmfile(var name, var cmdline)

  parse value name with fn ft fm cmdline

  if upcase(substr(fn,1,length(HOSTDRIVE)))<>HOSTDRIVE or pos('\',fn) or
     pos('.',fn) or length(ft)>8 or pos(':',ft) or
     pos('\',ft) or pos('.',ft) then
    return (0)
  endif

  if fm='' or length(fm)>2 or verify(substr(fm,2,1),'1234567890 ') or
     pos(':',fm) or pos('\',fm) or pos('.',fm) then
    cmdline = fm cmdline
    name = fn ft
    return (1)
  endif

  name = fn ft fm
  return (1)                             --better be VM at this point
