/****************************************/
/*            SLNoHost.E                */
/*  procedures for file saving/loading  */
/*                                      */
/*              WITHOUT                 */
/*         host file support            */
/*         (saves about 1K)             */
/****************************************/

defproc loadfile(files,options)
   'xcom e 'options files

defproc savefile(name)
   options=arg(2)
   if check_for_printer(name) then
      if not printer_ready() then
         call messageNwait("Printer not ready.  Type any key...")
         return 1
      endif
   endif
   'xcom s 'options name
   if not rc and name=.filename then
      .modify=0
   endif
   return rc

defproc namefile()
   newname=arg(1)
   if parse_filename(newname,.filename) then
      sayerror 'Invalid filename.'
   else
      'xcom n 'newname
   endif

defproc quitfile()
   universal autosave
   if .windowoverlap then
      modify=(.modify and .views=1)
   else
      modify=.modify
   endif
   k='Y'
   if modify then
compile if SMARTQUIT
      call message('Throw away changes?  Press Y, N or File key')
compile else
      call message('Throw away changes? Press Y or N')
compile endif
      loop
         k=upcase(getkey())
compile if SMARTQUIT
         if k=FILEKEY then 'File'; return 1               endif
compile endif
         if k='Y' or k='N' then leave                     endif
         if k=esc          then call message(1); return 1 endif
      endloop
      call message(1)
   endif
   if k='Y' then
     if not .windowoverlap or .views=1 then
       .modify=0
     endif
   else
     return 1
   endif
   if autosave>0 then               -- Erase the tempfile if autosave is on.
      call erasetemp(MakeTempName())
   endif
   name=.filename
   if .windowoverlap then
      quitview
   else
      'xcom q'
   endif
;; call select_edit_keys()     -- This is done by DEFC Q.
;; .box=2                       --  "

defproc filetype()        -- Ver. 3.09 - split out from Select.E
   fileid=arg(1)
   if fileid='' then fileid=.filename  endif
   fileid=upcase(fileid)
   i=lastpos('.',fileid)
   if i then
      return substr(fileid,i+1)
   endif
;  return ''       -- added by ET; no need to duplicate.
