definit
   universal blockreflowflag,normal_exit,lines_entered,inKstring
   blockreflowflag=0
   normal_exit=1
   lines_entered=0
   inKstring=0

defkeys edit_keys new
def entry=

; Real keys, in alphabetical order.
; See end of this file for a list of keys unused in standard E.

def a_0=    /* same as Alt-Equal, for sake of German keyboards */
   'dolines'

def a_1= /* edit filename on current text line */
   getline line
   'e 'line

def a_4=call psplit4()
def a_a=adjustblock
def a_b=markblock
def a_c=
   call pcopy_mark(destfirstline,destlastline,destfirstcol,destlastcol)

def a_d=call pdelete_mark(p1,p2,p3,p4)
def a_e= call pend_mark()
def a_f=call pfill_mark()

def a_f1= keyin '                         '

def a_f10=call pprevfile()

def a_j=
  if .line<.last and .line>0 then
    /* remove all but one trailing space of current line */
    getline line
    for i=length(line) to 1 by -1
      if substr(line,i,1)<>' ' then
	leave
      endif
    endfor
    replaceline substr(line,1,i+1)
    .line=.line+1
    /* remove all leading spaces of current line */
    getline line
    i=verify(line,' ');
    if i=0 then replaceline ''
    else replaceline substr(line,i)
    endif
    .line=.line-1;join
  endif

def a_l=mark_line
def a_m=call pmove_mark()
def a_n=
  keyin .filename

def a_o=overlay_block

def a_p=
   /* Protect the user from accidentally reflowing a marked  */
   /* area not in the current file, and give a good message. */
   mt = marktype()
   if mt='BLOCK' or mt='LINE' then
      getmark firstline,lastline,firstcol,lastcol,markfileid
      getfileid fileid
      if fileid<>markfileid then
	 sayerror "Can't reflow!  You have a marked area in another file."
	 return
      endif
   endif

   if mt then
      if not check_mark_on_screen() then
	 do while testkey()/==''; call getkey(); end
	 sayerror "You have a marked area off screen.  Continue?  (Y/N)"
	 loop
	    ch=upcase(getkey())
	    if ch='Y' then sayerror 0; leave; endif
	    if ch='N' or ch=esc then sayerror 0; stop; endif
	 endloop
      endif
   endif

   if mt='BLOCK' then
      'box r'
   elseif mt='CHAR' then
      sayerror 'Line or block mark required'
   elseif mt='LINE' then
      reflow
   elseif .line then
      getline line
      if line<>'' then  -- If currently on a blank line, don't reflow.
	 oldcursory=.cursory;oldcursorx=.cursorx; oldline=.line;oldcol=.col;
	 unmark;mark_line
	 call pfind_blank_line()
	 getline line
	 -- Ver 3.11:  slightly revised test works better with GML sensitivity.
	 if .line<>oldline then up else .line=.last endif
	 mark_line
	 reflow

	compile if REFLOW_LIKE_PE   /* position on next paragraph (like PE) */
	 down                       /* Thanks to Doug Short. */
	 for i=.line+1 to .last
	    getline line,i
	    if line<>'' then
	       .line=i
	       leave
	    endif
	 endfor
	compile else
	 /* or like old E */
	 getmark firstline,lastline
	 .line=firstline
	 .cursory=oldcursory;.cursorx=oldcursorx; .line=oldline;.col=oldcol;
	compile endif
	 unmark
      endif
   endif


def a_r=
  universal normal_exit,tempofid

  if normal_exit = 0 then
    /* release tempo */
    activatefile tempofid
    .modify=0
    'xcom q'
  endif
  if pblock_reflow(0,space,tempofid) then stop endif
  normal_exit = 0
; if marktype() <> 'BLOCK' then
    unmark
; endif
  sayerror 'Use Alt-B to select the destination block, then press Alt-R (Esc to abort)'
  loop
    k=getkey()
    if k==a_r then  /* Alt-R ? */
      call pblock_reflow(1,space,tempofid)
      leave
    elseif k==esc then  /* Esc ? */
      /* release tempo */
      activatefile tempofid
      .modify=0
      'xcom q'
      unmark
      sayerror 'Block mark not reflowed'
      leave
    endif
    executekey k
  endloop
  normal_exit = 1

def a_s=
  if .line>0 then
    split
    oldcol=.col
    call pfirst_nonblank()
    getline line,.line+1
    i=verify(line,' ');
    if i<>0 then line=substr(line,i) endif   /* remove leading spaces */
    replaceline substr('',1,.col-1)||line,.line+1  /* indent like previous line*/
    .col=oldcol
  endif


def a_t = call pcenter_mark()
def a_u=unmark
def a_w = call pmark_word()
def a_x=escape
def a_y= call pbegin_mark()
def a_z=mark_char

def a_1=
  /* edit filename on current text line */
  getline line
  'e 'line

def a_f7=shift_left
def a_f8=shift_right
def a_f10=
  prevfile
  call select_edit_keys()
def a_equal=
  rc=0
  found_error=0
  if marktype()='LINE' then
    sayerror 'Execute all marked lines Y/N ?'
    loop
      k=upcase(getkey())
      if k=esc then stop endif
      if k='N' or k='Y' then leave endif
    endloop
    if k='Y' then
      getmark firstline,lastline,i,i,fileid
      for i=firstline to lastline
	getline line,i,fileid
	line
	if rc then found_error=1 endif
      endfor
      if not found_error then sayerror 'Commands executed without error' endif
      sayerror 0
      return
    endif
    sayerror 0
  endif
  getline line
  line

def backspace=rubout

def c_a =call pnextwindowstyle()
def c_backspace=
  delete_line
  if pcommand_state() then
    begin_line
  endif

def c_c= right
; Ctrl-D = word delete, thanks to Bill Brantley.
def c_d =  /* delete from cursor until beginning of next word, UNDOable */
   if pcommand_state() then
      getcommand cmdline, begcur, cmdscrPos
      lenCmdLine=length(cmdline)
      if lenCmdLine >= begcur then
	 for i = begcur to lenCmdLine /* delete remainder of word */
	    if substr(cmdline,i,1)<>' ' then
	       deleteChar
	    else
	       leave
	    endif
	 endfor
	 for j = i to lenCmdLine /* delete delimiters following word */
	    if substr(cmdline,j,1)==' ' then
	       deleteChar
	    else
	       leave
	    endif
	 endfor
      endif
   else
      getline line
      begcur=.col
      lenLine=length(line)
      if lenLine >= begcur then
	 for i = begcur to lenLine /* delete remainder of word */
	    if substr(Line,i,1)<>' ' then
	       deleteChar
	    else
	       leave
	    endif
	 endfor
	 for j = i to lenLine /* delete delimiters following word */
	    if substr(Line,j,1)==' ' then
	       deleteChar
	    else
	       leave
	    endif
	 endfor
      endif
   endif


def c_e=erase_end_line
def c_end=
    if .line=.last and .line then
      getline line
      .col=length(line)+1
    endif
    bottom

def c_enter=
   my_c_enter()

def c_f=repeat_find       /* find next */


def c_f1=
  call init_operation_on_commandline()
  call psave_mark(save_mark)
  call pmark_word()
  call puppercase()
  call prestore_mark(save_mark)
  call move_results_to_commandline()

def c_f2=
  call init_operation_on_commandline()
  call psave_mark(save_mark)
  call pmark_word()
  call plowercase()
  call prestore_mark(save_mark)
  call move_results_to_commandline()

def c_f3= call puppercase()

def c_f4= call plowercase()

def c_f5= call pbegin_word()

def c_f6= call pend_word()

def c_h=call psplith()
def c_home=
    if .line=1 then .col=1 endif
    top
def c_l = getline line
	 if not pcommand_state() then
	   cursor_command
	   begin_line;erase_end_line
	 endif
	 keyin line
def c_left=
  call init_operation_on_commandline()
  backtab_word
  call move_results_to_commandline()
def c_pgup=  .cursory=1
def c_pgdn=  .cursory=windowheight()
def c_right=
  call init_operation_on_commandline()
  tab_word
  call move_results_to_commandline()

/************************************************************/
/* Create a string of keys in Kstring variable.             */
/* All control keys have the same character (X'00') as the  */
/* first character of a two-character string.               */
/*                                                          */
/* The number of keys that may be stored is given by:       */
/*           256 > n + 2*e                                  */
/* where:                                                   */
/*       n are normal data keys (one byte from BIOS)        */
/*       e are extended code keys (two bytes from BIOS)     */
/************************************************************/
def c_r=
   universal Kstring,Kins_state,Kcom_state,inKstring

   inKstring=-1      /* Set recording flag; see defproc mgetkey(). */
   /* jbl 6/21/89:  can't use Ctrl-C on RT... use Ctrl-G a la emacs. */
   sayerror 'Remembering keys.  Ctrl-R to finish, Ctrl-T to finish and try, Ctrl-G to cancel.'
   oldKins_state=Kins_state
   oldKstring   =Kstring
   oldKcom_state=Kcom_state
   Kins_state   =insert_state()
   Kstring      =''
   Kcom_state   =pcommand_state()
   Kct=0
   loop
      k=getkey()
      if k==c_r then  /* Ctrl-R ? */
	 sayerror 'Remembered.  Press Ctrl-T to execute.'
	 leave
      endif
      if k==c_t then  /* Ctrl-T ? */
	 leave
      endif
      if k==c_g then  /* cancel? */
	 Kstring   =oldKstring
	 Kins_state=oldKins_state
	 Kcom_state=oldKcom_state
	 sayerror 'Cancelled.  Previous key macro not replaced.'
	 leave
      endif
      Kstring=Kstring||k
      Kct=length(Kstring)
      executekey k         /* execute AFTER adding to string */
      if Kct > 255 then
	 sayerror 'String too long!  Please press Ctrl-C to cancel.'
	 Kstring=oldKstring
	 Kins_state=oldKins_state
	 Kcom_state=oldKcom_state
	 loop
	    k=getkey()
	    if k==esc or k==c_g then leave endif   /* accept either */
	 endloop
	 sayerror 'Previous key macro not replaced'
	 leave
      endif
   endloop
   inKstring=0       /* lower state flag */
   if k==c_t then    /* Was it Ctrl-T? */
      sayerror 0     /* refresh the function keys */
      executekey k
   endif

def c_right=
   call init_operation_on_commandline()
   tab_word
   call move_results_to_commandline()


/************************************************************/
/* Execute the string of keys in Kstring variable.          */
/* All control keys have the same character (X'00') as the  */
/* first character of a two-character string                */
/*                                                          */
/* The number of keys that may be stored is given by:       */
/*           256 > n + 2*e                                  */
/* where:                                                   */
/*       n are normal data keys (one byte from BIOS)        */
/*       c are extended code keys (two bytes from BIOS)     */
/************************************************************/
def c_t=
   universal Kstring,Kins_state,Kcom_state,inKstring

   if Kstring=='' then
      sayerror 'Nothing remembered'        /* HurleyJ */
      return
   endif   /* Has a string been recorded? */
   if Kins_state/==insert_state()   then  insert_toggle endif
   if Kcom_state/==pcommand_state() then command_toggle endif

   inKstring=1    /* Set replaying flag; see defproc mgetkey(). */
   loop
      k=substr(Kstring,inKstring,1)
      ksize=1
      if k==substr(esc,1,1) then       /* extended key ? */
	 k=substr(Kstring,inKstring,2) /* Yes, 2 bytes for extended key. */
	 ksize=2
      endif
      inKstring=inKstring+ksize        /* bump index AFTER execution */
      executekey k
      if inKstring > length(Kstring) then leave endif
   endloop
   inKstring=0

;;def c_v=call psplitv()
def c_w = call pnextwindow()
def c_z= call pzoom()

def del=delete_char
def down=down
def end=end_line

def enter=
   call my_enter()

def esc=command_toggle

def f1='Help'
def f2='Save'
def f3=  'q'
def f4='File'
def f5=
def f6=
def f7=cursor_command;delete_line;begin_line;keyin 'Name '
def f8=cursor_command;delete_line;begin_line;keyin 'Edit '
def f9=undo
def f10= call pnextfile()

def home =begin_line
def ins=insert_toggle

def left=left

def padminus=keyin '-'
def padplus=keyin '+'
def padstar=keyin '*'
def pgup=page_up
def pgdn=page_down

def right=
  right

def tab=
  universal matchtab_on

  call init_operation_on_commandline()
  if matchtab_on then
    if pcommand_state() or .line<=1 then
      right;right;right
    else
      up
      c=.col
      tab_word; /* call pbegin_word() */
      if c>=.col then
	.col=c+3;
      endif
      down
    endif
  else
    tab
  endif
  call move_results_to_commandline()

def up=up


def s_f1= /* scroll left */
  oldcursorx=.cursorx;
  if .col-.cursorx>0 then
    .col=.col-.cursorx
    .cursorx=oldcursorx
  else
    if .cursorx>1 then .cursorx=.cursorx-1 endif
  endif
def s_f2= /* scroll right */
  oldcursorx=.cursorx;
  a=.col+windowwidth()-.cursorx+1
  if a<=255 then
    .col=a
    .cursorx=oldcursorx
  else
    if .col<255 then .cursorx=.cursorx+1 endif
  endif
def s_f3= /* scroll down */
  oldcursory=.cursory;
  if .line-.cursory>-1 then
    .cursory=1
    .line=.line-1
    .cursory=oldcursory
  else
    if .line>0 then .line=.line-1 endif
  endif
def s_f4= /* scroll up */
  oldcursory=.cursory;
  if .line -.cursory+windowheight()<.last then
    .cursory=windowheight()
    .line=.line+1
    .cursory=oldcursory
  else
    if .line<.last then .line=.line+1 endif
  endif

def  s_f5= /* center current line */
  oldline=.line
  .cursory=windowheight()/2
  .line=oldline


def s_tab=
  universal matchtab_on
  call init_operation_on_commandline()
  if matchtab_on then
    if pcommand_state() or .line<=1 then
      left;left;left
    else
      up
      backtab_word
      down
    endif
  else
    backtab
  endif
  call move_results_to_commandline()

