; A useful subroutine:  asks "Are you sure (Y/N)?" (same as DOS's prompt
; after "erase *.*") and returns uppercase keystroke.
; If called with a string parameter, displays it at start of prompt, e.g.
;   usersays = askyesno("About to erase.")
;   ==>   "About to erase. Are you sure (Y/N)? "
defproc askyesno
   prompt='Are you sure (Y/N)? '
   if arg(1)<>'' then
      prompt=arg(1)' 'prompt
   endif
   return upcase(mgetkey(prompt))     /* Accept key from macro. */

defproc checkmark()        /* Common routine, save space.  from Jim Hurley.*/
  if marktype()='' then
    sayerror 'No marked area'
    stop
  endif

; Ver. 3.09:  Routine to tell if a mark is visible on the screen.  (Actually,
; only on the current window; if the window is less than full size, a mark
; could be visible in an inactive window without our being able to tell.)
; Also, if a character mark begins above the top of the window and ends below
; the bottom, and the window contains only blank lines, then this routine will
; return 1 (since the mark spans the window) even though no sign of the mark
; will be visible.
defproc check_mark_on_screen =
   if marktype() = '' then return 0; endif  -- If no mark, then not on screen.
   getmark first_mark_line, last_mark_line, first_mark_col, last_mark_col
   first_screen_line = .line - .cursory + 1
   last_screen_line = .line - .cursory + .windowheight
   if last_mark_line < first_screen_line then return 0; endif
   if first_mark_line > last_screen_line then return 0; endif
   no_char_overlap = marktype()<>'CHAR' or first_mark_line=last_mark_line
   if last_mark_col < .col - .cursorx + 1 and
      (no_char_overlap or last_mark_line=first_screen_line)
   then return 0; endif
   if first_mark_col > .col - .cursorx + .windowwidth and
      (no_char_overlap or first_mark_line=last_screen_line)
   then return 0; endif
   return 1

; Tests whether the "filename" is actually a printer
; device, so we'll know whether to test printer readiness first.
; Called by savefile() in SAVELOAD.E.
defproc check_for_printer(name)
   /* Might be a full pathspec, C:\EDIT\PRN, and still go to a device! */
   indx = lastpos('\',name)
   if not indx then indx = lastpos(':',name) endif
   if indx then name=substr(name,indx+1) endif
   indx = pos('.',name)
   if indx then name=substr(name,1,indx-1) endif
   return pos('.'upcase(name)'.','.PRN.LPT1.LPT2.LPT3.')

; This proc is called only by DEFC EDIT in messy-desk mode.
defproc create_window_for_each_file(emptyfileid)
   fileidlist=''
   activatefile emptyfileid /* Start list at beginning so we get 'em all.    */
   nextfile                 /* Except first one, can leave one in each ring. */
   loop
      nextfile
      .box=1
      getfileid fileid
      if fileid=emptyfileid then
	 leave
      endif
      fileidlist=fileidlist fileid
   endloop
   rest=fileidlist
   loop
      parse value rest with fileid rest
      if fileid='' then
	 leave
      endif
      rc=0
      newwindow fileid
      if rc then leave endif
      getfileid cur_fileid
      activatefile fileid
      quitview
      activatefile cur_fileid
   endloop

defproc ec_position_on_error   /* load file containing error */
   'xcom e 'TEMP_FILENAME
   if .last<=4 then
      getline msg,.last
      'xcom q'
   else
      -- jbl 8/23/89:  on DOS this next line was "getline msg,2".  Fix later.
      getline msg,1
      getline temp,.last
      parse value temp with 'col= ' col
      getline temp,.last-1
      parse value temp with 'line= ' line
      getline temp,.last-2
      parse value temp with 'filename=' filename
      'xcom q'
      'e 'filename               -- not xcom here, respect user's window style
      if line<>'' and col<>'' then
	 .cursory=15
	 if col>0 then
	    .col=col
	    .line=line
	 else
	    .line=line-1   /* sometimes the compiler is off by 1 */
	    getline s
	    .col=length(s) /* position cursor at end of previous line */
	 endif
      endif
   endif
   sayerror msg

defproc einsert_line
   insert;up;call pfirst_nonblank();down

defproc erasetemp(filename)
  if machine()='RTAIX' then
    quietshell  'rm 'arg(1)
  else
    quietshell   'xcom del 'arg(1)
  endif

; Note on a speed trick:  The following routine is used to both verify that
; an external program exists, and to get its path.  After that first search,
; the exact path location of the routine is known; it can be remembered so that
; all future calls can supply the exact location to avoid the path search.
; See SUBDIR for an example of its use.
defproc find_routine(utility)  -- Ver. 3.09:  split from SUBDIR
   findfile fully_qualified,utility,'PATH','P'
   if rc<>0 then
      sayerror 'Cannot find the 'utility' program.'
      stop
   endif
   return fully_qualified

defproc init_operation_on_commandline
   universal comsfileid,oldline
   if pcommand_state() then
      activatefile comsfileid
      oldline=.line
      getcommand line,col,scrollpos
      insertline line,.last+1
      .cursorx=col-scrollpos+1
      .col=col
      .line=.last
   endif

; Returns true if parameter given is a number.
; Leading and trailing spaces are ignored.
defproc isnum
   zzi=pos('-',arg(1))           -- Optional minus sign?
   if zzi then                   -- If there is one,
      parse arg zz1 '-' zz zz2   --   zz1 <- before it, zz <- number, zz2 <- after
   else
      parse arg zz zz1 zz2       --   zz <- number; zz1, zz2 <- after it
   endif
   zz=strip(zz)                  -- Delete leading & trailing spaces.
   if zz1||zz2 <> '' or          -- If there were more tokens on the line
      zz==''                     -- or if the result is null
   then return 0 endif           -- then not a number.
   return not verify(zz,'0123456789')

defproc isoption(var cmdline,optionletter)
   i=pos(argsep||upcase(optionletter),upcase(cmdline))
   if i then
      cmdline=substr(cmdline,1,i-1)||substr(cmdline,i+2)
      return 1
   else
      return 0
   endif

defproc leave_last_command
   if (not arg() or arg(2)) and arg(1) then
      cursor_command
      up
      for i = 1 to arg(1)-1
	 right
      endfor
   endif

;  Procedure to pick a temporary filename like ORIGNAME.$$1.
;  First argument is the filename, 2nd is the fileid.  Both are optional,
;  default to the current filename and fileid if absent.
;  Revised by BTTUCKER to catch all cases and work with E3EMUL.
defproc MakeTempName
   TempName  = arg(1)
   extension = arg(2)
   if TempName = '' then   /* if no arg given, default to current filename */
      TempName = .filename
   endif
   if TempName = '' then
      TempName = '$'       /* new file? o.k. then $  */
   else /* We want only PC file name, VM filename, or MVS firstname          */
	/* These next statements will strip everything else off...           */
     dot=pos('.',TempName)                          /* PC or MVS filename    */
     if dot then TempName=substr(TempName,1,dot-1) endif
     space = pos(' ',TempName)                      /* VM filename           */
     if space then TempName=substr(TempName,1,space-1) endif
     slash = lastpos('\',TempName)                  /* PC filename with path */
     if slash then TempName=substr(TempName,slash+1) endif
     colon = pos(':',TempName)                      /* VM or MVS filename    */
     if colon then TempName=substr(TempName,colon+1) endif
     quote = pos("'",TempName)                      /* MVS filename          */
     if quote then TempName=substr(TempName,quote+1) endif
   endif

   TempName = TEMP_PATH||TempName  /* append temp_path, if any, from stdcnf.e*/
   if extension='' then            /* default is current fileid              */
      getfileid extension
   endif
   extension = '$$' || extension
   if length(extension)>3 then     /* could be >one digit, or something else */
      extension=substr(extension,2,3)
   endif
   return TempName'.'extension

defproc max(a,b)  -- Ver. 3.09:  Support as many arguments as E3 will allow.
   maximum=a
   do i=2 to arg()
      if maximum<arg(i) then maximum=arg(i); endif
   end
   return maximum

defproc maybe_autosave
   universal autosave,lines_entered
   if autosave then
      lines_entered = lines_entered +1
      if lines_entered >= autosave then
	 'xcom save 'MakeTempName()  -- Ver. 3.09a:  added XCOM
	 .modify=1                  /* Reraise the modify flag. */
	 lines_entered =0
      endif
   endif

defproc message
   getfileid fileid
   sayerror arg(1)
   activatefile fileid

; Print message and wait for a key press.
; Preserve active file and activate ring.
; Note:  There is no need to use "call" to invoke this procedure,  since it
; returns the null string.  Execution of a null string does nothing
defproc messageNwait
   getfileid zzfileid
   sayerror arg(1)
   call getkey()
   activatefile zzfileid

; Mgetkey() acts the same as a call to getkey(), but first checks
; whether we're in mid-execution of a key-string (Ctrl-R/Ctrl-T).
; If so it gets the next key from the string.  Call this in place of
; getkey() if you want the user to be able to record the response.
; Don't call this for unusual inputs, such as messageNwait after errors.
;
; Optional argument is prompt string, will be displayed on status line.
defproc mgetkey()
   universal Kstring,inKstring          /* See c_r in STDKEYS.E. */
   prompt=arg(1)
   if prompt<>'' and inKstring<=0 then
      sayerror prompt
   endif
   if inKstring=0 then     /* If not recording or replaying, normal input. */
      k=getkey()
   elseif inKstring=-1 then /* If recording, stash key in string.          */
      k=getkey()
      Kstring=Kstring||k   /* Trust that it doesn't get longer than 255.   */
   else           /* inKstring>0 ==> replaying; get next key from Kstring. */
      k=substr(Kstring,inKstring,1)
      ksize=1
      if k==substr(esc,1,1) then       /* extended key ? */
	 k=substr(Kstring,inKstring,2) /* Yes, 2 bytes for extended key.   */
	 ksize=2
      endif
      inKstring=inKstring+ksize        /* bump index AFTER execution */
   endif
   if prompt<>'' and inKstring<=0 then
      sayerror 0
   endif
   return k

defproc min(a,b)  -- Ver. 3.09:  Support as many arguments as E3 will allow.
   minimum=a
   do i=2 to arg()
      if minimum>arg(i) then minimum=arg(i); endif
   end
   return minimum

defproc move_results_to_commandline
   universal oldline
   if pcommand_state() then
      getline line
      deleteline
      setcommand line,.col,.col-.cursorx+1
      .line=oldline
   endif

; The following two routines (from Larry Margolis) let the
; user decide what action should be taken when the Enter and Ctrl-Enter
; keys are pressed.  The possible values for the action constants are
; defined in STDCNF.
;
; (But on aix we can't get Ctrl-Enter.  jbl)
;
compile if C_ENTER_ACTION        -- If null, don't define - user will supply.
defproc my_c_enter
   compile if C_ENTER_ACTION = 'ADDATEND' | C_ENTER_ACTION = 'DEPENDS+'
   if .line = .last then         -- If we're on the last line, then add a line.
      call maybe_autosave()
      call einsert_line()
      down                       -- This keeps the === Bottom === line visible.
   else
   compile endif

   compile if C_ENTER_ACTION = 'DEPENDS' | C_ENTER_ACTION = 'DEPENDS+'
   if insert_state() then        -- DEPENDS means if insertstate() then ...
   compile endif

   compile if C_ENTER_ACTION = 'NEXTLINE' | C_ENTER_ACTION = 'DEPENDS' |
	      C_ENTER_ACTION = 'ADDATEND' | C_ENTER_ACTION = 'DEPENDS+'
   down                          -- go to next line
   begin_line
   compile endif

   compile if C_ENTER_ACTION = 'DEPENDS' | C_ENTER_ACTION = 'DEPENDS+'
   else                          -- otherwise ...
   compile endif

   compile if C_ENTER_ACTION = 'ADDLINE' | C_ENTER_ACTION = 'DEPENDS' | C_ENTER_ACTION = 'DEPENDS+'
   call maybe_autosave()
   call einsert_line()           -- insert a line
   compile endif

   compile if C_ENTER_ACTION = 'DEPENDS' | C_ENTER_ACTION='ADDATEND' | C_ENTER_ACTION = 'DEPENDS+'
   endif
   compile endif

   compile if C_ENTER_ACTION = 'DEPENDS+'
   endif
   compile endif
compile endif

compile if ENTER_ACTION          -- If null, don't define - user will supply.
defproc my_enter
   if command_state() then
      execute
 compile if ENTER_ACTION = 'ADDATEND' | ENTER_ACTION = 'DEPENDS+'
   elseif .line = .last then     -- If we're on the last line, then add a line.
      call maybe_autosave()
      call einsert_line()
      down                       -- This keeps the === Bottom === line visible.
 compile endif
   else
      compile if ENTER_ACTION = 'DEPENDS' | ENTER_ACTION = 'DEPENDS+'
      if insert_state() then     -- DEPENDS means if insertstate() then ...
      compile endif

      compile if ENTER_ACTION = 'ADDLINE' | ENTER_ACTION = 'DEPENDS' | ENTER_ACTION = 'DEPENDS+'
      call maybe_autosave()
      call einsert_line()        -- insert a line
      compile endif

      compile if ENTER_ACTION = 'DEPENDS' | ENTER_ACTION = 'DEPENDS+'
      else                       -- otherwise ...
      compile endif

      compile if ENTER_ACTION = 'NEXTLINE' | ENTER_ACTION = 'DEPENDS' |
	         ENTER_ACTION = 'ADDATEND' | ENTER_ACTION = 'DEPENDS+'
      down                       -- go to next line
      begin_line
      compile endif

      compile if ENTER_ACTION = 'DEPENDS' | ENTER_ACTION = 'DEPENDS+'
      endif
      compile endif
   endif
compile endif



;  A common routine to parse an argument string containing a mix of
;  options and DOS file specs.  The DOS file specs can contain an "=" for the
;  path or the fileid, which will be replaced by the corresponding part of the
;  previous file (initially, the current filename).
defproc parse_file_n_opts(argstr)
   prev_filename = .filename
   output = ''
   do while argstr<>''
      parse value argstr with filename argstr
      if substr(filename,1,1)<>argsep then
	 call parse_filename(filename,prev_filename)
	 prev_filename = filename
      endif
      output = output filename
   end
   return substr(output,2)

;  A common routine to parse a DOS file name.  Optional second argument
;  gives source for = when used for path or fileid.  RC is 0 if successful, or
;  position of "=" in first arg if no second arg given but was needed.

;@@ jbl 6/22/89:  accept initial tilde (~) to stand for home directory on AIX.
;   And also the other unshifted character on that key (`) -- I'm lazy.
definit  -- determine home directory at startup
   universal home_directory
   quietshell 'dos echo $HOME>'TEMP_FILENAME
   'xcom edit 'argsep'q 'TEMP_FILENAME
   quietshell 'rm 'TEMP_FILENAME
   getline home_directory
   'xcom q'
   sayerror 0

defproc parse_filename(var filename)
   universal home_directory
   if verify(substr(filename,1,1), '~`', 'M') then
      filename=home_directory || substr(filename,2)
   endif

   sourcefile = strip(arg(2))
   if sourcefile='' then return pos('=',filename) endif

   if filename='=' then filename=sourcefile; return 0; endif

   lastsep = lastpos('/' /* '\' */ ,sourcefile)
   if not lastsep & substr(sourcefile,2,1) = ':' then lastsep=2; endif

   /* E doesn't handle the = prefix if it's on the first file given on      */
   /* the E command line.  This replaces = with path of current file.  LAM  */
   if substr(filename,1,1) = '=' & lastsep then
      if substr(filename,2,1) = '.' then filename='='filename endif
      filename=substr(sourcefile,1,lastsep) || substr(filename,2)
   endif

   /* Also accept '=' after the pathspec, like 'c:\bat\='. */
   /* Ver 3.09:  Or c:\bat\=.bat or c:\doc\new.=           */
   p = pos('=',filename)
   if p > 1 then
      sourcefileid=substr(sourcefile,max(lastsep+1,1))
      parse value sourcefileid with sourcefilename '.' sourcefileext
      lastsep2 = lastpos('/' /* '\' */,filename)
      if not lastsep2 & substr(filename,2,1) = ':' then lastsep2=2; endif
      dot1=pos('.',filename,max(lastsep2,1))
      firstpart=substr(filename,1,p-1)
      if dot1 then
	 if dot1<p then  -- filename.=
	    filename= firstpart || sourcefileext
	 else            -- =.ext
	    filename= firstpart || sourcefilename || substr(filename,dot1)
	 endif
      else            -- d:\path\         ||        filename.ext
	 filename= firstpart || sourcefileid
      endif -- dot1
   endif -- p > 1
   return 0

;  This proc is called by DEFC EDIT.
;  Does *not* assume all options are specified before filenames.
defproc parse_leading_options(var rest,var options)
   options=''
   loop
      parse value rest with word more
      if substr(rest,1,1)= argsep /* '/' */ then
	 options = options word
	 rest = more
      else
	 leave
      endif
   endloop


; PBEGIN_MARK: this procedure moves the cursor to the first character of the
; mark area.  If the mark area is not in the active file, the marked file is
; activated.

defproc pbegin_mark
   call checkmark()
   getmark  firstline,lastline,firstcol,lastcol,fileid
   activatefile fileid
   cursor_data
   if marktype()='LINE' then
      .line=firstline
   else
      .col=firstcol;.line=firstline
   endif


; PBEGIN_WORD: moves the cursor to the beginning of the word if the cursor is on
; this word.  If it's not on a word, it's moved to the beginning of the first
; word on the left.  If there is no word on the left it's moved to the beginning
; of the word on the right.  If the line is empty the cursor doesn't move.

defproc pbegin_word
   getline line,.line
   if  substr(line,.col,1)=' ' then
      p=verify(line,' ')       /* 1st case: the cursor on a space */
      if p>=.col then
	 .col=p
      else
	 if p then
	    q=p
	    loop
	       p=verify(line,' ','M',p)
	       if not p or p>.col then leave endif
	       p=verify(line,' ','',p)
	       if not p or p>.col then leave endif
	       q=p
	    endloop
	    .col=q
	 endif
      endif
   else
      if .col<>1 then          /* 2nd case: not on a space */
	 .col=lastpos(' ',line,.col)+1
      endif
   endif


; PBLOCK_REFLOW: reflow the text in the marked area.  Then the destination block
; area must be selected and a second call to this procedure reflow the source
; block in the destination block.  The source block is fill with spaces.
;   option=0 saves the marked block in temp file
;   option=1 reflow temp file text and copies it to marked area

defproc pblock_reflow(option,var space,var tempofid)
   call checkmark()
   if option<>1 then
      usedmk=marktype()
      getmark  firstline1,lastline1,firstcol1,lastcol1,fileid1
      /* move the source mark to a temporary file */
      'xcom e  'argsep'q 'argsep'n 'argsep'h .tempo'
      sayerror 1
      getfileid tempofid
      activatefile tempofid
      call pcopy_mark(destfirstline,destlastline,destfirstcol,destlastcol)
      activatefile fileid1
      cursor_data
      call pset_mark(firstline1,lastline1,firstcol1,lastcol1,usedmk,fileid1)
      if usedmk='LINE' then
	 begin_line
      endif
      space=usedmk firstline1 lastline1 firstcol1 lastcol1 fileid1
      return 0
   else
      if marktype() <> 'BLOCK' then
	 sayerror 'Block mark required'
	 return 1
      endif
      parse value space with usedmk firstline1 lastline1 firstcol1 lastcol1 fileid1
      getmark  firstline2,lastline2,firstcol2,lastcol2,fileid2
      /* fill source with space */
      if usedmk='LINE' then
	 for i = firstline1 to lastline1
	    replaceline '',i,fileid2
	 endfor
      else
	 call pset_mark(firstline1,lastline1,firstcol1,lastcol1,usedmk,fileid1)
	 call pfill_mark(' ')
      endif
      call pset_mark(firstline2,lastline2,firstcol2,lastcol2,'BLOCK',fileid2)
      delete_mark
      /* let's reflow in the hidden file */
      activatefile tempofid
      width = lastcol2+1-firstcol2
      height = lastline2+1-firstline2
      savemargins= pmargins()
      'xcom ma 1 'width
      unmark; mark_line; .line=.last; mark_line
      reflow
      'xcom ma 'savemargins
      nbl = .last
      /* go back to the destination */
      activatefile fileid2
      if nbl > height then
	 fix = nbl-height
	 getline line,lastline2
	 for i = 1 to fix
	    insertline line,lastline2+1
	 endfor
      elseif nbl < height then
	 fix=0
	 for i = nbl+1 to height
	    insertline '',tempofid.last+1,tempofid
	 endfor
	 nbl=height
      else
	 fix=0
      endif
      call pset_mark(1,nbl,1,width,'BLOCK',tempofid)
      .line=firstline2; .col=firstcol2; copy_mark; unmark
      call pset_mark(firstline2,lastline2+fix,firstcol2,lastcol2,'BLOCK',fileid2)
      /* release tempo */
      activatefile tempofid
      .modify=0
      'xcom q'
      activatefile fileid2
      sayerror 1
    endif


; PCENTER_MARK: center the strings between the block marks

defproc pcenter_mark
   if  marktype() = 'BLOCK' then
      getmark  firstline,lastline,firstcol,lastcol,fileid
   elseif marktype() = 'LINE' then
      getmark  firstline,lastline,firstcol,lastcol,fileid
      parse value pmargins() with  firstcol lastcol .
   elseif marktype() = '' then
      getfileid fileid
      parse value pmargins() with  firstcol lastcol .
      firstline=.line;lastline=.line
   else
      sayerror 'Character mark invalid'
      stop
   endif
   sz = lastcol+1-firstcol
   for i=firstline to lastline
      getline line,i,fileid
      inblock=strip(substr(line,firstcol,sz),'B')
      if inblock='' then iterate endif
      replaceline substr(line,1,firstcol-1) ||
	 substr(substr('',1,(sz-length(inblock))/2)||inblock,1,sz) ||
	 substr(line,lastcol+1) ,i,fileid
   endfor

defproc pcommand_state
  if .col<windowwidth() then
    oldcol=.col;right;newcol=.col
    left
  else
    oldcol=.col;left;newcol=.col
    right
  endif
  return(oldcol=newcol)


; PCOMMON_TAB_MARGIN: subroutine common to ptabs and pmargins

defproc pcommon_tab_margin(TabOrMargins)
   universal comsfileid

   getfileid fileid
   /* preserve the state and go to command line */
   if not pcommand_state() then
      cursor_command;begin_line;erase_end_line
      flg=0
   else
      flg=1
   endif
   /* the tricky stuff : execute ma (or tabs) and get the result in coms.e file */
   keyin TabOrMargins;execute;execute
   activatefile comsfileid
   getline lastcmdline,.last
   /* remove the two commands we did */
   deleteline .last
   deleteline .last
   activatefile fileid
   /* restore the state */
   if not flg then cursor_data endif
   /* get the stuff we want */
   parse value lastcmdline with . val
   return val


; PDISPLAY_MARGINS: put the margins mark on the current line

defproc pdisplay_margins()
   i=insert_state()
   if i then insert_toggle endif
   call psave_pos(save_pos)
   insert
   parse value pmargins() with lm rm pm .
   .col=lm;keyin'L';.col=pm;keyin'P';.col=rm;keyin'R'
   begin_line
   call prestore_pos(save_pos)
   if i then insert_toggle endif
   return 0


; PDISPLAY_TABS: put the tab stops on the current line

defproc pdisplay_tabs()
   i=insert_state()
   if i then insert_toggle endif
   call psave_pos(save_pos)
   insert
   tabstops = ptabs()
   do forever
      parse value tabstops with tabx tabstops
      if tabx = '' then leave endif
      .col=tabx
      keyin'T'
   end
   begin_line
   call prestore_pos(save_pos)
   if i then insert_toggle endif
   return 0


; PEND_MARK: moves the cursor to the end of the marked area

defproc pend_mark
   call checkmark()
   getmark  firstline,lastline,firstcol,lastcol,fileid
   activatefile fileid
   cursor_data
   if marktype()='LINE' then
      .line=lastline
   else
      .col=lastcol;.line=lastline
   endif


; PEND_WORD: moves the cursor to the end of the word if the cursor is on this
; word.  If it's not on a word, it's moved to the end of the first word on the
; right.  If there is no word on the right it's moved to the end of the word on
; the left.  If the line is empty the cursor doesn't move.

defproc pend_word
   getline line,.line
   if  substr(line,.col,1)=' '  then
      if substr(line,.col)=' ' then
	 if  line<> ' ' then
	    for i=.col to 2 by -1
	       if substr(line,i-1,1)<>' ' then leave endif
	    endfor
	   .col=i-1
	 endif
      else
	 p=verify(line,' ','',.col)
	 p=verify(line' ',' ','M',p)
	 .col=p-1
      endif
   else
      if .col<>255 then
	 i=pos(' ',line,.col)
	 if i then
	    .col=i-1
	 else
	    .col=length(line)
	 endif
      endif
   endif

defproc pfile_exists /* Check if file already exists in ring */
   if substr(arg(1),2,1)=':'  then
      /* parse off drive specifier and try again */
      getfileid zzfileid,substr(arg(1),3)
   else
      getfileid zzfileid,arg(1)
   endif
   if zzfileid/=='' then return 1 endif
   return 0

defproc pfind_blank_line
   -- Find first blank line after the current one.  Make that the new current
   -- line.  If no such line is found before the end of file, don't change the
   -- current line.
   for i = .line+1 to .last
      getline line,i
      -- Ver 3.11:  Modified to respect GML tags:  stop at first blank line
      -- or first line with a period or a colon (".:") in column 1.
      if line='' or not verify(substr(line,1,1), ".:" ) then
	 .line=i
	 leave
      endif
   endfor

defproc pfirst_nonblank
   /* different from PE */
   if not .line then .col=1
   else
      getline line
      zz=verify(line,' ')
      if zz then .col=zz else .col=1 endif
   endif

; PLOWERCASE: force to lowercase the marked area
defproc plowercase
   call checkmark()
   /* invoke pinit_extract, pextract_string, pput_string_back to do the job */
   call psave_pos(save_pos)
   call pinit_extract()
   do forever
      code = pextract_string(string)
      if code = 1 then leave; endif
      if code = 0 then
	 string = lowcase(string)
	 call pput_string_back(string)
      endif
   end
   call prestore_pos(save_pos)

; PMARGINS: return the current margins setting. (Uses pcommon_tab_margin)
defproc pmargins
   return pcommon_tab_margin('ma')

; PMARK: mark at the cursor position (mark type received as argument).  Used by
; pset_mark
defproc pmark(mt)
   if mt= 'LINE' then
      mark_line
   else
      if mt = 'CHAR' then
	 mark_char
      else
	 mark_block
      endif
   endif

; PMARK_WORD: mark the word pointed at by the cursor.  If the cursor is on a
; space, the word at the right is marked.  If there is no word on the right, the
; word on the left is marked.
defproc pmark_word
   if marktype()<>'' then
      sayerror 'Text already marked'
      stop
   endif
   call pend_word()
   mark_block
   call pbegin_word()
   mark_block

; PRESTORE_MARK: restore the current marks (cannot be used as a stack) See also
; psave_mark
defproc prestore_mark(savemark)
   unmark
   parse value savemark with savefirstline savelastline savefirstcol savelastcol savemkfileid savemt
   if savemt<>'' then
      call pset_mark(savefirstline,savelastline,savefirstcol,savelastcol,savemt,savemkfileid)
   endif

; PRESTORE_POS: restore the cursor position (cannot be used as a stack) See
; also psave_pos()
; Ver. 3.09:  Fix bug if view shifted within window.  Found by Joe Simone.
defproc prestore_pos(save_pos)
   parse value save_pos with svline svcol svcx svcy
   .cursorx = svcx; .cursory = svcy; .col = svcol
   if svline>.last then
      .line=.last
   else
      .line = svline
   endif
   if svcx>.cursorx then               -- View shifted to left within window.
      .col=1;.col=svcol;.cursorx=svcx
   elseif svcx<.cursorx then           -- View shifted to right within window.
      .col=255;.col=svcol;.cursorx=svcx
   endif

;  Printer_ready( printer_number ) tests whether printer is ready.
;
;  Enter with printer_number = 1 for the first printer (LPT1), 2 for LPT2.
;  No argument at all defaults to LPT1.
;
;  Returns 1 (true)  for printer attached and ready.
;  Returns 0 (false) for printer not attached or not ready.
;
;  Note:  Assumes the standard BIOS responses for an IBM PC.
;  The BIOS responds with AH=90 hex for printer ready.
;  Might not work on clones and other strange machines.
;
;  If we're on OS/2 we don't check because the spooler protects us from
;  a hang if the printer's off-line.  We always return "ready" on OS/2.
;
defproc printer_ready
   if machine()<>"PCDOS" then return 1 endif /* always ready on OS/2 and AIX */

; PSAVE_MARK: save the current marks (cannot be used as a stack) See also
; prestore_pos()
defproc psave_mark(var savemark)
   savemt=marktype()
   if savemt then
      getmark  savefirstline,savelastline,savefirstcol,savelastcol,savemkfileid
      unmark
      savemark=savefirstline savelastline savefirstcol savelastcol savemkfileid savemt
   else
      savemark=''
   endif

; PSAVE_POS: save the cursor position (cannot be used as a stack) See also
; prestore_pos()
defproc psave_pos(var save_pos)
   save_pos=.line .col .cursorx .cursory

defproc pset_mark(firstline,lastline,firstcol,lastcol,mt,fileid)
   getfileid actfileid    /* preserve current active fileid */
   activatefile fileid
   call psave_pos(save_pos)
   unmark
   .col=lastcol ; .line=lastline
   call  pmark(mt)
   .col=firstcol; .line=firstline
   call  pmark(mt)
   call prestore_pos(save_pos)
   activatefile actfileid         /* restore the initial active file */


;  jbl 9/1/89 added for aix.  See defc list in stdcmds.e for usage.
;  Resolve a possibly-relative dirname.  In DEFC LIST, for example, we don't
;  want a relative path like  "..", because if we changed our current directory
;  the Alt-1 key wouldn't work any more.  Turn into absolute path with
;  the directory() function.
defproc resolve_path(dirname)
   save_cur_dir = directory()    -- Save current directory.
   rc = 0      -- Directory() is one of those procs that sets RC only if error.
   fulldir = directory(dirname)
   if rc then  -- Current directory didn't change.
      sayerror "Invalid directory name "dirname
      return ''
   endif
   call directory(save_cur_dir) -- Restore.
   return fulldir


defproc restore_command_state(cstate)
   if pcommand_state()<>cstate then
      command_toggle
   endif

defproc save_command_state(var cstate)
   cstate=pcommand_state()
   cursor_data
   refresh            /* Force E to update the cursor position */

; Note:  This does not tabify the entire file; it just replaces 8 blanks
; in the first column with a tab character.
defproc savefilewithtabs(filename)
   options=arg(2)
   call psave_pos(save_pos)
   getfileid fileid
   call psave_mark(save_mark)
   unmark;bottom;markline;top;markline
   call prestore_pos(save_pos)
   'xcom e 'argsep'n .';deleteline
   if rc and rc<>sayerror("new file") then
      return rc
   endif
   rc=0
   copymark
   if rc then return rc endif
   unmark
   top;.col=1;markblock;bottom;.col=8;markblock
   .col=1;top
   'c/        /'\t'/m*'     /* replace first column 8 spaces with tab */
   sayerror 1  /* Turn off pending messages */
   unmark
   savestatus=savefile(filename,options)
   .modify=0
   'xcom q'
   if savestatus then return savestatus endif
   activatefile fileid
   call prestore_mark(save_mark)
   if filename=.filename then
      .modify=0
   endif
   return 0

; Note on a speed trick:  subdir_present is initialized to null at start-up.
; This causes defproc subdir(), the first time it's called, to execute a
; FINDFILE (by way of find_routine) to search the path for the subdir program.
; (See DEFC HELP for another example of findfile.)
; After that first search the exact path location of subdir is known; it's
; remembered in the universal variable subdir_present.  All future calls supply
; the exact location (as in "C:\UTIL\SUBDIR.COM") to avoid the path search.
;
definit  /* Keep this definit close to the proc it serves. */
   universal subdir_present
   subdir_present=''

defproc subdir
   universal subdir_present
   subdir_args = arg(1)

   if machine()='RTAIX' then
      quietshell 'ls 'subdir_args
      return ''
   endif
   if machine()='OS2PROTECT' then
      utility = 'FILEFIND'
   else
      utility = 'SUBDIR'
      subdir_args = '/Q' subdir_args
   endif
   if subdir_present='' then subdir_present=find_routine(utility); endif
   quietshell subdir_present subdir_args

; PTABS: return the current tabs setting. (Uses pcommon_tab_margin)
defproc ptabs
   return pcommon_tab_margin('tabs')

; PUPPERCASE: force to uppercase the marked area
defproc puppercase
   call checkmark()
   /* invoke pinit_extract, pextract_string, pput_string_back to do the job */
   call psave_pos(save_pos)
   call pinit_extract()
   do forever
      code = pextract_string(string)
      if code = 1 then leave endif
      if code = 0 then
	 string = upcase(string)
	 call pput_string_back(string)
      endif
   end
   call prestore_pos(save_pos)

defproc remove_trailing_spaces
   /* This is no longer used by any file in standard E.  Use strip()  */
   /* instead.  But left here for compatibility with older procs.     */
   return strip(arg(1),'T')

defproc windowheight
  return(.windowheight)

defproc windowwidth
  return(.windowwidth)
/* screenheight should be and internal function of E interpreter */

