/* Private data for Ga3270 widget */

#ifndef _Ga3270P_h
#define _Ga3270P_h

#include "Ga3270.h"
#include "Win3270P.h"

/* New fields for the Ga3270 widget record */
typedef struct {
    Pixel drawColor;
    Pixel drawstyle[15];
    Pixel refreshColor;
    Cursor gaCursor;
    XtTranslations *gaTranslations;
    XColor colors[32];
    Boolean lottaplanes;	/* True if we have 5 planes */
    Boolean colormode;		/* True if we have more than two colors */
    GC draw_gc;			/* Graphics context for drawing */
    GC ref_gc;			/* Graphics context for drawing refresh data */
    GC refclear_gc;		/* Graphics context for clearing refresh */
    GC oldgc;			/* Graphics context used for last line */
    int oldtype;		/* Line type of last line drawn */
    int oldinten;		/* Intensity of last line drawn */
} Ga3270Part;

/* Full instance record declaration */
typedef struct _Ga3270Rec {
    CorePart	core;
    Win3270Part	win3270;
    Ga3270Part	ga3270;
} Ga3270Rec;

/* New fields for the Ga3270 widget class record */
typedef struct { int empty; } Ga3270ClassPart;

/* Full class record declaration */
typedef struct _Ga3270ClassRec {
    CoreClassPart    core_class;
    Win3270ClassPart win3270_class;
    Ga3270ClassPart  ga3270_class;
} Ga3270ClassRec;

/* Class record variable */
extern Ga3270ClassRec ga3270ClassRec;

#endif /* _Ga3270P_h */
