/* Private data for 3270 screen title widget */

#ifndef _XtTitle3270P_h
#define _XtTitle3270P_h

#include "Title3270.h"
#include <X11/CoreP.h>

/* New fields for the Title3270 widget record */
typedef struct {
    /* Resources */
    Pixel	foreground;
    XFontStruct	*font;
    char 	*title;
    Pixel 	cursorColor;
    Cursor 	cursor;
    Dimension	iwidth;
    Dimension	iheight;
    Boolean	inserting;
    Boolean	system;
    Boolean     aplkeyb;

    /* Private state */
    GC		gc;
    Dimension	txtheight;	/* Height of a text string */
    Position	tx, ty;		/* Title position */
    Dimension	twidth;		/* Title width */
    Position    kx, ky;         /* Keyboard indicator position */
    Dimension   kwidth;         /* Keyboard indicator width */
    Position	sx, sy;		/* System string position */
    Dimension	swidth;		/* System string width */
    Position	ax, ay;		/* Insert indicator position */
    Dimension	awidth;		/* Insert indicator width */
} Title3270Part;


/* Full instance record declaration */
typedef struct _Title3270Rec {
    CorePart	    core;
    Title3270Part   title3270;
} Title3270Rec;

/* New fields for the Title3270 widget class record */
typedef struct { int empty; } Title3270ClassPart;

/* Full class record declaration */
typedef struct _Title3270ClassRec {
    CoreClassPart	core_class;
    Title3270ClassPart  title3270_class;
} Title3270ClassRec;

/* Class record variable */
extern Title3270ClassRec title3270ClassRec;

#endif /* _XtTitle3270P_h */


